/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.dispatch;

import java.io.Serializable;

public final class ConnectionStateEnum
implements Serializable {
    private final int connectionState;
    public static final ConnectionStateEnum UNDEF = new ConnectionStateEnum(-1);
    public static final ConnectionStateEnum ALIVE = new ConnectionStateEnum(0);
    public static final ConnectionStateEnum POLLING = new ConnectionStateEnum(1);
    public static final ConnectionStateEnum DEAD = new ConnectionStateEnum(2);
    private static final ConnectionStateEnum[] connectionStateEnumArr = new ConnectionStateEnum[]{UNDEF, ALIVE, POLLING, DEAD};

    private ConnectionStateEnum(int connectionState) {
        this.connectionState = connectionState;
    }

    public String toString() {
        switch (this.connectionState) {
            case -1: {
                return "UNDEF";
            }
            case 0: {
                return "ALIVE";
            }
            case 1: {
                return "POLLING";
            }
            case 2: {
                return "DEAD";
            }
        }
        return "" + this.connectionState;
    }

    public final int getInt() {
        return this.connectionState;
    }

    public static final ConnectionStateEnum toConnectionStateEnum(int connectionState) throws IllegalArgumentException {
        if (connectionState < -1 || connectionState > 2) {
            throw new IllegalArgumentException("ConnectionStateEnum: The given connectionState=" + connectionState + " is illegal");
        }
        return connectionStateEnumArr[connectionState];
    }

    public static final ConnectionStateEnum parseConnectionState(String state) throws IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException("ConnectionStateEnum: Given connectionState is null");
        }
        state = state.trim();
        try {
            int connectionState = new Integer(state);
            return ConnectionStateEnum.toConnectionStateEnum(connectionState);
        }
        catch (NumberFormatException e) {
            state = state.toUpperCase();
            if (state.startsWith("UNDEF")) {
                return UNDEF;
            }
            if (state.startsWith("ALIVE")) {
                return ALIVE;
            }
            if (state.startsWith("POLLING")) {
                return POLLING;
            }
            if (state.startsWith("DEAD")) {
                return DEAD;
            }
            throw new IllegalArgumentException("ConnectionStateEnum:  Wrong format of <connectionState>" + state + "</connectionState>, expected one of UNDEF|ALIVE|POLLING|DEAD");
        }
    }

    public static final ConnectionStateEnum parseConnectionState(String connectionState, ConnectionStateEnum defaultConnectionState) {
        try {
            return ConnectionStateEnum.parseConnectionState(connectionState);
        }
        catch (IllegalArgumentException e) {
            System.out.println("ConnectionStateEnum: " + e.toString() + ": Setting connectionState to " + defaultConnectionState);
            return defaultConnectionState;
        }
    }
}

