/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.dispatch;

import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.dispatch.DispatchConnectionsHandler;
import org.xmlBlaster.util.qos.StatusQosData;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public abstract class DispatchConnection
implements I_Timeout {
    public final String ME;
    protected final Global glob;
    protected final LogChannel log;
    protected DispatchConnectionsHandler connectionsHandler = null;
    protected final String myId;
    protected AddressBase address;
    private Timestamp timerKey;
    private final Object PING_TIMER_MONITOR = new Object();
    protected ConnectionStateEnum state = ConnectionStateEnum.UNDEF;
    protected int retryCounter = 0;
    private final long logEveryMillis;
    private int logInterval = 10;
    protected boolean serverAcceptsRequests = false;
    protected boolean physicalConnectionOk = false;

    public DispatchConnection(Global glob, DispatchConnectionsHandler connectionsHandler, AddressBase address) {
        if (address == null) {
            throw new IllegalArgumentException("DispatchConnection expects an address!=null");
        }
        this.ME = "DispatchConnection-" + connectionsHandler.getDispatchManager().getQueue().getStorageId();
        this.glob = glob;
        this.log = glob.getLog("dispatch");
        this.logEveryMillis = glob.getProperty().get("dispatch/logRetryEveryMillis", 60000L);
        this.connectionsHandler = connectionsHandler;
        this.myId = connectionsHandler.getDispatchManager().getQueue().getStorageId().getId();
        this.address = address;
    }

    public void setAddress(AddressBase address) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "setAddress: configuration has changed (with same url) set to new address object");
        }
        this.address = address;
    }

    public abstract String getName();

    public final void initialize() throws XmlBlasterException {
        this.retryCounter = 0;
        try {
            this.connectLowlevel();
            this.handleTransition(true, null);
        }
        catch (XmlBlasterException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, e.getMessage());
            }
            if (e.isCommunication()) {
                this.handleTransition(true, e);
            }
            this.connectionsHandler.toDead(this, e);
            throw e;
        }
        catch (Throwable throwable) {
            XmlBlasterException e;
            XmlBlasterException xmlBlasterException = e = throwable instanceof XmlBlasterException ? (XmlBlasterException)throwable : new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "", throwable);
            if (this.log.TRACE) {
                this.log.trace(this.ME, e.toString());
            }
            this.connectionsHandler.toDead(this, e);
            throw e;
        }
        this.logInterval = this.logEveryMillis <= 0L ? -1 : (this.address.getDelay() < 1L || this.address.getDelay() > this.logEveryMillis ? 1 : (int)(this.logEveryMillis / this.address.getDelay()));
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Created driver for protocol '" + this.address.getType() + "'");
        }
    }

    public void finalize() {
        if (this.timerKey != null) {
            this.glob.getPingTimer().removeTimeoutListener(this.timerKey);
            this.timerKey = null;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "finalize - garbage collected");
        }
    }

    public final AddressBase getAddress() {
        return this.address;
    }

    public abstract void resetConnection();

    public abstract void loadPlugin() throws XmlBlasterException;

    public abstract void connectLowlevel() throws XmlBlasterException;

    public abstract String getDriverName();

    public abstract void doSend(MsgQueueEntry[] var1) throws XmlBlasterException;

    /*
     * Unable to fully structure code
     */
    public void send(MsgQueueEntry[] msgArr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "send(msgArr.length=" + msgArr.length + ")");
        }
        if (msgArr == null || msgArr.length == 0) {
            return;
        }
        if (this.isDead()) {
            this.log.error(this.ME, "Connection to " + this.address.toString() + " is in state DEAD, msgArr.length=" + msgArr.length + " messages are lost");
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_DEAD, this.ME, "Internal problem: Connection to " + this.address.toString() + " is in state DEAD, msgArr.length=" + msgArr.length + " messages are lost");
        }
        try {
            this.doSend(msgArr);
            this.handleTransition(true, null);
            return;
        }
        catch (XmlBlasterException e) {
            if (this.isPolling() && this.log.TRACE) {
                this.log.trace(this.ME, "Exception from update(), retryCounter=" + this.retryCounter + ", state=" + this.state.toString());
            }
            i = 0;
            ** while (i < msgArr.length)
        }
lbl-1000:
        // 1 sources

        {
            msgArr[i].incrRedeliverCounter();
            ++i;
            continue;
        }
lbl20:
        // 1 sources

        if (!e.isCommunication()) {
            this.handleTransition(true, e);
            throw e;
        }
        this.handleTransition(true, e);
        Thread.dumpStack();
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "This exception is never reached" + this.toXml(""));
    }

    public abstract String doPing(String var1) throws XmlBlasterException;

    public final String ping(String data) throws XmlBlasterException {
        return this.ping(data, true);
    }

    protected final String ping(String data, boolean byDispatchConnectionsHandler) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "ping(" + data + ")");
        }
        if (this.isDead()) {
            this.log.error(this.ME, "Protocol driver is in state DEAD, ping failed");
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_DEAD, this.ME, "Protocol driver is in state DEAD, ping failed");
        }
        data = data == null ? "" : data;
        try {
            StatusQosData qos;
            String returnVal = this.doPing(data);
            if (returnVal.length() > 0 && returnVal.indexOf("OK") == -1 && !"OK".equals((qos = this.glob.getStatusQosFactory().readObject(returnVal)).getState())) {
                throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_SERVERDENY, this.glob.getId(), this.ME, null, "Ping result: The server is in run level " + qos.getState() + " and not ready for requests", null, null, null, null, null, true);
            }
            if (this.log.TRACE && this.isAlive()) {
                this.log.trace(this.ME, "Success for ping('" + data + "'), return='" + returnVal + "'");
            }
            this.handleTransition(byDispatchConnectionsHandler, null);
            return returnVal;
        }
        catch (Throwable e) {
            if (this.isAlive() && this.log.TRACE) {
                this.log.trace(this.ME, "Exception from remote ping(), retryCounter=" + this.retryCounter + ", state=" + this.state.toString());
            }
            this.handleTransition(byDispatchConnectionsHandler, e);
            return "";
        }
    }

    protected abstract void reconnect() throws XmlBlasterException;

    public final void timeout(Object userData) {
        block17: {
            boolean isPing;
            if (this.isDead()) {
                return;
            }
            this.timerKey = null;
            boolean bl = isPing = userData == null;
            if (isPing) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "timeout -> Going to ping remote server, physicalConnectionOk=" + this.physicalConnectionOk + ", serverAcceptsRequests=" + this.serverAcceptsRequests + " ...");
                }
                try {
                    String result = this.ping("", false);
                }
                catch (XmlBlasterException e) {
                    if (this.isDead()) {
                        this.log.trace(this.ME, "We are shutdown already: " + e.toString());
                        break block17;
                    }
                    e.printStackTrace();
                    this.log.error(this.ME, "PANIC: " + e.toString());
                }
            } else {
                try {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "timeout -> Going to check if remote server is available again, physicalConnectionOk=" + this.physicalConnectionOk + ", serverAcceptsRequests=" + this.serverAcceptsRequests + " ...");
                    }
                    this.reconnect();
                    try {
                        String result = this.ping("", false);
                    }
                    catch (XmlBlasterException e) {
                        if (this.isDead()) {
                            this.log.trace(this.ME, "We are shutdown already: " + e.toString());
                            break block17;
                        }
                        e.printStackTrace();
                        this.log.error(this.ME, "PANIC: " + e.toString());
                    }
                }
                catch (Throwable e) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Polling for remote connection failed:" + e.getMessage());
                    }
                    if (this.logInterval > 0 && this.retryCounter % this.logInterval == 0) {
                        this.log.warn(this.ME, "No connection established, " + this.address.getLogId() + " still seems to be down after " + (this.retryCounter + 1) + " connection retries.");
                    }
                    try {
                        this.handleTransition(false, e);
                    }
                    catch (XmlBlasterException e2) {
                        e.printStackTrace();
                        this.log.error(this.ME, "PANIC: " + e.toString());
                    }
                }
            }
        }
    }

    protected final void handleTransition(boolean byDispatchConnectionsHandler, Throwable throwable) throws XmlBlasterException {
        boolean toReconnected;
        boolean bl = toReconnected = throwable == null;
        XmlBlasterException ex = throwable == null ? null : (throwable instanceof XmlBlasterException ? (XmlBlasterException)throwable : null);
        ConnectionStateEnum oldState = this.state;
        this.serverAcceptsRequests = ex == null ? true : !ex.isErrorCode(ErrorCode.COMMUNICATION_NOCONNECTION_SERVERDENY);
        boolean bl2 = this.physicalConnectionOk = ex == null || this.glob.isServerSide() && !ex.isServerSide() || !this.glob.isServerSide() && ex.isServerSide();
        if (ex != null) {
            toReconnected = !ex.isCommunication();
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Connection transition " + oldState.toString() + " -> toReconnected=" + toReconnected + " byDispatchConnectionsHandler=" + byDispatchConnectionsHandler + ": " + (ex == null ? "" : ex.toXml()));
        }
        DispatchConnection dispatchConnection = this;
        synchronized (dispatchConnection) {
            if (this.isDead()) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Connection transition " + oldState.toString() + " -> " + this.state.toString() + " for " + this.myId + ": We ignore it.");
                }
                throw XmlBlasterException.convert(this.glob, this.ME, "Connection transition " + oldState.toString() + " -> " + this.state.toString(), throwable);
            }
            if (toReconnected && this.isAlive()) {
                if (this.address.getPingInterval() > 0L) {
                    Object object = this.PING_TIMER_MONITOR;
                    synchronized (object) {
                        this.timerKey = this.glob.getPingTimer().addOrRefreshTimeoutListener(this, this.address.getPingInterval(), null, this.timerKey);
                    }
                }
                return;
            }
            if (this.timerKey != null) {
                this.glob.getPingTimer().removeTimeoutListener(this.timerKey);
                this.timerKey = null;
            }
            if (toReconnected && (this.isPolling() || this.isUndef())) {
                this.state = ConnectionStateEnum.ALIVE;
                this.retryCounter = 0;
                this.log.info(this.ME, "Connection '" + this.getAddress().getType() + "' transition " + oldState.toString() + " -> " + this.state.toString() + ": Success, " + this.myId + " connected.");
                if (this.address.getPingInterval() > 0L) {
                    this.timerKey = this.glob.getPingTimer().addTimeoutListener(this, this.address.getPingInterval(), null);
                }
                this.connectionsHandler.toAlive(this);
                return;
            }
            if (this.address.getRetries() == -1 || this.retryCounter < this.address.getRetries()) {
                this.state = ConnectionStateEnum.POLLING;
                ++this.retryCounter;
                if (this.address.getDelay() > 0L) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Polling for server with delay=" + this.address.getDelay() + " oldState=" + oldState + " retryCounter=" + this.retryCounter);
                    }
                    if (!this.physicalConnectionOk) {
                        this.resetConnection();
                    }
                    this.timerKey = this.glob.getPingTimer().addTimeoutListener(this, this.address.getDelay(), "poll");
                    if (oldState == ConnectionStateEnum.ALIVE || oldState == ConnectionStateEnum.UNDEF) {
                        String str = throwable != null ? ": " + throwable.toString() : "";
                        this.log.warn(this.ME, "Connection transition " + oldState.toString() + " -> " + this.state.toString() + ": " + this.address.getLogId() + " is unaccessible, we poll for it every " + this.address.getDelay() + " msec" + str);
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "Connection transition " + oldState.toString() + " -> " + this.state.toString() + " for " + this.myId + ": retryCounter=" + this.retryCounter + ", delay=" + this.address.getDelay() + ", maxRetries=" + this.address.getRetries() + str);
                        }
                        this.connectionsHandler.toPolling(this);
                    }
                    if (byDispatchConnectionsHandler) {
                        throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_POLLING, this.ME, "We are in polling mode, can't handle request. oldState=" + oldState);
                    }
                    return;
                }
                if (oldState == ConnectionStateEnum.ALIVE) {
                    this.resetConnection();
                    String str = throwable != null ? ": " + throwable.toString() : "";
                    this.log.warn(this.ME, "Connection transition " + oldState.toString() + " -> " + this.state.toString() + ": " + this.address.toString() + " is unaccessible" + str);
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Connection transition " + oldState.toString() + " -> " + this.state.toString() + " for " + this.myId + ": retryCounter=" + this.retryCounter + ", delay=" + this.address.getDelay() + ", maxRetries=" + this.address.getRetries() + str);
                    }
                }
            }
            this.state = ConnectionStateEnum.DEAD;
        }
        ex = throwable == null ? new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_DEAD, this.ME, "Connection transition " + oldState.toString() + " -> " + this.state.toString() + ": " + this.address.toString() + " is unaccessible.", throwable) : (throwable instanceof XmlBlasterException ? (XmlBlasterException)throwable : new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "Sending of messge failed", throwable));
        this.log.warn(this.ME, "Connection transition " + oldState.toString() + " -> " + this.state.toString() + ": retryCounter=" + this.retryCounter + ", maxRetries=" + this.address.getRetries());
        this.connectionsHandler.toDead(this, ex);
        if (byDispatchConnectionsHandler) {
            throw ex;
        }
    }

    public void shutdown() throws XmlBlasterException {
        this.state = ConnectionStateEnum.DEAD;
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering shutdown ...");
        }
        if (this.timerKey != null) {
            this.glob.getPingTimer().removeTimeoutListener(this.timerKey);
            this.timerKey = null;
        }
        this.retryCounter = 0;
    }

    public final ConnectionStateEnum getState() {
        return this.state;
    }

    public final boolean isUndef() {
        return this.state == ConnectionStateEnum.UNDEF;
    }

    public final boolean isAlive() {
        return this.state == ConnectionStateEnum.ALIVE;
    }

    public final boolean isPolling() {
        return this.state == ConnectionStateEnum.POLLING;
    }

    public final boolean isDead() {
        return this.state == ConnectionStateEnum.DEAD;
    }

    public abstract String toXml(String var1);
}

