/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.dispatch;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.dispatch.DispatchConnection;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.dispatch.DispatchStatistic;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public abstract class DispatchConnectionsHandler {
    public final String ME;
    protected final Global glob;
    protected final LogChannel log;
    protected final DispatchManager dispatchManager;
    protected final DispatchStatistic statistic;
    private ArrayList conList = new ArrayList();
    private final DispatchConnection[] DUMMY_ARR = new DispatchConnection[0];
    private ConnectionStateEnum state = ConnectionStateEnum.UNDEF;

    public DispatchConnectionsHandler(Global glob, DispatchManager dispatchManager) throws XmlBlasterException {
        this.ME = "DispatchConnectionsHandler-" + dispatchManager.getQueue().getStorageId();
        this.glob = glob;
        this.log = glob.getLog("dispatch");
        this.dispatchManager = dispatchManager;
        this.statistic = new DispatchStatistic();
    }

    public final DispatchManager getDispatchManager() {
        return this.dispatchManager;
    }

    public final void initialize(AddressBase[] cbAddr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Initialize old connections=" + this.conList.size() + " new connections=" + (cbAddr == null ? 0 : cbAddr.length));
        }
        ArrayList arrayList = this.conList;
        synchronized (arrayList) {
            if (cbAddr == null || cbAddr.length == 0) {
                int ii = 0;
                while (ii < this.conList.size()) {
                    ((DispatchConnection)this.conList.get(ii)).shutdown();
                    ++ii;
                }
                this.conList.clear();
                this.updateState(null);
                return;
            }
            ArrayList tmpList = (ArrayList)this.conList.clone();
            this.conList.clear();
            int ii = 0;
            while (ii < tmpList.size()) {
                boolean found = false;
                int jj = 0;
                while (jj < cbAddr.length) {
                    if (((DispatchConnection)tmpList.get(ii)).getAddress().isSameAddress(cbAddr[jj])) {
                        found = true;
                        break;
                    }
                    ++jj;
                }
                if (!found) {
                    DispatchConnection con = (DispatchConnection)tmpList.get(ii);
                    this.log.info(this.ME, "Shutting down callback connection '" + con.getName() + "' because of new configuration.");
                    con.shutdown();
                }
                ++ii;
            }
            int ii2 = 0;
            while (ii2 < cbAddr.length) {
                block22: {
                    boolean found = false;
                    int jj = 0;
                    while (jj < tmpList.size()) {
                        DispatchConnection tmpCon = (DispatchConnection)tmpList.get(jj);
                        if (cbAddr[ii2].isSameAddress(tmpCon.getAddress())) {
                            found = true;
                            tmpCon.setAddress(cbAddr[ii2]);
                            this.conList.add(tmpCon);
                            break;
                        }
                        ++jj;
                    }
                    if (!found) {
                        try {
                            DispatchConnection con = this.createDispatchConnection(cbAddr[ii2]);
                            try {
                                this.conList.add(con);
                                con.initialize();
                            }
                            catch (XmlBlasterException e) {
                                if (e.isCommunication()) {
                                    this.dispatchManager.toPolling(this.state);
                                    if (this.log.TRACE) {
                                        this.log.trace(this.ME, "Load " + cbAddr[ii2].toString() + ": " + e.getMessage());
                                    }
                                    break block22;
                                }
                                this.log.error(this.ME, "Can't load " + cbAddr[ii2].toString() + ": " + e.getMessage());
                                con.shutdown();
                                ((AbstractCollection)this.conList).remove(con);
                            }
                        }
                        catch (XmlBlasterException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            this.log.error(this.ME, "Can't load " + cbAddr[ii2].toXml() + ": " + e.toString());
                            throw XmlBlasterException.convert(this.glob, this.ME, "", e);
                        }
                    }
                }
                ++ii2;
            }
            tmpList.clear();
        }
        this.updateState(null);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Reached state = " + this.state.toString());
        }
    }

    public abstract DispatchConnection createDispatchConnection(AddressBase var1) throws XmlBlasterException;

    public final DispatchConnection getAliveDispatchConnection() {
        ArrayList arrayList = this.conList;
        synchronized (arrayList) {
            int ii = 0;
            while (ii < this.conList.size()) {
                if (((DispatchConnection)this.conList.get(ii)).isAlive()) {
                    DispatchConnection dispatchConnection = (DispatchConnection)this.conList.get(ii);
                    return dispatchConnection;
                }
                ++ii;
            }
        }
        return null;
    }

    public final AddressBase getAliveAddress() {
        DispatchConnection con = this.getAliveDispatchConnection();
        return con == null ? null : con.getAddress();
    }

    public final AddressBase getDeadAddress() {
        DispatchConnection con = this.getDeadDispatchConnection();
        return con == null ? null : con.getAddress();
    }

    public final DispatchConnection getDeadDispatchConnection() {
        ArrayList arrayList = this.conList;
        synchronized (arrayList) {
            int ii = 0;
            while (ii < this.conList.size()) {
                if (((DispatchConnection)this.conList.get(ii)).isDead()) {
                    DispatchConnection dispatchConnection = (DispatchConnection)this.conList.get(ii);
                    return dispatchConnection;
                }
                ++ii;
            }
        }
        return null;
    }

    public final DispatchConnection[] getConnectionsArrCopy() {
        DispatchConnection[] dest = null;
        ArrayList arrayList = this.conList;
        synchronized (arrayList) {
            dest = this.conList.toArray(this.DUMMY_ARR);
        }
        return dest;
    }

    final void toAlive(DispatchConnection con) {
        this.updateState(null);
    }

    final void toPolling(DispatchConnection con) {
        this.updateState(null);
    }

    final void toDead(DispatchConnection con, XmlBlasterException ex) {
        this.removeDispatchConnection(con);
        this.updateState(ex);
    }

    private final void updateState(XmlBlasterException ex) {
        ConnectionStateEnum oldState = this.state;
        ConnectionStateEnum tmp = ConnectionStateEnum.DEAD;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "updateState() oldState=" + oldState + " conList.size=" + this.conList.size());
        }
        ArrayList arrayList = this.conList;
        synchronized (arrayList) {
            int ii = 0;
            while (ii < this.conList.size()) {
                if (((DispatchConnection)this.conList.get(ii)).isAlive()) {
                    this.state = ConnectionStateEnum.ALIVE;
                    if (oldState != this.state) {
                        this.dispatchManager.toAlive(oldState);
                    }
                    return;
                }
                if (((DispatchConnection)this.conList.get(ii)).isPolling()) {
                    tmp = ConnectionStateEnum.POLLING;
                }
                ++ii;
            }
        }
        if (tmp == ConnectionStateEnum.POLLING) {
            this.state = ConnectionStateEnum.POLLING;
            if (oldState != this.state) {
                this.dispatchManager.toPolling(oldState);
            }
        } else if (tmp == ConnectionStateEnum.DEAD) {
            this.state = ConnectionStateEnum.DEAD;
            if (oldState != this.state) {
                this.dispatchManager.toDead(oldState, ex);
            }
        } else {
            this.state = tmp;
            this.log.error(this.ME, "Internal error in updateState(oldState=" + oldState + "," + this.state + ") " + this.toXml(""));
            Thread.dumpStack();
        }
    }

    public final boolean isUndef() {
        return this.state == ConnectionStateEnum.UNDEF;
    }

    public final boolean isAlive() {
        return this.state == ConnectionStateEnum.ALIVE;
    }

    public final boolean isPolling() {
        return this.state == ConnectionStateEnum.POLLING;
    }

    public final boolean isDead() {
        return this.state == ConnectionStateEnum.DEAD;
    }

    public ConnectionStateEnum getState() {
        return this.state;
    }

    private final void removeDispatchConnection(DispatchConnection con) {
        if (this.log.CALL) {
            this.log.call(this.ME, "removeDispatchConnection(" + con.getName() + ") ...");
        }
        ArrayList arrayList = this.conList;
        synchronized (arrayList) {
            try {
                con.shutdown();
            }
            catch (XmlBlasterException ex) {
                this.log.error(this.ME, "removeDispatchConnection() could not shutdown properly. " + ex.getMessage());
            }
            ((AbstractCollection)this.conList).remove(con);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Destroyed one callback connection, " + this.conList.size() + " remain.");
        }
    }

    public abstract void createFakedReturnObjects(I_QueueEntry[] var1, String var2, String var3) throws XmlBlasterException;

    public void send(MsgQueueEntry[] msgArr) throws Throwable, XmlBlasterException {
        if (this.isDead()) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_DEAD, this.ME, "Callback of " + msgArr.length + " messages '" + msgArr[0].getKeyOid() + "' from [" + msgArr[0].getSender() + "] failed, no callback connection is available");
        }
        Throwable ex = null;
        DispatchConnection[] cons = this.getConnectionsArrCopy();
        int ii = 0;
        while (ii < cons.length) {
            block7: {
                DispatchConnection con = cons[ii];
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Trying cb# " + ii + " state=" + con.getState().toString() + " ...");
                }
                if (con.isAlive()) {
                    try {
                        con.send(msgArr);
                        return;
                    }
                    catch (Throwable e) {
                        ex = e;
                        if (ii >= cons.length - 1) break block7;
                        this.log.warn(this.ME, "Callback failed, trying other addresses");
                    }
                }
            }
            ++ii;
        }
        if (ex == null) {
            ex = cons.length == 0 ? new XmlBlasterException(this.glob, this.isDead() ? ErrorCode.COMMUNICATION_NOCONNECTION_DEAD : ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "Callback of " + msgArr.length + " messages '" + msgArr[0].getKeyOid() + "' from sender [" + msgArr[0].getSender() + "] failed, no callback connection is alive") : new XmlBlasterException(this.glob, this.isDead() ? ErrorCode.COMMUNICATION_NOCONNECTION_DEAD : ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "Callback of " + msgArr.length + " messages '" + msgArr[0].getKeyOid() + "' to client [" + cons[0].getAddress().getSecretSessionId() + "] from [" + msgArr[0].getSender() + "] failed, no callback connection is alive");
        }
        throw ex;
    }

    public final int getSize() {
        return this.conList.size();
    }

    public final DispatchStatistic getDispatchStatistic() {
        return this.statistic;
    }

    public final void shutdown() {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering shutdown ...");
        }
        ArrayList arrayList = this.conList;
        synchronized (arrayList) {
            int ii = 0;
            while (ii < this.conList.size()) {
                try {
                    ((DispatchConnection)this.conList.get(ii)).shutdown();
                }
                catch (XmlBlasterException ex) {
                    this.log.error(this.ME, "shutdown() could not shutdown properly. " + ex.getMessage());
                }
                ++ii;
            }
            this.conList.clear();
        }
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<DispatchConnectionsHandler state='").append(this.state.toString()).append("'>");
        if (this.conList.size() < 1) {
            sb.append(offset).append(" <noDispatchConnection/>");
        } else {
            DispatchConnection[] arr = this.getConnectionsArrCopy();
            int ii = 0;
            while (ii < arr.length) {
                sb.append(offset).append(" <" + arr[ii].getDriverName() + " />");
                ++ii;
            }
        }
        sb.append(offset).append("</DispatchConnectionsHandler>");
        return sb.toString();
    }
}

