/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.dispatch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.plugins.I_MsgSecurityInterceptor;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.dispatch.DispatchConnectionsHandler;
import org.xmlBlaster.util.dispatch.DispatchStatistic;
import org.xmlBlaster.util.dispatch.DispatchWorker;
import org.xmlBlaster.util.dispatch.I_ConnectionStatusListener;
import org.xmlBlaster.util.dispatch.plugins.I_MsgDispatchInterceptor;
import org.xmlBlaster.util.error.I_MsgErrorHandler;
import org.xmlBlaster.util.error.MsgErrorInfo;
import org.xmlBlaster.util.property.PropString;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.I_QueuePutListener;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class DispatchManager
implements I_Timeout,
I_QueuePutListener {
    public final String ME;
    private final Global glob;
    private final LogChannel log;
    private final I_Queue msgQueue;
    private final DispatchConnectionsHandler dispatchConnectionsHandler;
    private final I_MsgErrorHandler failureListener;
    private final I_MsgSecurityInterceptor securityInterceptor;
    private final I_MsgDispatchInterceptor msgInterceptor;
    private HashSet connectionStatusListeners;
    private final String typeVersion;
    private long collectTime = -1L;
    private boolean dispatchWorkerIsActive = false;
    private DispatchWorker syncDispatchWorker;
    private Timestamp timerKey = null;
    private int notifyCounter = 0;
    private boolean isShutdown = false;
    private boolean isSyncMode = false;
    private boolean trySyncMode = false;
    private boolean inAliveTransition = false;
    private final Object ALIVE_TRANSITION_MONITOR = new Object();
    private int burstModeMaxEntries = -1;
    private long burstModeMaxBytes = -1L;
    private boolean dispatcherActive = true;

    public DispatchManager(Global glob, I_MsgErrorHandler failureListener, I_MsgSecurityInterceptor securityInterceptor, I_Queue msgQueue, I_ConnectionStatusListener connectionStatusListener, AddressBase[] addrArr) throws XmlBlasterException {
        if (failureListener == null || msgQueue == null) {
            throw new IllegalArgumentException("DispatchManager failureListener=" + failureListener + " msgQueue=" + msgQueue);
        }
        this.ME = "DispatchManager-" + msgQueue.getStorageId().getId();
        this.glob = glob;
        this.log = glob.getLog("dispatch");
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Loading DispatchManager ...");
        }
        this.msgQueue = msgQueue;
        this.failureListener = failureListener;
        this.securityInterceptor = securityInterceptor;
        this.dispatchConnectionsHandler = this.glob.createDispatchConnectionsHandler(this);
        this.connectionStatusListeners = new HashSet();
        if (connectionStatusListener != null) {
            this.connectionStatusListeners.add(connectionStatusListener);
        }
        PropString propString = new PropString("undef");
        if (addrArr != null && addrArr.length > 0) {
            propString.setValue(addrArr[0].getDispatchPlugin());
        }
        this.typeVersion = propString.getValue();
        this.msgInterceptor = glob.getDispatchPluginManager().getPlugin(this.typeVersion);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "DispatchPlugin/defaultPlugin=" + propString.getValue() + " this.msgInterceptor=" + this.msgInterceptor);
        }
        if (this.msgInterceptor != null) {
            this.msgInterceptor.addDispatchManager(this);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Activated dispatcher plugin '" + this.typeVersion + "'");
            }
        }
        this.msgQueue.addPutListener(this);
        this.dispatchConnectionsHandler.initialize(addrArr);
    }

    public void trySyncMode(boolean trySyncMode) {
        this.trySyncMode = trySyncMode;
        this.switchToSyncMode();
    }

    public final void updateProperty(CallbackAddress[] addressArr) throws XmlBlasterException {
        this.dispatchConnectionsHandler.initialize(addressArr);
    }

    public void finalize() {
        this.removeBurstModeTimer();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "finalize - garbage collected");
        }
    }

    public I_Queue getQueue() {
        return this.msgQueue;
    }

    public void addConnectionStatusListener(I_ConnectionStatusListener connectionStatusListener) {
        this.connectionStatusListeners.add(connectionStatusListener);
    }

    public void removeConnectionStateListener(I_ConnectionStatusListener connectionStatusListener) {
        this.connectionStatusListeners.remove(connectionStatusListener);
    }

    public String getTypeVersion() {
        return this.typeVersion;
    }

    public I_MsgSecurityInterceptor getMsgSecurityInterceptor() {
        return this.securityInterceptor;
    }

    public DispatchConnectionsHandler getDispatchConnectionsHandler() {
        return this.dispatchConnectionsHandler;
    }

    public final int getBurstModeMaxEntries() {
        return this.burstModeMaxEntries;
    }

    public final long getBurstModeMaxBytes() {
        return this.burstModeMaxBytes;
    }

    void toAlive(ConnectionStateEnum oldState) {
        AddressBase addr;
        if (this.log.CALL) {
            this.log.call(this.ME, "Switch from " + oldState + " to ALIVE");
        }
        if ((addr = this.dispatchConnectionsHandler.getAliveAddress()) == null) {
            this.log.error(this.ME, "toAlive action has no alive address");
            return;
        }
        try {
            this.inAliveTransition = true;
            this.burstModeMaxEntries = addr.getBurstModeMaxEntries();
            this.burstModeMaxBytes = addr.getBurstModeMaxBytes();
            Object object = this.ALIVE_TRANSITION_MONITOR;
            synchronized (object) {
                if (this.connectionStatusListeners.size() > 0) {
                    Iterator iter = this.connectionStatusListeners.iterator();
                    while (iter.hasNext()) {
                        ((I_ConnectionStatusListener)iter.next()).toAlive(this, oldState);
                    }
                }
                if (this.msgInterceptor != null) {
                    this.msgInterceptor.toAlive(this, oldState);
                }
            }
            Object var7_6 = null;
            this.inAliveTransition = false;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.inAliveTransition = false;
            throw throwable;
        }
        this.collectTime = addr.getCollectTime();
        this.activateDispatchWorker();
    }

    void toPolling(ConnectionStateEnum oldState) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Switch from " + oldState + " to POLLING");
        }
        this.switchToASyncMode();
        if (this.connectionStatusListeners.size() > 0) {
            Iterator iter = this.connectionStatusListeners.iterator();
            while (iter.hasNext()) {
                ((I_ConnectionStatusListener)iter.next()).toPolling(this, oldState);
            }
        }
        if (this.msgInterceptor != null) {
            this.msgInterceptor.toPolling(this, oldState);
        }
    }

    public void toDead(ConnectionStateEnum oldState, XmlBlasterException ex) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Switch from " + oldState + " to DEAD");
        }
        if (oldState == ConnectionStateEnum.DEAD) {
            return;
        }
        if (this.isShutdown) {
            return;
        }
        if (ex != null) {
            ex.changeErrorCode(ErrorCode.COMMUNICATION_NOCONNECTION_DEAD);
        } else {
            ex = new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_DEAD, this.ME, "Switch from " + oldState + " to DEAD, reason is not known");
        }
        if (this.connectionStatusListeners.size() > 0) {
            Iterator iter = this.connectionStatusListeners.iterator();
            while (iter.hasNext()) {
                ((I_ConnectionStatusListener)iter.next()).toDead(this, oldState, ex.getMessage());
            }
        }
        if (this.msgInterceptor != null) {
            this.msgInterceptor.toDead(this, oldState, ex.getMessage());
        }
        if (oldState != ConnectionStateEnum.UNDEF) {
            this.givingUpDelivery(ex);
        }
    }

    private void givingUpDelivery(XmlBlasterException ex) {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Entering givingUpDelivery(), state is " + this.dispatchConnectionsHandler.getState());
        }
        this.removeBurstModeTimer();
        this.getMsgErrorHandler().handleError(new MsgErrorInfo(this.glob, (MsgQueueEntry)null, this, (Throwable)ex));
        this.shutdown();
    }

    void handleSyncWorkerException(ArrayList entryList, Throwable throwable) throws XmlBlasterException {
        XmlBlasterException xmlBlasterException;
        if (this.log.CALL) {
            this.log.call(this.ME, "Sync delivery failed connection state is " + this.dispatchConnectionsHandler.getState().toString() + ": " + throwable.toString());
        }
        if ((xmlBlasterException = XmlBlasterException.convert(this.glob, this.ME, null, throwable)).isUser()) {
            MsgQueueEntry[] entries = entryList.toArray(new MsgQueueEntry[entryList.size()]);
            this.getMsgErrorHandler().handleErrorSync(new MsgErrorInfo(this.glob, entries, this, (Throwable)xmlBlasterException));
            return;
        }
        if (xmlBlasterException.isCommunication()) {
            if (this.msgInterceptor != null && this.isPolling()) {
                MsgQueueEntry[] entries;
                try {
                    entryList = this.msgInterceptor.handleNextMessages(this, entryList);
                    if (entryList != null && entryList.size() > 0) {
                        entries = entryList.toArray(new MsgQueueEntry[entryList.size()]);
                        this.getMsgErrorHandler().handleError(new MsgErrorInfo(this.glob, entries, this, (Throwable)xmlBlasterException));
                    }
                }
                catch (XmlBlasterException xmlBlasterException2) {
                    this.internalError(xmlBlasterException2);
                }
                if (entryList != null && entryList.size() > 0) {
                    entries = entryList.toArray(new MsgQueueEntry[entryList.size()]);
                    this.getMsgErrorHandler().handleError(new MsgErrorInfo(this.glob, entries, this, (Throwable)xmlBlasterException));
                }
                return;
            }
            this.switchToASyncMode();
            I_QueueEntry[] entries = entryList.toArray(new I_QueueEntry[entryList.size()]);
            this.getDispatchConnectionsHandler().createFakedReturnObjects(entries, "OK", "QUEUED");
            this.msgQueue.put(entries, true);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Delivery failed, pushed " + entries.length + " entries into tail back queue");
            }
        } else {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Invocation failed: " + xmlBlasterException.getMessage());
            }
            throw xmlBlasterException;
        }
    }

    void handleWorkerException(ArrayList entryList, Throwable throwable) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Async delivery failed connection state is " + this.dispatchConnectionsHandler.getState().toString() + ": " + throwable.toString());
        }
        if (entryList == null) {
            if (!this.isShutdown) {
                this.log.warn(this.ME, "Didn't expect null entryList in handleWorkerException() for throwable " + throwable.getMessage() + this.toXml(""));
            }
            return;
        }
        if (throwable instanceof XmlBlasterException) {
            XmlBlasterException ex = (XmlBlasterException)throwable;
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Invocation or callback failed: " + ex.getMessage());
            }
            if (ex.isUser()) {
                MsgQueueEntry[] entries = entryList.toArray(new MsgQueueEntry[entryList.size()]);
                this.getMsgErrorHandler().handleError(new MsgErrorInfo(this.glob, entries, this, (Throwable)ex));
            } else if (ex.isCommunication()) {
                if (this.msgInterceptor != null && this.isPolling()) {
                    MsgQueueEntry[] entries;
                    try {
                        entryList = this.msgInterceptor.handleNextMessages(this, entryList);
                        if (entryList != null && entryList.size() > 0) {
                            entries = entryList.toArray(new MsgQueueEntry[entryList.size()]);
                            this.getMsgErrorHandler().handleError(new MsgErrorInfo(this.glob, entries, this, (Throwable)ex));
                        }
                    }
                    catch (XmlBlasterException ex2) {
                        this.internalError(ex2);
                    }
                    if (entryList != null && entryList.size() > 0) {
                        entries = entryList.toArray(new MsgQueueEntry[entryList.size()]);
                        this.getMsgErrorHandler().handleError(new MsgErrorInfo(this.glob, entries, this, (Throwable)ex));
                    }
                }
            } else {
                this.log.error(this.ME, "Callback failed: " + ex.toString());
                ex.printStackTrace();
                this.internalError(ex);
            }
        } else {
            this.log.error(this.ME, "Callback failed: " + throwable.toString());
            throwable.printStackTrace();
            this.internalError(new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_DEAD, this.ME, "", throwable));
        }
    }

    public I_MsgErrorHandler getMsgErrorHandler() {
        return this.failureListener;
    }

    public void switchToSyncMode() {
        if (this.isSyncMode) {
            return;
        }
        DispatchManager dispatchManager = this;
        synchronized (dispatchManager) {
            if (this.isSyncMode) {
                return;
            }
            if (this.syncDispatchWorker == null) {
                this.syncDispatchWorker = new DispatchWorker(this.glob, this);
            }
            this.isSyncMode = true;
            this.log.info(this.ME, "Switched to synchronous message delivery");
            if (this.timerKey != null) {
                this.log.error(this.ME, "Burst mode timer was activated and we switched to synchronous delivery - handling of this situation is not coded yet");
            }
            this.removeBurstModeTimer();
        }
    }

    public void switchToASyncMode() {
        if (!this.isSyncMode) {
            return;
        }
        DispatchManager dispatchManager = this;
        synchronized (dispatchManager) {
            if (!this.isSyncMode) {
                return;
            }
            this.isSyncMode = false;
            this.activateDispatchWorker();
            this.log.info(this.ME, "Switched to asynchronous message delivery");
        }
    }

    public boolean putPre(I_QueueEntry queueEntry) throws XmlBlasterException {
        return this.putPre(new I_QueueEntry[]{queueEntry});
    }

    public boolean putPre(I_QueueEntry[] queueEntries) throws XmlBlasterException {
        if (!this.isSyncMode) {
            if (this.inAliveTransition) {
                Object object = this.ALIVE_TRANSITION_MONITOR;
                synchronized (object) {
                }
            }
            return true;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "putPre() - Got " + queueEntries.length + " QueueEntries to deliver synchronously ...");
        }
        ArrayList<I_QueueEntry> entryList = new ArrayList<I_QueueEntry>(queueEntries.length);
        int ii = 0;
        while (ii < queueEntries.length) {
            entryList.add(queueEntries[ii]);
            ++ii;
        }
        this.syncDispatchWorker.run(entryList);
        return false;
    }

    public void putPost(I_QueueEntry queueEntry) throws XmlBlasterException {
        if (!this.isSyncMode) {
            if (this.dispatcherActive) {
                this.notifyAboutNewEntry();
            }
            if (((MsgQueueEntry)queueEntry).wantReturnObj()) {
                I_QueueEntry[] entries = new I_QueueEntry[]{queueEntry};
                this.getDispatchConnectionsHandler().createFakedReturnObjects(entries, "OK", "QUEUED");
            }
        }
    }

    public void putPost(I_QueueEntry[] queueEntries) throws XmlBlasterException {
        if (!this.isSyncMode) {
            if (this.dispatcherActive) {
                this.notifyAboutNewEntry();
            }
            if (queueEntries.length > 0 && ((MsgQueueEntry)queueEntries[0]).wantReturnObj()) {
                this.getDispatchConnectionsHandler().createFakedReturnObjects(queueEntries, "OK", "QUEUED");
            }
        }
    }

    public ArrayList prepareMsgsFromQueue(ArrayList entryList) {
        if (entryList == null || entryList.size() < 1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Got zero messages from queue, expected at least one, can happen if client disconnected in the mean time: " + this.toXml(""));
            }
            return null;
        }
        return DispatchManager.prepareMsgsFromQueue(this.ME, this.log, this.msgQueue, entryList);
    }

    public static ArrayList prepareMsgsFromQueue(String logId, LogChannel log, I_Queue queue, ArrayList entryList) {
        int size = entryList.size();
        ArrayList<Object> result = new ArrayList<Object>(size);
        int ii = 0;
        while (ii < size) {
            MsgQueueEntry entry = (MsgQueueEntry)entryList.get(ii);
            if (entry.isDestroyed()) {
                log.info(logId, "Message " + entry.getLogId() + " is destroyed, ignoring it");
                if (log.TRACE) {
                    log.trace(logId, "Message " + entry.getLogId() + " is destroyed, ignoring it: " + entry.toXml());
                }
                try {
                    queue.removeRandom(entry);
                }
                catch (Throwable e) {
                    log.error(logId, "Internal error when removing expired message " + entry.getLogId() + " from queue, no recovery implemented, we continue: " + e.toString());
                }
            } else {
                result.add(entry.clone());
            }
            ++ii;
        }
        return result;
    }

    public void notifyAboutNewEntry() {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering notifyAboutNewEntry(" + this.notifyCounter + ")");
        }
        ++this.notifyCounter;
        if (!this.checkSending(true)) {
            return;
        }
        if (this.useBurstModeTimer()) {
            return;
        }
        this.startWorkerThread(false);
    }

    public int getNotifyCounter() {
        return this.notifyCounter;
    }

    private void activateDispatchWorker() {
        if (!this.checkSending(false)) {
            return;
        }
        if (this.useBurstModeTimer()) {
            return;
        }
        this.startWorkerThread(false);
    }

    private boolean useBurstModeTimer() {
        if (this.collectTime <= 0L) {
            return false;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Executing useBurstModeTimer() collectTime=" + this.collectTime + " dispatchWorkerIsActive=" + this.dispatchWorkerIsActive);
        }
        DispatchManager dispatchManager = this;
        synchronized (dispatchManager) {
            if (this.isShutdown) {
                boolean bl = false;
                return bl;
            }
            if (this.timerKey == null) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Starting burstMode timer with " + this.collectTime + " msec");
                }
                this.timerKey = this.glob.getBurstModeTimer().addTimeoutListener(this, this.collectTime, null);
            }
        }
        return true;
    }

    private void removeBurstModeTimer() {
        DispatchManager dispatchManager = this;
        synchronized (dispatchManager) {
            if (this.timerKey != null) {
                this.glob.getBurstModeTimer().removeTimeoutListener(this.timerKey);
                this.timerKey = null;
            }
        }
    }

    private void startWorkerThread(boolean fromTimeout) {
        if (!this.dispatchWorkerIsActive) {
            DispatchManager dispatchManager = this;
            synchronized (dispatchManager) {
                if (this.isShutdown) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "startWorkerThread() failed, we are shutdown: " + this.toXml(""));
                    }
                    return;
                }
                if (!this.dispatchWorkerIsActive) {
                    this.dispatchWorkerIsActive = true;
                    this.notifyCounter = 0;
                    try {
                        this.glob.getDispatchWorkerPool().execute(new DispatchWorker(this.glob, this));
                    }
                    catch (Throwable e) {
                        this.dispatchWorkerIsActive = false;
                        this.log.error(this.ME, "Unexpected error occurred: " + e.toString());
                        e.printStackTrace();
                    }
                }
            }
            return;
        }
        if (fromTimeout) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Burst mode timeout occurred, last callback worker thread is not finished - we do nothing (the worker thread will give us a kick)");
            }
        } else if (this.log.TRACE) {
            this.log.trace(this.ME, "Last callback worker thread is not finished - we do nothing (the worker thread will give us a kick)");
        }
    }

    public boolean isDead() {
        return this.dispatchConnectionsHandler.isDead();
    }

    public boolean isPolling() {
        return this.dispatchConnectionsHandler.isPolling();
    }

    private boolean checkSending(boolean isPublisherThread) {
        if (this.isShutdown) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "The dispatcher is shutdown, can't activate callback worker thread" + this.toXml(""));
            }
            return false;
        }
        if (this.isSyncMode) {
            return false;
        }
        if (this.msgQueue.isShutdown() && !isPublisherThread) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "The queue is shutdown, can't activate callback worker thread.");
            }
            this.shutdown();
            return false;
        }
        if (this.dispatchConnectionsHandler.isUndef()) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Not connected yet, state is UNDEF");
            }
            return false;
        }
        if (this.dispatchConnectionsHandler.isDead() && !isPublisherThread) {
            String text = "No recoverable remote connection available, giving up queue " + this.msgQueue.getStorageId() + ".";
            if (this.log.TRACE) {
                this.log.trace(this.ME, text);
            }
            this.givingUpDelivery(new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_DEAD, this.ME, text));
            return false;
        }
        if (this.msgQueue.getNumOfEntries() == 0L) {
            return false;
        }
        if (this.msgInterceptor != null) {
            if (!this.msgInterceptor.doActivate(this)) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "this.msgInterceptor.doActivate==false");
                }
                return false;
            }
            return true;
        }
        if (this.dispatchConnectionsHandler.isPolling()) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Can't send message as connection is lost and we are polling");
            }
            return false;
        }
        return true;
    }

    public void timeout(Object userData) {
        this.timerKey = null;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Burst mode timeout occurred, queue entries=" + this.msgQueue.getNumOfEntries() + ", starting callback worker thread ...");
        }
        this.startWorkerThread(true);
    }

    public I_MsgDispatchInterceptor getMsgDispatchInterceptor() {
        return this.msgInterceptor;
    }

    public void setAddresses(AddressBase[] addr) throws XmlBlasterException {
        this.dispatchConnectionsHandler.initialize(addr);
    }

    void setDispatchWorkerIsActive(boolean val) {
        this.dispatchWorkerIsActive = val;
        if (!val) {
            if (this.isShutdown) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "setDispatchWorkerIsActive(" + val + ") failed, we are shutdown: " + this.toXml(""));
                }
                return;
            }
            if (this.msgQueue.getNumOfEntries() > 0L) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Finished callback job. Giving a kick to send the remaining " + this.msgQueue.getNumOfEntries() + " messages.");
                }
                try {
                    this.activateDispatchWorker();
                }
                catch (Throwable e) {
                    this.log.error(this.ME, e.toString());
                    e.printStackTrace();
                }
            } else if (this.trySyncMode && !this.isSyncMode) {
                this.switchToSyncMode();
            }
        }
    }

    public void internalError(Throwable throwable) {
        this.givingUpDelivery(throwable instanceof XmlBlasterException ? (XmlBlasterException)throwable : new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_DEAD, this.ME, "", throwable));
        this.log.error(this.ME, "PANIC: Internal error, doing shutdown: " + throwable.getMessage());
        this.shutdown();
    }

    public DispatchStatistic getDispatchStatistic() {
        return this.dispatchConnectionsHandler.getDispatchStatistic();
    }

    public void shutdown() {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering shutdown ...");
        }
        if (this.isShutdown) {
            return;
        }
        DispatchManager dispatchManager = this;
        synchronized (dispatchManager) {
            if (this.isShutdown) {
                return;
            }
            this.isShutdown = true;
            this.msgQueue.removePutListener(this);
            this.connectionStatusListeners.clear();
            this.removeBurstModeTimer();
            if (this.msgInterceptor != null) {
                try {
                    this.msgInterceptor.shutdown(this);
                }
                catch (XmlBlasterException e) {
                    this.log.warn(this.ME, "Ignoring problems during shutdown of plugin: " + e.getMessage());
                }
            }
            if (this.dispatchConnectionsHandler != null) {
                this.dispatchConnectionsHandler.shutdown();
            }
            this.removeBurstModeTimer();
            if (this.syncDispatchWorker != null) {
                this.syncDispatchWorker.shutdown();
            }
        }
    }

    public String getId() {
        return this.msgQueue.getStorageId().getId();
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(2000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<DispatchManager id='").append(this.getId());
        if (this.msgQueue != null) {
            sb.append("' numEntries='").append(this.msgQueue.getNumOfEntries());
        }
        sb.append("' isShutdown='").append(this.isShutdown).append("'>");
        sb.append(this.dispatchConnectionsHandler.toXml(extraOffset + " "));
        sb.append(offset).append(" <dispatchWorkerIsActive>").append(this.dispatchWorkerIsActive).append("</dispatchWorkerIsActive>");
        sb.append(offset).append("</DispatchManager>");
        return sb.toString();
    }

    public void setDispatcherActive(boolean dispatcherActive) {
        this.dispatcherActive = dispatcherActive;
        if (this.dispatcherActive) {
            this.notifyAboutNewEntry();
        }
    }

    public boolean isDispatcherActive() {
        return this.dispatcherActive;
    }
}

