/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.dispatch;

import java.util.ArrayList;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.distributor.I_MsgDistributor;
import org.xmlBlaster.engine.qos.UpdateReturnQosServer;
import org.xmlBlaster.engine.queuemsg.MsgQueueUpdateEntry;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.dispatch.plugins.I_MsgDispatchInterceptor;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class DispatchWorker
implements Runnable {
    public final String ME;
    private final Global glob;
    private final LogChannel log;
    private DispatchManager dispatchManager;
    private I_Queue msgQueue;

    public DispatchWorker(Global glob, DispatchManager mgr) {
        this.glob = glob;
        this.log = glob.getLog("dispatch");
        this.dispatchManager = mgr;
        this.msgQueue = mgr.getQueue();
        this.ME = "DispatchWorker-" + this.msgQueue.getStorageId();
    }

    public void run(ArrayList entryList) throws XmlBlasterException {
        block8: {
            if (this.log.CALL) {
                this.log.call(this.ME, "Starting push remote dispatch of " + (entryList != null ? entryList.size() : 0) + " entries.");
            }
            MsgQueueEntry[] entries = null;
            try {
                I_MsgDispatchInterceptor msgInterceptor = this.dispatchManager.getMsgDispatchInterceptor();
                if (msgInterceptor != null) {
                    this.log.error(this.ME, "Communication dispatch plugin support is missing in sync mode - not implemented");
                }
                if (entryList == null || entryList.size() < 1) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Got zero messages from to deliver, expected at least one");
                    }
                    return;
                }
                entries = entryList.toArray(new MsgQueueEntry[entryList.size()]);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Sending now " + entries.length + " messages ...");
                }
                this.dispatchManager.getDispatchConnectionsHandler().send(entries);
                ArrayList defaultEntries = this.filterDistributorEntries(entryList, null);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Commit of successful sending of " + entryList.size() + " messages done, current queue size is " + this.msgQueue.getNumOfEntries() + " '" + ((MsgQueueEntry)entryList.get(0)).getLogId() + "'");
                }
            }
            catch (Throwable throwable) {
                ArrayList entriesWithNoDistributor = this.filterDistributorEntries(entryList, throwable);
                if (entriesWithNoDistributor.size() <= 0) break block8;
                this.dispatchManager.handleSyncWorkerException(entriesWithNoDistributor, throwable);
            }
        }
    }

    protected ArrayList filterDistributorEntries(ArrayList entries, Throwable ex) {
        ArrayList<MsgQueueUpdateEntry> entriesWithNoDistributor = new ArrayList<MsgQueueUpdateEntry>();
        int i = 0;
        while (i < entries.size()) {
            Object obj = entries.get(i);
            if (!(obj instanceof MsgQueueUpdateEntry)) {
                return entries;
            }
            MsgQueueUpdateEntry entry = (MsgQueueUpdateEntry)obj;
            I_MsgDistributor msgDistributor = null;
            MsgUnitWrapper wrapper = entry.getMsgUnitWrapper();
            try {
                msgDistributor = wrapper.getTopicHandler().getMsgDistributorPlugin();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (msgDistributor != null) {
                if (ex != null) {
                    UpdateReturnQosServer retQos = (UpdateReturnQosServer)entry.getReturnObj();
                    try {
                        if (retQos == null) {
                            retQos = new UpdateReturnQosServer(this.glob, "<qos/>");
                            entry.setReturnObj(retQos);
                        }
                        retQos.setException(ex);
                    }
                    catch (XmlBlasterException ee) {
                        this.log.error(this.ME, "filterDistributorEntries: " + ee.getMessage());
                    }
                }
            } else {
                entriesWithNoDistributor.add(entry);
            }
            ++i;
        }
        return entriesWithNoDistributor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.log.CALL) {
            this.log.call(this.ME, "Starting remote dispatch with " + this.msgQueue.getNumOfEntries() + " entries.");
        }
        ArrayList entryList = null;
        ArrayList entryListChecked = null;
        try {
            try {
                I_Entry[] entries;
                I_MsgDispatchInterceptor msgInterceptor = this.dispatchManager.getMsgDispatchInterceptor();
                if (msgInterceptor != null) {
                    entryList = entryListChecked = msgInterceptor.handleNextMessages(this.dispatchManager, null);
                } else {
                    I_Queue i_Queue = this.msgQueue;
                    synchronized (i_Queue) {
                        entryList = this.msgQueue.peekSamePriority(this.dispatchManager.getBurstModeMaxEntries(), this.dispatchManager.getBurstModeMaxBytes());
                        entryListChecked = this.dispatchManager.prepareMsgsFromQueue(entryList);
                    }
                }
                if (entryList == null || entryList.size() < 1) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Got zero messages from queue, expected at least one, can happen if messages expired or client disconnected in the mean time.");
                    }
                    Object var7_6 = null;
                    this.dispatchManager.setDispatchWorkerIsActive(false);
                    entryList = null;
                    this.shutdown();
                    return;
                }
                if (entryListChecked != null && entryListChecked.size() > 0) {
                    entries = entryListChecked.toArray(new MsgQueueEntry[entryListChecked.size()]);
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Sending now " + entries.length + " messages ..., current queue size is " + this.msgQueue.getNumOfEntries() + " '" + ((MsgQueueEntry)entries[0]).getLogId() + "'");
                    }
                    this.dispatchManager.getDispatchConnectionsHandler().send((MsgQueueEntry[])entries);
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Sending of " + entries.length + " messages done, current queue size is " + this.msgQueue.getNumOfEntries());
                    }
                }
                entries = entryList.toArray(new MsgQueueEntry[entryList.size()]);
                this.msgQueue.removeRandom(entries);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Commit of successful sending of " + entryList.size() + " messages done, current queue size is " + this.msgQueue.getNumOfEntries() + " '" + ((MsgQueueEntry)entryList.get(0)).getLogId() + "'");
                }
            }
            catch (Throwable throwable) {
                this.dispatchManager.handleWorkerException(entryList, throwable);
                Object var7_8 = null;
                this.dispatchManager.setDispatchWorkerIsActive(false);
                entryList = null;
                this.shutdown();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.dispatchManager.setDispatchWorkerIsActive(false);
            entryList = null;
            this.shutdown();
            throw throwable;
        }
        Object var7_7 = null;
        this.dispatchManager.setDispatchWorkerIsActive(false);
        entryList = null;
        this.shutdown();
    }

    void shutdown() {
    }
}

