/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.dispatch;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.property.PropInt;

public class DispatchWorkerPool {
    public final String ME = "DispatchWorkerPool";
    private Global glob;
    private LogChannel log;
    private PooledExecutor pool;
    private PropInt threadPrio = new PropInt(5);
    private PropInt maximumPoolSize = new PropInt(200);
    private PropInt minimumPoolSize = new PropInt(2);
    private PropInt createThreads = new PropInt(this.minimumPoolSize.getValue());
    private boolean isShutdown = false;
    private final String poolId = "dispatch";

    public DispatchWorkerPool(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("dispatch");
        this.initialize();
    }

    private synchronized void initialize() {
        this.pool = new PooledExecutor((Channel)new LinkedQueue());
        String context = null;
        String instanceName = this.glob.isServerSide() ? "callback" : "connection";
        this.threadPrio.setFromEnv(this.glob, this.glob.getStrippedId(), context, "dispatch", instanceName, "threadPriority");
        this.pool.setThreadFactory((ThreadFactory)new DeamonThreadFactory(this.glob.getId(), this.threadPrio.getValue()));
        this.maximumPoolSize.setFromEnv(this.glob, this.glob.getStrippedId(), context, "dispatch", instanceName, "maximumPoolSize");
        this.minimumPoolSize.setFromEnv(this.glob, this.glob.getStrippedId(), context, "dispatch", instanceName, "minimumPoolSize");
        this.createThreads.setFromEnv(this.glob, this.glob.getStrippedId(), context, "dispatch", instanceName, "createThreads");
        if (this.log.TRACE) {
            this.log.trace("DispatchWorkerPool", "maximumPoolSize=" + this.maximumPoolSize.getValue() + " minimumPoolSize=" + this.minimumPoolSize.getValue() + " createThreads=" + this.createThreads.getValue());
        }
        this.pool.setMaximumPoolSize(this.maximumPoolSize.getValue());
        this.pool.setMinimumPoolSize(this.minimumPoolSize.getValue());
        this.pool.createThreads(this.createThreads.getValue());
        this.pool.setKeepAliveTime(-1L);
        this.pool.waitWhenBlocked();
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public final synchronized void execute(Runnable command) throws InterruptedException {
        if (this.isShutdown) {
            this.log.trace("DispatchWorkerPool", "The pool is shudown, ignoring execute()");
            return;
        }
        this.pool.execute(command);
    }

    public String getStatistic() {
        return "Active threads=" + this.pool.getPoolSize() + " of max=" + this.pool.getMaximumPoolSize();
    }

    public void shutdownAfterProcessingCurrentlyQueuedTasks() {
        this.pool.shutdownAfterProcessingCurrentlyQueuedTasks();
    }

    public synchronized void shutdown() {
        if (this.log.CALL) {
            this.log.call("DispatchWorkerPool", "shutdown()");
        }
        if (!this.isShutdown) {
            this.isShutdown = true;
            this.pool.shutdownNow();
        }
    }

    public String getName() {
        return "DispatchWorkerPool";
    }

    protected static class DeamonThreadFactory
    implements ThreadFactory {
        private final String id;
        private final int priority;
        private int count;

        DeamonThreadFactory(String id, int priority) {
            this.id = id;
            this.priority = priority;
        }

        public Thread newThread(Runnable command) {
            Thread t = new Thread(command, "XmlBlaster.DispatchWorkerPool." + this.id + "-" + this.count++);
            t.setDaemon(true);
            t.setPriority(this.priority);
            return t;
        }
    }
}

