/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.dispatch.plugins.prio;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SaxHandlerBase;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.dispatch.plugins.prio.DispatchAction;
import org.xmlBlaster.util.dispatch.plugins.prio.StatusConfiguration;

public class ConfigurationParser
extends SaxHandlerBase {
    private String ME = "ConfigurationParser";
    private final Global glob;
    private final LogChannel log;
    private boolean inMsgDispatch = false;
    private boolean inAction = false;
    private boolean inOnStatus = false;
    private DispatchAction defaultAction;
    private String defaultStatus = null;
    private StatusConfiguration statusConfiguration = null;
    private final Map configurationContentMap = new HashMap();
    private String pluginType;
    private String pluginVersion;

    public ConfigurationParser(Global glob, String xmlLiteral) throws XmlBlasterException {
        super(glob);
        this.glob = glob;
        this.log = glob.getLog("dispatch");
        this.defaultAction = new DispatchAction(glob, "send");
        this.parseIt(xmlLiteral);
    }

    private final void parseIt(String xmlLiteral) throws XmlBlasterException {
        if (xmlLiteral == null || xmlLiteral.length() < 1) {
            return;
        }
        this.init(xmlLiteral);
    }

    public final DispatchAction getDefaultDispatchAction() {
        return this.defaultAction;
    }

    public final String getDefaultStatus() {
        return this.defaultStatus;
    }

    void addStatusConfiguration(StatusConfiguration conf) {
        Map map = this.configurationContentMap;
        synchronized (map) {
            this.configurationContentMap.put(conf.getContent(), conf);
        }
    }

    public final StatusConfiguration getStatusConfiguration(String currStatus) {
        if (currStatus == null) {
            currStatus = this.defaultStatus;
        }
        if (currStatus == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Current status is null, using default action '" + this.defaultAction.toString() + "'");
            }
            return new StatusConfiguration(this.glob, null, null, null, this.defaultAction);
        }
        StatusConfiguration conf = null;
        Map map = this.configurationContentMap;
        synchronized (map) {
            conf = (StatusConfiguration)this.configurationContentMap.get(currStatus);
            if (conf == null && this.defaultStatus != null && !this.defaultStatus.equals(currStatus)) {
                this.log.warn(this.ME, "Can't find '" + currStatus + "' configuration, using default status '" + this.defaultStatus + "'");
                currStatus = this.defaultStatus;
                conf = (StatusConfiguration)this.configurationContentMap.get(currStatus);
            }
        }
        if (conf == null) {
            this.log.warn(this.ME, "Can't find '" + currStatus + "' configuration, using default action '" + this.defaultAction + "'");
            return new StatusConfiguration(this.glob, null, null, null, this.defaultAction);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Current status '" + currStatus + "' with configuration: " + conf.toXml(""));
        }
        return conf;
    }

    public final StatusConfiguration getStatusConfiguration(ConnectionStateEnum currConnectionState) {
        if (currConnectionState == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Current connection state is null, returning null");
            }
            return null;
        }
        Map map = this.configurationContentMap;
        synchronized (map) {
            Iterator it = this.configurationContentMap.values().iterator();
            while (it.hasNext()) {
                StatusConfiguration conf = (StatusConfiguration)it.next();
                if (conf.getConnectionState() != currConnectionState) continue;
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Found configuration for connection state '" + currConnectionState + "'");
                }
                StatusConfiguration statusConfiguration = conf;
                return statusConfiguration;
            }
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Can't find '" + currConnectionState + "' configuration, returning null");
        }
        return null;
    }

    public final Map getStatusConfigurationMap() {
        return this.configurationContentMap;
    }

    public final void startElement(String uri, String localName, String name, Attributes attrs) {
        if (name.equalsIgnoreCase("msgDispatch")) {
            this.inMsgDispatch = true;
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    if (attrs.getQName(i).equalsIgnoreCase("type")) {
                        this.pluginType = attrs.getValue(i).trim();
                    } else if (attrs.getQName(i).equalsIgnoreCase("version")) {
                        this.pluginVersion = attrs.getValue(i).trim();
                    } else if (attrs.getQName(i).equalsIgnoreCase("defaultStatus")) {
                        this.defaultStatus = attrs.getValue(i).trim();
                    } else if (attrs.getQName(i).equalsIgnoreCase("defaultAction")) {
                        this.defaultAction = new DispatchAction(this.glob, attrs.getValue(i).trim());
                    } else {
                        this.log.warn(this.ME, "Ignoring unknown attribute <msgDispatch " + attrs.getQName(i) + "='" + attrs.getValue(i) + "'>");
                    }
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("onStatus")) {
            if (!this.inMsgDispatch) {
                return;
            }
            this.inOnStatus = true;
            String oid = null;
            String content = null;
            ConnectionStateEnum connectionState = null;
            DispatchAction defAct = this.defaultAction;
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    if (attrs.getQName(i).equalsIgnoreCase("oid")) {
                        oid = attrs.getValue(i).trim();
                    } else if (attrs.getQName(i).equalsIgnoreCase("content")) {
                        content = attrs.getValue(i).trim();
                    } else if (attrs.getQName(i).equalsIgnoreCase("connectionState")) {
                        connectionState = ConnectionStateEnum.parseConnectionState(attrs.getValue(i).trim());
                    } else if (attrs.getQName(i).equalsIgnoreCase("defaultAction")) {
                        defAct = new DispatchAction(this.glob, attrs.getValue(i).trim());
                    } else {
                        this.log.warn(this.ME, "Ignoring unknown attribute <onStatus " + attrs.getQName(i) + "='" + attrs.getValue(i) + "'>");
                    }
                    ++i;
                }
            }
            this.statusConfiguration = null;
            if (oid == null && connectionState == null) {
                throw new IllegalArgumentException(this.ME + ": Missing oid attribute in <onStatus content='" + content + "'> tag (or specify 'connectionState')");
            }
            if (content == null && connectionState == null) {
                throw new IllegalArgumentException(this.ME + ":Missing content attribute in <onStatus oid='" + oid + "'> tag (or specify 'connectionState')");
            }
            this.statusConfiguration = new StatusConfiguration(this.glob, oid, content, connectionState, defAct);
            this.addStatusConfiguration(this.statusConfiguration);
            return;
        }
        if (name.equalsIgnoreCase("action")) {
            if (!this.inOnStatus) {
                return;
            }
            this.inAction = true;
            if (this.statusConfiguration == null) {
                return;
            }
            if (attrs != null) {
                int len = attrs.getLength();
                String priority = attrs.getValue("ifPriority");
                String doAttr = attrs.getValue("do");
                DispatchAction dispatchAction = new DispatchAction(this.glob, doAttr);
                this.statusConfiguration.addDispatchAction(priority, dispatchAction);
            }
            return;
        }
    }

    public void endElement(String uri, String localName, String name) {
        if (name.equalsIgnoreCase("msgDispatch")) {
            this.inMsgDispatch = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("action")) {
            this.inAction = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("onStatus")) {
            this.inOnStatus = false;
            this.character.setLength(0);
            return;
        }
        this.character.setLength(0);
    }
}

