/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.dispatch.plugins.prio;

import org.jutils.log.LogChannel;
import org.jutils.text.StringHelper;
import org.xmlBlaster.util.Global;

public final class DispatchAction {
    private String ME = "DispatchAction";
    private LogChannel log;
    private String action;
    public static final String SEND = "send";
    private boolean doSend = false;
    public static final String QUEUE = "queue";
    private boolean doQueue = false;
    public static final String DESTROY = "destroy";
    private boolean doDestroy = false;
    public static final String NOTIFY_SENDER = "notifySender";
    private boolean doNotifySender = false;

    public DispatchAction(Global glob, String action) {
        this.log = glob.getLog("dispatch");
        if (action == null) {
            throw new IllegalArgumentException("The given dispatch action is null");
        }
        String[] arr = StringHelper.toArray(action = action.trim(), "|, ");
        if (arr.length < 1) {
            throw new IllegalArgumentException("The given dispatch action '" + action + "' is invalid");
        }
        this.action = action;
        int i = 0;
        while (i < arr.length) {
            if (SEND.equals(arr[i])) {
                this.doSend = true;
            } else if (QUEUE.equals(arr[i])) {
                this.doQueue = true;
            } else if (DESTROY.equals(arr[i])) {
                this.doDestroy = true;
            } else if (NOTIFY_SENDER.equals(arr[i])) {
                this.doNotifySender = true;
            } else {
                throw new IllegalArgumentException("The given dispatcher action '" + arr[i] + "' is not supported.");
            }
            ++i;
        }
        int count = 0;
        if (this.doQueue) {
            ++count;
        }
        if (this.doSend) {
            ++count;
        }
        if (this.doDestroy) {
            ++count;
        }
        if (count > 1) {
            throw new IllegalArgumentException("Only one of the actions 'queue|send|destroy' is possible, combinations make no sense");
        }
    }

    public final String getAction() {
        return this.action;
    }

    public boolean doSend() {
        return this.doSend;
    }

    public boolean doQueue() {
        return this.doQueue;
    }

    public boolean doDestroy() {
        return this.doDestroy;
    }

    public boolean doNotifySender() {
        return this.doNotifySender;
    }

    public boolean defaultActionOnly() {
        return this.doSend() && !this.doNotifySender();
    }

    public boolean equals(DispatchAction other) {
        return this.action.equals(other.getAction());
    }

    public String toString() {
        return this.action;
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer();
        String offset = "\n  ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<action do='").append(this.action).append("'/>");
        return sb.toString();
    }
}

