/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.dispatch.plugins.prio;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jutils.init.I_PropertyChangeListener;
import org.jutils.init.PropertyChangeEvent;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.dispatch.plugins.I_MsgDispatchInterceptor;
import org.xmlBlaster.util.dispatch.plugins.prio.ConfigurationParser;
import org.xmlBlaster.util.dispatch.plugins.prio.DispatchAction;
import org.xmlBlaster.util.dispatch.plugins.prio.DispatchManagerEntry;
import org.xmlBlaster.util.dispatch.plugins.prio.I_Notify;
import org.xmlBlaster.util.dispatch.plugins.prio.StatusConfiguration;
import org.xmlBlaster.util.dispatch.plugins.prio.XmlBlasterNativeClient;
import org.xmlBlaster.util.error.MsgErrorInfo;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class PriorizedDispatchPlugin
implements I_MsgDispatchInterceptor,
I_Plugin,
I_PropertyChangeListener,
I_Notify {
    private String ME = "PriorizedDispatchPlugin";
    private Global glob;
    private LogChannel log;
    private ConfigurationParser parser = null;
    public static final String CONFIG_PROPERTY_KEY = "PriorizedDispatchPlugin/config";
    private String specificConfigPropertyKey = null;
    private boolean hasSpecificConf = false;
    private StatusConfiguration currMsgStatusConfiguration;
    private String currMsgStatus;
    private boolean hasDefaultActionOnly = true;
    private XmlBlasterNativeClient xmlBlasterClient;
    private Map dispatchManagerEntryMap = new HashMap();
    private boolean isShutdown = false;
    public DispatchAction QUEUE_ACTION;

    public void initialize(Global glob, String typeVersion) throws XmlBlasterException {
        this.log = glob.getLog("dispatch");
        this.glob = glob;
        String sessionId = null;
        PriorizedDispatchPlugin priorizedDispatchPlugin = this;
        synchronized (priorizedDispatchPlugin) {
            Object obj = glob.getObjectEntry("PriorizedDispatchPlugin.xmlBlasterAccess");
            if (obj == null) {
                obj = new XmlBlasterNativeClient(glob, this, sessionId);
                glob.addObjectEntry("PriorizedDispatchPlugin.xmlBlasterAccess", obj);
            }
            this.xmlBlasterClient = (XmlBlasterNativeClient)obj;
        }
        this.QUEUE_ACTION = new DispatchAction(glob, "queue");
        this.specificConfigPropertyKey = CONFIG_PROPERTY_KEY + "[" + typeVersion + "]";
        this.glob.getProperty().addPropertyChangeListener(CONFIG_PROPERTY_KEY, "startup", this);
        this.glob.getProperty().addPropertyChangeListener(this.specificConfigPropertyKey, "startup", this);
        this.log.info(this.ME, "Succefully initialized");
    }

    public void addDispatchManager(DispatchManager dispatchManager) {
        DispatchManagerEntry managerEntry = new DispatchManagerEntry(dispatchManager);
        PriorizedDispatchPlugin priorizedDispatchPlugin = this;
        synchronized (priorizedDispatchPlugin) {
            this.dispatchManagerEntryMap.put(dispatchManager, managerEntry);
            this.changeManagerState(dispatchManager, dispatchManager.getDispatchConnectionsHandler().getState(), false);
        }
        this.log.info(this.ME, "Stored dispatchManager=" + dispatchManager.getId() + ", dispatchManagerEntryMap.size()=" + this.dispatchManagerEntryMap.size());
    }

    public void propertyChanged(PropertyChangeEvent ev) {
        String newConfig;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "propertyChanged event: " + ev.toString());
        }
        if ((newConfig = ev.getNewValue()) == null || newConfig.equals("startup")) {
            if (this.parser != null) {
                return;
            }
            newConfig = "<msgDispatch/>";
        }
        if (this.specificConfigPropertyKey.equals(ev.getKey())) {
            this.hasSpecificConf = true;
        }
        if (this.hasSpecificConf && CONFIG_PROPERTY_KEY.equals(ev.getKey())) {
            return;
        }
        PriorizedDispatchPlugin priorizedDispatchPlugin = this;
        synchronized (priorizedDispatchPlugin) {
            block14: {
                ConfigurationParser oldParser = this.parser;
                StatusConfiguration oldConf = this.currMsgStatusConfiguration;
                boolean oldDef = this.hasDefaultActionOnly;
                try {
                    this.parser = new ConfigurationParser(this.glob, newConfig);
                }
                catch (XmlBlasterException e) {
                    this.log.error(this.ME, "The new property '" + ev.toString() + " is ignored: " + e.getMessage());
                    return;
                }
                try {
                    this.subscribeStatusMessages();
                    this.statusChanged(this.currMsgStatus);
                    this.log.info(this.ME, "Reconfigured priorized dispatch plugin with '" + ev.getKey() + "', currMsgStatus=" + this.currMsgStatus);
                }
                catch (XmlBlasterException e) {
                    this.log.error(this.ME, "The new property '" + ev.toString() + " is ignored: " + e.getMessage());
                    this.parser = oldParser;
                    this.currMsgStatusConfiguration = oldConf;
                    this.hasDefaultActionOnly = oldDef;
                    if (this.parser == null) break block14;
                    try {
                        this.subscribeStatusMessages();
                    }
                    catch (XmlBlasterException e2) {
                        this.log.error(this.ME, "Rollback to old configuration failed: " + e2.getMessage());
                    }
                    this.statusChanged(this.currMsgStatus);
                }
            }
        }
    }

    private void subscribeStatusMessages() throws XmlBlasterException {
        this.xmlBlasterClient.unSubscribeStatusMessages(this);
        Iterator it = this.parser.getStatusConfigurationMap().values().iterator();
        while (it.hasNext()) {
            StatusConfiguration conf = (StatusConfiguration)it.next();
            this.xmlBlasterClient.subscribeToStatusMessage(conf.getOid(), this);
        }
    }

    public void init(Global glob, PluginInfo pluginInfo) {
        Properties properties = pluginInfo.getParameters();
    }

    public String getType() {
        return "Priority";
    }

    public final String getVersion() {
        return "1.0";
    }

    public final void statusChanged(String status) {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "statusChanged(status=" + status + ")");
        }
        PriorizedDispatchPlugin priorizedDispatchPlugin = this;
        synchronized (priorizedDispatchPlugin) {
            String oldStatus = this.currMsgStatus;
            this.currMsgStatus = status;
            this.currMsgStatusConfiguration = this.parser.getStatusConfiguration(this.currMsgStatus);
            this.hasDefaultActionOnly = this.currMsgStatusConfiguration.defaultActionOnly();
            this.log.info(this.ME, "Changed priorized dispatch from old status=" + oldStatus + " to new status=" + this.currMsgStatus);
            if (oldStatus == null && this.currMsgStatus != null || oldStatus != null && !oldStatus.equals(this.currMsgStatus)) {
                Iterator it = this.dispatchManagerEntryMap.values().iterator();
                while (it.hasNext()) {
                    DispatchManagerEntry managerEntry = (DispatchManagerEntry)it.next();
                    managerEntry.setCurrConnectionStateConfiguration(this.parser.getStatusConfiguration(managerEntry.getCurrConnectionState()));
                    this.flushHoldbackQueue(managerEntry);
                }
            }
        }
    }

    private final DispatchAction getDispatchAction(DispatchManagerEntry managerEntry, MsgQueueEntry entry) {
        if (managerEntry.getCurrConnectionStateConfiguration() != null) {
            return managerEntry.getCurrConnectionStateConfiguration().getDispatchAction(entry.getPriorityEnum());
        }
        return this.currMsgStatusConfiguration.getDispatchAction(entry.getPriorityEnum());
    }

    public final boolean doActivate(DispatchManager dispatchManager) {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public final ArrayList handleNextMessages(DispatchManager dispatchManager, ArrayList entries) throws XmlBlasterException {
        entryList = dispatchManager.getQueue().peekSamePriority(-1, -1L);
        entryList = dispatchManager.prepareMsgsFromQueue(entryList);
        managerEntry = this.getDispatchManagerEntry(dispatchManager);
        if (managerEntry == null) {
            text = "Internal error: can't queue " + (entries == null ? 0 : entries.size()) + " messages, dispatchManager=" + dispatchManager + " is unknown, dispatchManagerEntryMap.size()=" + (this.dispatchManagerEntryMap == null ? 0 : this.dispatchManagerEntryMap.size());
            this.log.error(this.ME, text);
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, text);
        }
        if (managerEntry.getCurrConnectionState() == ConnectionStateEnum.ALIVE && managerEntry.getCurrConnectionStateConfiguration() == null && this.hasDefaultActionOnly) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "We have default action only, returning all " + entryList.size() + " messages");
            }
            return entryList;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Working with " + entryList.size() + " messages ...");
        }
        resultList = new ArrayList<MsgQueueEntry>();
        i = 0;
        while (i < entryList.size()) {
            entry = (MsgQueueEntry)entryList.get(i);
            action = this.getDispatchAction(managerEntry, entry);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Working on '" + entry.getLogId() + "', action=" + action.getAction() + " from sender " + entry.getSender());
            }
            if (managerEntry.getCurrConnectionState() != ConnectionStateEnum.ALIVE) ** GOTO lbl-1000
            if (entry.isInternal()) {
                this.log.info(this.ME, "Sending out of bound internal message '" + entry.getLogId() + "'");
                resultList.add(entry);
            } else if (this.xmlBlasterClient.getLoginName().equals(entry.getSender().getLoginName())) {
                this.log.info(this.ME, "Sending out of bound PtP message '" + entry.getLogId() + "'");
                resultList.add(entry);
            } else lbl-1000:
            // 2 sources

            {
                if (managerEntry.getCurrConnectionState() != ConnectionStateEnum.ALIVE && action.doSend()) {
                    this.log.error(this.ME, "We are in state " + managerEntry.getCurrConnectionState() + " and the configuration tells us to send nevertheless, we queue instead: " + entry.getLogId());
                    action = this.QUEUE_ACTION;
                }
                if (action.doSend()) {
                    resultList.add(entry);
                } else if (action.doQueue()) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Queueing holdback message " + entry.getLogId());
                    }
                    try {
                        this.putToHoldbackQueue(managerEntry, entry);
                    }
                    catch (XmlBlasterException e) {
                        dispatchManager.getMsgErrorHandler().handleError(new MsgErrorInfo(this.glob, entry, dispatchManager, (Throwable)e));
                    }
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Removing from callback queue " + entry.getLogId() + " (is now a holdback message)");
                    }
                    try {
                        dispatchManager.getQueue().removeRandom(entry);
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "Callback queue size is now " + dispatchManager.getQueue().getNumOfEntries());
                        }
                    }
                    catch (XmlBlasterException e) {
                        this.log.error(this.ME, "PANIC: Can't remove " + entry.toXml("") + " from queue '" + dispatchManager.getQueue().getStorageId() + "': " + e.getMessage());
                        e.printStackTrace();
                    }
                } else if (action.doDestroy()) {
                    try {
                        dispatchManager.getQueue().removeRandom(entry);
                    }
                    catch (XmlBlasterException e) {
                        this.log.error(this.ME, "PANIC: Can't remove " + entry.toXml("") + " from queue '" + dispatchManager.getQueue().getStorageId() + "': " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                if (action.doNotifySender()) {
                    this.xmlBlasterClient.sendPtPMessage(entry, this.specificConfigPropertyKey, action.getAction(), this.currMsgStatus);
                }
            }
            ++i;
        }
        entryList.clear();
        return resultList;
    }

    private DispatchManagerEntry getDispatchManagerEntry(DispatchManager dispatchManager) {
        PriorizedDispatchPlugin priorizedDispatchPlugin = this;
        synchronized (priorizedDispatchPlugin) {
            DispatchManagerEntry dispatchManagerEntry = (DispatchManagerEntry)this.dispatchManagerEntryMap.get(dispatchManager);
            return dispatchManagerEntry;
        }
    }

    private void putToHoldbackQueue(DispatchManagerEntry managerEntry, MsgQueueEntry entry) throws XmlBlasterException {
        I_Queue queue = managerEntry.getHoldbackQueue();
        if (queue == null) {
            PriorizedDispatchPlugin priorizedDispatchPlugin = this;
            synchronized (priorizedDispatchPlugin) {
                if (queue == null) {
                    QueuePropertyBase queueProperties = (QueuePropertyBase)managerEntry.getDispatchManager().getQueue().getProperties();
                    String type = queueProperties.getType();
                    String version = queueProperties.getVersion();
                    String typeVersion = this.glob.getProperty().get("PriorizedDispatchPlugin.queue.plugin", type + "," + version);
                    StorageId storageId = new StorageId("PriorizedDispatchPlugin", managerEntry.getDispatchManager().getQueue().getStorageId().getPostfix());
                    queue = this.glob.getQueuePluginManager().getPlugin(typeVersion, storageId, queueProperties);
                    queue.setNotifiedAboutAddOrRemove(true);
                    managerEntry.setHoldbackQueue(queue);
                    this.log.info(this.ME, "Created holdback queue '" + queue.getStorageId() + "' with " + queue.getNumOfEntries() + " entries");
                }
            }
        }
        queue.put(entry, true);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Filled to holdback queue '" + queue.getStorageId() + "' one entry '" + entry.getLogId() + "', it has now " + queue.getNumOfEntries() + " entries");
        }
    }

    private void flushHoldbackQueue(DispatchManagerEntry managerEntry) {
        PriorizedDispatchPlugin priorizedDispatchPlugin = this;
        synchronized (priorizedDispatchPlugin) {
            DispatchManager dispatchManager = managerEntry.getDispatchManager();
            I_Queue holdbackQueue = managerEntry.getHoldbackQueue();
            if (holdbackQueue != null && holdbackQueue.getNumOfEntries() > 0L) {
                this.log.info(this.ME, "Flushing " + holdbackQueue.getNumOfEntries() + " entries from holdback queue " + holdbackQueue.getStorageId());
                ArrayList list = null;
                int lastSize = -99;
                while (holdbackQueue.getNumOfEntries() > 0L) {
                    try {
                        list = holdbackQueue.peek(-1, -1L);
                        if (holdbackQueue.getNumOfEntries() == (long)lastSize) {
                            this.log.error(this.ME, "PANIC: " + holdbackQueue.getNumOfEntries() + " entries from holdback queue " + holdbackQueue.getStorageId() + " can't be flushed, giving up!");
                            break;
                        }
                        lastSize = (int)holdbackQueue.getNumOfEntries();
                    }
                    catch (XmlBlasterException e) {
                        this.log.error(this.ME, "PANIC: Can't flush holdbackQueue '" + holdbackQueue.getStorageId() + "' with " + holdbackQueue.getNumOfEntries() + " entries: " + e.getMessage());
                        e.printStackTrace();
                        continue;
                    }
                    I_QueueEntry[] queueEntries = list.toArray(new MsgQueueEntry[list.size()]);
                    try {
                        dispatchManager.getQueue().put(queueEntries, false);
                    }
                    catch (XmlBlasterException e) {
                        this.log.warn(this.ME, "flushHoldbackQueue() failed: " + e.getMessage());
                        dispatchManager.getMsgErrorHandler().handleError(new MsgErrorInfo(this.glob, (MsgQueueEntry[])queueEntries, dispatchManager, (Throwable)e));
                    }
                    try {
                        long num = holdbackQueue.remove(list.size(), -1L);
                        if (num == (long)list.size()) continue;
                        this.log.error(this.ME, "PANIC: Expected to remove from holdbackQueue '" + holdbackQueue.getStorageId() + "' with " + holdbackQueue.getNumOfEntries() + " entries " + list.size() + " entries, but only " + num + " where removed");
                    }
                    catch (XmlBlasterException e) {
                        this.log.error(this.ME, "PANIC: Expected to remove from holdbackQueue '" + holdbackQueue.getStorageId() + "' with " + holdbackQueue.getNumOfEntries() + " entries " + list.size() + " entries: " + e.getMessage());
                    }
                }
                holdbackQueue.clear();
                dispatchManager.notifyAboutNewEntry();
            } else if (this.log.TRACE) {
                this.log.trace(this.ME, "No holdback queue for " + dispatchManager.getId() + ", nothing to flush");
            }
        }
    }

    public final void toAlive(DispatchManager dispatchManager, ConnectionStateEnum oldState) {
        this.changeManagerState(dispatchManager, ConnectionStateEnum.ALIVE, true);
    }

    public final void toPolling(DispatchManager dispatchManager, ConnectionStateEnum oldState) {
        this.changeManagerState(dispatchManager, ConnectionStateEnum.POLLING, true);
    }

    public final void toDead(DispatchManager dispatchManager, ConnectionStateEnum oldState, String errorText) {
        this.changeManagerState(dispatchManager, ConnectionStateEnum.DEAD, true);
    }

    private DispatchManagerEntry changeManagerState(DispatchManager dispatchManager, ConnectionStateEnum newState, boolean flush) {
        DispatchManagerEntry managerEntry = this.getDispatchManagerEntry(dispatchManager);
        if (managerEntry == null) {
            throw new IllegalArgumentException("Internal error in " + newState + ": dispatchManager=" + dispatchManager.toXml("") + " is unknown, dispatchManagerEntryMap.size()=" + this.dispatchManagerEntryMap.size());
        }
        managerEntry.setCurrConnectionState(newState);
        StatusConfiguration tmp = this.parser.getStatusConfiguration(newState);
        managerEntry.setCurrConnectionStateConfiguration(tmp);
        if (tmp != null) {
            this.log.info(this.ME, "Changing to " + newState + ", found configuration is '" + tmp.toXml(null) + "'");
        } else {
            this.log.info(this.ME, "Changing to connection state " + newState);
        }
        if (flush) {
            this.flushHoldbackQueue(managerEntry);
        }
        return managerEntry;
    }

    private DispatchManagerEntry[] getDispatchManagerEntryArr() {
        PriorizedDispatchPlugin priorizedDispatchPlugin = this;
        synchronized (priorizedDispatchPlugin) {
            DispatchManagerEntry[] dispatchManagerEntryArray = this.dispatchManagerEntryMap.values().toArray(new DispatchManagerEntry[this.dispatchManagerEntryMap.size()]);
            return dispatchManagerEntryArray;
        }
    }

    public void shutdown(DispatchManager dispatchManager) throws XmlBlasterException {
        DispatchManagerEntry de = null;
        PriorizedDispatchPlugin priorizedDispatchPlugin = this;
        synchronized (priorizedDispatchPlugin) {
            de = (DispatchManagerEntry)this.dispatchManagerEntryMap.remove(dispatchManager);
        }
        if (de != null && de.getHoldbackQueue() != null) {
            de.getHoldbackQueue().shutdown();
        }
        PriorizedDispatchPlugin priorizedDispatchPlugin2 = this;
        synchronized (priorizedDispatchPlugin2) {
            if (this.dispatchManagerEntryMap.size() == 0) {
                this.shutdown();
            }
        }
    }

    public void shutdown() throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "shutdown()");
        }
        PriorizedDispatchPlugin priorizedDispatchPlugin = this;
        synchronized (priorizedDispatchPlugin) {
            if (this.isShutdown) {
                return;
            }
            this.glob.getProperty().removePropertyChangeListener(CONFIG_PROPERTY_KEY, this);
            DispatchManagerEntry[] arr = this.getDispatchManagerEntryArr();
            int i = 0;
            while (i < arr.length) {
                this.shutdown(arr[i].getDispatchManager());
                ++i;
            }
            if (this.dispatchManagerEntryMap.size() > 0) {
                this.log.error(this.ME, "Internal cleanup error in dispatchManagerEntryMap");
            }
            this.dispatchManagerEntryMap.clear();
            this.xmlBlasterClient.shutdown(this);
            this.isShutdown = true;
        }
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public String usage() {
        return "";
    }

    public String toXml(String extraOffset) {
        return "";
    }
}

