/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.dispatch.plugins.prio;

import org.jutils.log.LogChannel;
import org.jutils.text.StringHelper;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.dispatch.plugins.prio.DispatchAction;

public final class StatusConfiguration {
    private String ME = "StatusConfiguration";
    private final Global glob;
    private final LogChannel log;
    private final DispatchAction[] dispatchActionArr = new DispatchAction[PriorityEnum.MAX_PRIORITY.getInt() + 1];
    private DispatchAction defaultDispatchAction;
    private String oid;
    private String content;
    private ConnectionStateEnum connectionState;

    public StatusConfiguration(Global glob, String oid, String content, ConnectionStateEnum connectionState, DispatchAction defaultAction) {
        if (defaultAction == null) {
            throw new IllegalArgumentException("Missing defaultAction for connectionState=" + connectionState);
        }
        this.glob = glob;
        this.log = glob.getLog("dispatch");
        this.setOid(oid);
        this.setContent(content);
        this.setConnectionState(connectionState);
        this.defaultDispatchAction = defaultAction;
        this.check(connectionState, this.defaultDispatchAction);
    }

    private void check(ConnectionStateEnum connectionState, DispatchAction action) throws IllegalArgumentException {
        if (action.doSend() && connectionState != null && connectionState != ConnectionStateEnum.UNDEF && connectionState != ConnectionStateEnum.ALIVE) {
            throw new IllegalArgumentException("Connection states which are not ALIVE may not have a SEND action, connectionState=" + connectionState.toString() + " action=" + this.defaultDispatchAction.toString());
        }
    }

    private void setOid(String oid) {
        this.oid = oid == null ? null : oid.trim();
    }

    public String getOid() {
        return this.oid;
    }

    private void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

    public String getContent() {
        return this.content;
    }

    public void setConnectionState(ConnectionStateEnum connectionState) {
        this.connectionState = connectionState;
    }

    public ConnectionStateEnum getConnectionState() {
        return this.connectionState;
    }

    public DispatchAction getDefaultDispatchAction() {
        return this.defaultDispatchAction;
    }

    public boolean defaultActionOnly() {
        int i = 0;
        while (i < this.dispatchActionArr.length) {
            if (this.dispatchActionArr[i] != null && !this.dispatchActionArr[i].defaultActionOnly()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addDispatchAction(String priorityRange, DispatchAction action) {
        PriorityEnum lower;
        String[] lowerUpper;
        if (priorityRange == null || priorityRange.length() < 1) {
            priorityRange = "0-9";
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Given priorityRange is empty, setting it to '" + priorityRange + "'");
            }
        }
        if ((lowerUpper = StringHelper.toArray(priorityRange = priorityRange.trim(), "- ")).length == 0) {
            throw new IllegalArgumentException(this.ME + ": Given priorityRange is empty, ignoring action=" + action.getAction());
        }
        this.check(this.getConnectionState(), action);
        PriorityEnum upper = lower = PriorityEnum.parsePriority(lowerUpper[0]);
        if (lowerUpper.length > 1) {
            upper = PriorityEnum.parsePriority(lowerUpper[1]);
        }
        if (lower.getInt() > upper.getInt()) {
            PriorityEnum tmp = lower;
            lower = upper;
            upper = tmp;
        }
        int i = lower.getInt();
        while (i <= upper.getInt()) {
            if (this.dispatchActionArr[i] != null) {
                this.log.warn(this.ME, "Overwriting dispatch action=" + action.getAction() + " for priority=" + PriorityEnum.toPriorityEnum(i).toString());
            }
            this.dispatchActionArr[i] = action;
            ++i;
        }
    }

    public DispatchAction getDispatchAction(PriorityEnum priority) {
        DispatchAction action = this.dispatchActionArr[priority.getInt()];
        if (action == null) {
            return this.defaultDispatchAction;
        }
        return action;
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer();
        String offset = "\n ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<onStatus");
        if (this.getOid() != null) {
            sb.append(" oid='").append(this.getOid()).append("'");
            sb.append(" content='").append(this.getContent()).append("'");
        }
        if (this.getConnectionState() != null) {
            sb.append(" connectionState='").append(this.getConnectionState()).append("'");
        }
        sb.append(" defaultAction='").append(this.defaultDispatchAction.getAction()).append("'>");
        int i = 0;
        while (i < this.dispatchActionArr.length) {
            if (this.dispatchActionArr[i] != null && !this.dispatchActionArr[i].equals(this.defaultDispatchAction)) {
                sb.append(offset).append(" <action do='");
                sb.append(this.dispatchActionArr[i].getAction());
                sb.append("' ifPriority='").append(i).append("'/>");
            }
            ++i;
        }
        sb.append(offset).append("</onStatus>");
        return sb.toString();
    }
}

