/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.dispatch.plugins.prio;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.client.qos.UpdateReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.dispatch.plugins.prio.I_Notify;
import org.xmlBlaster.util.dispatch.plugins.prio.PriorizedDispatchPlugin;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.qos.address.Destination;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class XmlBlasterNativeClient
implements I_Callback {
    private String ME = "dispatch.plugins.prio.XmlBlasterNativeClient";
    private Global glob;
    private LogChannel log;
    private PriorizedDispatchPlugin plugin;
    private I_XmlBlasterAccess xmlBlasterCon;
    private ConnectQos connectQos;
    private ConnectReturnQos conRetQos;
    private boolean connected;
    private String loginName;
    private Map subscriptionsByNotifierMap = new HashMap();
    private Map oidListenerMap = new HashMap();
    private final String cbSessionId;

    public XmlBlasterNativeClient(Global glob_, PriorizedDispatchPlugin plugin, String sessionId) throws XmlBlasterException {
        String passwd;
        this.glob = glob_.getClone(null);
        this.log = this.glob.getLog("dispatch");
        this.plugin = plugin;
        this.log.info(this.ME, "Connecting to xmlBlaster to subscribe to status messages");
        this.xmlBlasterCon = this.glob.getXmlBlasterAccess();
        this.loginName = this.glob.getProperty().get("PriorizedDispatchPlugin.user", "_PriorizedDispatchPlugin");
        this.cbSessionId = passwd = this.glob.getProperty().get("PriorizedDispatchPlugin.password", "secret");
        this.connectQos = new ConnectQos(this.glob, this.loginName, passwd);
        this.connectQos.setSessionTimeout(0L);
        this.connectQos.setMaxSessions(this.glob.getProperty().get("PriorizedDispatchPlugin.session.maxSessions", 10));
        Address address = new Address(this.glob);
        address.setDispatchPlugin("undef");
        address.setDelay(2000L);
        address.setRetries(-1);
        address.setPingInterval(0L);
        this.connectQos.setAddress(address);
        CallbackAddress cbAddress = new CallbackAddress(this.glob);
        cbAddress.setDispatchPlugin("undef");
        cbAddress.setSecretSessionId(this.cbSessionId);
        this.connectQos.addCallbackAddress(cbAddress);
        this.xmlBlasterCon.registerConnectionListener(new I_ConnectionStateListener(){

            public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                XmlBlasterNativeClient.this.connected = true;
                XmlBlasterNativeClient.this.conRetQos = connection.getConnectReturnQos();
                XmlBlasterNativeClient.this.log.info(XmlBlasterNativeClient.this.ME, "I_ConnectionStateListener: We were lucky, connected to " + connection.getGlobal().getId() + " as " + XmlBlasterNativeClient.this.conRetQos.getSessionName());
            }

            public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                XmlBlasterNativeClient.this.log.warn(XmlBlasterNativeClient.this.ME, "I_ConnectionStateListener: No connection to " + connection.getGlobal().getId());
                XmlBlasterNativeClient.this.connected = false;
            }

            public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
                XmlBlasterNativeClient.this.log.error(XmlBlasterNativeClient.this.ME, "I_ConnectionStateListener: Connection to " + connection.getGlobal().getId() + " is dead");
                XmlBlasterNativeClient.this.connected = false;
            }
        });
        try {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Connecting to xmlBlaster as user '" + this.loginName + "' to subscribe to status messages");
            }
            this.conRetQos = this.xmlBlasterCon.connect(this.connectQos, this);
            this.connected = true;
            this.loginName = this.conRetQos.getUserId();
            this.log.info(this.ME, "Succefully initialized");
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Can't subscribe to status messages: " + e.getMessage());
        }
    }

    public String getLoginName() {
        return this.loginName;
    }

    public final void sendPtPMessage(MsgQueueEntry entry, String pluginName, String action, String currStatus) throws XmlBlasterException {
        SessionName receiver = entry.getSender();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Sending PtP notification about special message treatment in plugin, dispatcher state=" + currStatus + " receiver '" + receiver + "' ...");
        }
        PublishQos pq = new PublishQos(this.glob);
        pq.addDestination(new Destination(receiver));
        pq.setSender(new SessionName(this.glob, this.getLoginName()));
        pq.setSubscribable(false);
        pq.setState(action);
        pq.setStateInfo("Notification about special message treatment in plugin " + pluginName + ", dispatcher state=" + currStatus);
        MsgUnit msgUnit = new MsgUnit(this.glob, "<key oid='" + entry.getKeyOid() + "'/>", "", pq.toXml());
        this.xmlBlasterCon.publish(msgUnit);
    }

    public void subscribeToStatusMessage(String msgOid, I_Notify callback) throws XmlBlasterException {
        if (msgOid == null) {
            return;
        }
        Map map = this.oidListenerMap;
        synchronized (map) {
            Set listeners = (Set)this.oidListenerMap.get(msgOid);
            if (listeners != null && listeners.contains(callback)) {
                return;
            }
        }
        SubscribeKey sk = new SubscribeKey(this.glob, msgOid);
        SubscribeQos sq = new SubscribeQos(this.glob);
        SubscribeReturnQos subscribeReturnQos = this.xmlBlasterCon.subscribe(sk.toXml(), sq.toXml());
        Map map2 = this.subscriptionsByNotifierMap;
        synchronized (map2) {
            HashSet<SubscribeReturnQos> subscriptions = (HashSet<SubscribeReturnQos>)this.subscriptionsByNotifierMap.get(callback);
            if (subscriptions == null) {
                subscriptions = new HashSet<SubscribeReturnQos>();
                this.subscriptionsByNotifierMap.put(callback, subscriptions);
            }
            subscriptions.add(subscribeReturnQos);
        }
        Map map3 = this.oidListenerMap;
        synchronized (map3) {
            HashSet<I_Notify> listeners = (HashSet<I_Notify>)this.oidListenerMap.get(msgOid);
            if (listeners == null) {
                listeners = new HashSet<I_Notify>();
                this.oidListenerMap.put(msgOid, listeners);
            }
            listeners.add(callback);
        }
    }

    public void unSubscribeStatusMessages(I_Notify callback) {
        Map map = this.oidListenerMap;
        synchronized (map) {
            String oid;
            Iterator<Object> it = this.oidListenerMap.values().iterator();
            while (it.hasNext()) {
                Set listeners = (Set)it.next();
                listeners.remove(callback);
            }
            HashSet<String> emptyOidSet = new HashSet<String>();
            it = this.oidListenerMap.keySet().iterator();
            while (it.hasNext()) {
                oid = (String)it.next();
                Set listeners = (Set)this.oidListenerMap.get(oid);
                if (listeners.size() != 0) continue;
                emptyOidSet.add(oid);
            }
            it = emptyOidSet.iterator();
            while (it.hasNext()) {
                oid = (String)it.next();
                this.oidListenerMap.remove(oid);
            }
        }
        Set subscriptions = null;
        Map map2 = this.subscriptionsByNotifierMap;
        synchronized (map2) {
            subscriptions = (Set)this.subscriptionsByNotifierMap.get(callback);
        }
        if (subscriptions != null) {
            Iterator it = subscriptions.iterator();
            while (it.hasNext()) {
                SubscribeReturnQos subscribeRetQos = (SubscribeReturnQos)it.next();
                try {
                    UnSubscribeKey uk = new UnSubscribeKey(this.glob, subscribeRetQos.getSubscriptionId());
                    UnSubscribeQos uq = new UnSubscribeQos(this.glob);
                    this.xmlBlasterCon.unSubscribe(uk.toXml(), uq.toXml());
                }
                catch (XmlBlasterException e) {
                    this.log.warn(this.ME, "Unsubscribe failed: " + e.getMessage());
                }
            }
            subscriptions.clear();
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (!this.cbSessionId.equals(cbSessionId)) {
            this.log.warn(this.ME, "The given cbSessionId=" + cbSessionId + " is unknown, we don't trust this callback of a status message with oid=" + updateKey.getOid());
            UpdateReturnQos q = new UpdateReturnQos(this.glob);
            q.setState("ERROR");
            q.setStateInfo("Callback access denied");
            return q.toXml();
        }
        if (updateKey.isInternal()) {
            return "";
        }
        if (updateQos.isErased()) {
            return "";
        }
        String contentStr = new String(content);
        if (!updateQos.isOk()) {
            this.log.warn(this.ME, "Receiving unexpected asynchronous status message '" + updateKey.getOid() + "' state=" + updateQos.getState() + " with content='" + contentStr + "'");
            return "";
        }
        this.log.info(this.ME, "Receiving asynchronous status message '" + updateKey.getOid() + "' state=" + updateQos.getState() + " with content='" + contentStr + "'");
        Map map = this.oidListenerMap;
        synchronized (map) {
            Set listeners = (Set)this.oidListenerMap.get(updateKey.getOid());
            if (listeners != null) {
                Iterator it = listeners.iterator();
                while (it.hasNext()) {
                    I_Notify callback = (I_Notify)it.next();
                    callback.statusChanged(contentStr);
                }
            } else {
                this.log.warn(this.ME, "Receiving asynchronous status message '" + updateKey.getOid() + "' state=" + updateQos.getState() + " with content='" + contentStr + "' but nobody is interested in it");
            }
        }
        return "";
    }

    void shutdown(I_Notify callback) {
        this.unSubscribeStatusMessages(callback);
        Map map = this.subscriptionsByNotifierMap;
        synchronized (map) {
            this.subscriptionsByNotifierMap.remove(callback);
        }
        XmlBlasterNativeClient xmlBlasterNativeClient = this;
        synchronized (xmlBlasterNativeClient) {
            if (this.subscriptionsByNotifierMap.size() < 1) {
                this.shutdown();
            }
        }
    }

    synchronized void shutdown() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "shutdown()");
        }
        Map map = this.subscriptionsByNotifierMap;
        synchronized (map) {
            Iterator it = this.subscriptionsByNotifierMap.values().iterator();
            while (it.hasNext()) {
                ((Set)it.next()).clear();
            }
            this.subscriptionsByNotifierMap.clear();
        }
        Map map2 = this.oidListenerMap;
        synchronized (map2) {
            Iterator it = this.oidListenerMap.values().iterator();
            while (it.hasNext()) {
                ((Set)it.next()).clear();
            }
            this.oidListenerMap.clear();
        }
        if (this.xmlBlasterCon != null) {
            this.xmlBlasterCon.disconnect(null);
            this.xmlBlasterCon = null;
        }
        this.log.info(this.ME, "Native xmlBlaster access stopped, resources released.");
        this.glob = null;
        this.log = null;
        this.plugin = null;
        this.connectQos = null;
        this.conRetQos = null;
        this.subscriptionsByNotifierMap = null;
        this.oidListenerMap = null;
    }
}

