/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.error;

import java.io.Serializable;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.error.I_MsgErrorInfo;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class MsgErrorInfo
implements I_MsgErrorInfo,
Serializable {
    private final MsgQueueEntry[] msgQueueEntries;
    private final DispatchManager dispatchManager;
    private final XmlBlasterException xmlBlasterException;

    public MsgErrorInfo(Global glob, MsgQueueEntry msgQueueEntry, DispatchManager dispatchManager, Throwable throwable) {
        MsgQueueEntry[] msgQueueEntryArray;
        if (msgQueueEntry == null) {
            msgQueueEntryArray = new MsgQueueEntry[]{};
        } else {
            MsgQueueEntry[] msgQueueEntryArray2 = new MsgQueueEntry[1];
            msgQueueEntryArray = msgQueueEntryArray2;
            msgQueueEntryArray2[0] = msgQueueEntry;
        }
        this(glob, msgQueueEntryArray, dispatchManager, throwable);
    }

    public MsgErrorInfo(Global glob, MsgQueueEntry[] msgQueueEntries, DispatchManager dispatchManager, Throwable throwable) {
        if (throwable == null) {
            Thread.dumpStack();
            throw new IllegalArgumentException("MsgErrorInfo: xmlBlasterException may not be null");
        }
        this.msgQueueEntries = msgQueueEntries == null ? new MsgQueueEntry[]{} : msgQueueEntries;
        this.dispatchManager = dispatchManager;
        this.xmlBlasterException = throwable instanceof XmlBlasterException ? (XmlBlasterException)throwable : new XmlBlasterException(glob, ErrorCode.INTERNAL_UNKNOWN, "MsgErrorInfo.INTERNAL", throwable == null ? "NO INFO" : throwable.toString());
    }

    public MsgQueueEntry[] getMsgQueueEntries() {
        return this.msgQueueEntries;
    }

    public I_Queue getQueue() {
        return this.dispatchManager != null ? this.dispatchManager.getQueue() : null;
    }

    public DispatchManager getDispatchManager() {
        return this.dispatchManager;
    }

    public XmlBlasterException getXmlBlasterException() {
        return this.xmlBlasterException;
    }

    public String toString() {
        if (this.msgQueueEntries.length != 1) {
            return "Problems with " + this.msgQueueEntries.length + " MsgQueueEntries " + " - " + this.xmlBlasterException.getMessage();
        }
        return this.msgQueueEntries[0].getLogId() + " - " + this.xmlBlasterException.getMessage();
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<MsgErrorInfo>");
        int i = 0;
        while (i < this.msgQueueEntries.length) {
            sb.append(this.msgQueueEntries[i].toXml(extraOffset + " "));
            ++i;
        }
        sb.append(this.xmlBlasterException.toXml(extraOffset + " "));
        sb.append(offset).append("</MsgErrorInfo>");
        return sb.toString();
    }
}

