/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.key;

import java.io.Serializable;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.Timestamp;

public abstract class KeyData
implements Serializable,
Cloneable {
    private static final String ME = "KeyData";
    protected transient Global glob;
    protected transient LogChannel log;
    protected final transient String serialData;
    private String oid;
    public static final transient String CONTENTMIME_DEFAULT = "text/plain";
    private String contentMime = "text/plain";
    public static final transient String CONTENTMIMEEXTENDED_DEFAULT = null;
    private String contentMimeExtended = CONTENTMIMEEXTENDED_DEFAULT;
    public static final transient String DEFAULT_DOMAIN = null;
    private String domain = DEFAULT_DOMAIN;
    private boolean isGeneratedOid = false;
    public static final transient String QUERYTYPE_DEFAULT = "EXACT";
    protected String queryType = "EXACT";
    protected String queryString;

    public KeyData(Global glob, String serialData) {
        this.setGlobal(glob);
        this.serialData = serialData;
    }

    public void setGlobal(Global glob) {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("core");
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getOid() {
        return this.oid;
    }

    public boolean hasOid() {
        return this.oid != null;
    }

    public final boolean isDeadMessage() {
        return "__sys__deadMessage".equals(this.oid);
    }

    public final boolean isPluginInternal() {
        return this.oid == null ? false : this.oid.startsWith("_") && !this.oid.startsWith("__");
    }

    public final boolean isInternal() {
        return this.oid == null ? false : this.oid.startsWith("__");
    }

    public final boolean isAdministrative() {
        return this.oid == null ? false : this.oid.startsWith("__cmd:");
    }

    public void setContentMime(String contentMime) {
        this.contentMime = contentMime;
    }

    public String getContentMime() {
        return this.contentMime;
    }

    public void setContentMimeExtended(String contentMimeExtended) {
        this.contentMimeExtended = contentMimeExtended;
    }

    public String getContentMimeExtended() {
        return this.contentMimeExtended;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public final boolean isDefaultDomain() {
        return this.domain == null || this.domain.equals(DEFAULT_DOMAIN);
    }

    public String getQueryType() {
        return this.queryType;
    }

    public boolean isExact() {
        return QUERYTYPE_DEFAULT.equals(this.queryType);
    }

    public boolean isQuery() {
        return "XPATH".equals(this.queryType) || "REGEX".equals(this.queryType);
    }

    public boolean isXPath() {
        return "XPATH".equals(this.queryType);
    }

    public boolean isDomain() {
        return "DOMAIN".equals(this.queryType);
    }

    public int size() {
        return this.toXml().length();
    }

    public String toString() {
        return this.toXml();
    }

    public abstract String toXml();

    public abstract String toXml(String var1);

    public String generateOid(String uniquePrefix) {
        StringBuffer oid = new StringBuffer(80);
        Timestamp timestamp = new Timestamp();
        oid.append(uniquePrefix).append("-").append(timestamp.getTimestamp());
        this.isGeneratedOid = true;
        return oid.toString();
    }

    public boolean isGeneratedOid() {
        return this.isGeneratedOid;
    }

    public final Global getGlobal() {
        return this.glob;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

