/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.key;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.key.I_MsgKeyFactory;
import org.xmlBlaster.util.key.KeyData;

public final class MsgKeyData
extends KeyData
implements Serializable,
Cloneable {
    private static final String ME = "MsgKeyData";
    private transient I_MsgKeyFactory factory;
    private String clientTags;

    public MsgKeyData(Global glob) {
        this(glob, null, null);
    }

    public MsgKeyData(Global glob, String serialData) {
        this(glob, null, serialData);
    }

    public MsgKeyData(Global glob, I_MsgKeyFactory factory, String serialData) {
        super(glob, serialData);
        this.factory = factory == null ? this.glob.getMsgKeyFactory() : factory;
    }

    public String getOid() {
        if (super.getOid() == null) {
            this.setOid(this.generateOid(this.glob.getStrippedId()));
        }
        return super.getOid();
    }

    public void setClientTags(String tags) {
        this.clientTags = tags;
    }

    public String getClientTags() {
        return this.clientTags;
    }

    private I_MsgKeyFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.glob.getMsgKeyFactory();
        }
        return this.factory;
    }

    public String toXml() {
        return this.getFactory().writeObject(this, null);
    }

    public String toXml(String extraOffset) {
        return this.getFactory().writeObject(this, extraOffset);
    }

    public Object clone() {
        return super.clone();
    }

    public Hashtable toJXPath() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        if (this.getOid() != null) {
            map.put("/key/@oid", this.getOid());
        }
        if (this.getContentMime() != null) {
            map.put("/key/@contentMime", this.getContentMime());
        }
        if (this.getContentMimeExtended() != null) {
            map.put("/key/@contentMimeExtended", this.getContentMimeExtended());
        }
        if (this.getClientTags() != null) {
            map.put("/key/child::node()", this.getClientTags());
        }
        return map;
    }

    public static void main(String[] args) {
        MsgKeyData key = new MsgKeyData(null);
        String clientTags = "<agent xmlns:aa='http://XX'>\n<![CDATA[ Hello\n world\n]]></agent>";
        key.setClientTags(clientTags);
        System.out.println(key.getClientTags());
        MsgKeyData md = new MsgKeyData(new Global(args));
        Hashtable map = md.toJXPath();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key2 = (String)it.next();
            System.out.println(key2 + " -> '" + map.get(key2) + "'");
        }
    }
}

