/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.key;

import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SaxHandlerBase;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.key.I_MsgKeyFactory;
import org.xmlBlaster.util.key.KeyData;
import org.xmlBlaster.util.key.MsgKeyData;

public final class MsgKeySaxFactory
extends SaxHandlerBase
implements I_MsgKeyFactory {
    private String ME = "MsgKeySaxFactory";
    private final Global glob;
    private final LogChannel log;
    private MsgKeyData msgKeyData;
    private int inKey = 0;

    public MsgKeySaxFactory(Global glob) {
        super(glob);
        this.glob = glob;
        this.log = glob.getLog("core");
    }

    public synchronized MsgKeyData readObject(String xmlKey) throws XmlBlasterException {
        if (xmlKey == null) {
            xmlKey = "<key/>";
        }
        this.msgKeyData = new MsgKeyData(this.glob, this, xmlKey);
        this.init(xmlKey);
        if (this.msgKeyData.getOid() == null || this.msgKeyData.getOid().length() < 1) {
            this.msgKeyData.setOid(this.msgKeyData.generateOid(this.glob.getStrippedId()));
        }
        MsgKeyData tmp = this.msgKeyData;
        this.msgKeyData = null;
        return tmp;
    }

    public final void startElement(String uri, String localName, String name, Attributes attrs) {
        if (name.equalsIgnoreCase("key")) {
            ++this.inKey;
            if (this.inKey < 2) {
                if (attrs != null) {
                    String tmp = attrs.getValue("oid");
                    if (tmp != null) {
                        this.msgKeyData.setOid(tmp.trim());
                    }
                    tmp = attrs.getValue("queryType");
                    tmp = attrs.getValue("contentMime");
                    if (tmp != null) {
                        this.msgKeyData.setContentMime(tmp.trim());
                    }
                    if ((tmp = attrs.getValue("contentMimeExtended")) != null) {
                        this.msgKeyData.setContentMimeExtended(tmp.trim());
                    }
                    if ((tmp = attrs.getValue("domain")) != null) {
                        this.msgKeyData.setDomain(tmp.trim());
                    }
                }
                this.character.setLength(0);
                return;
            }
        }
        if (this.inKey > 0) {
            String nameSpaceStr = null;
            if (uri != null && uri.length() > 0) {
                String nameSpace = name.substring(0, name.indexOf(":"));
                nameSpaceStr = " xmlns:" + nameSpace + "='" + uri + "'";
            }
            this.character.append("<").append(name);
            if (nameSpaceStr != null) {
                this.character.append(nameSpaceStr);
            }
            if (attrs != null) {
                int len = attrs.getLength();
                int ii = 0;
                while (ii < len) {
                    this.character.append(" ").append(attrs.getQName(ii)).append("='").append(attrs.getValue(ii)).append("'");
                    ++ii;
                }
            }
            this.character.append(">");
        }
    }

    public void endElement(String uri, String localName, String name) {
        if (name.equalsIgnoreCase("key")) {
            --this.inKey;
            if (this.inKey < 1) {
                String tmp = this.character.toString().trim();
                if (tmp.length() > 0) {
                    this.msgKeyData.setClientTags(tmp);
                }
                this.character.setLength(0);
            }
        }
        if (this.inKey > 0) {
            this.character.append("</" + name + ">");
        }
    }

    public final String writeObject(MsgKeyData msgKeyData, String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<key oid='").append(msgKeyData.getOid()).append("'");
        if (msgKeyData.getContentMime() != null && !msgKeyData.getContentMime().equals("text/plain")) {
            sb.append(" contentMime='").append(msgKeyData.getContentMime()).append("'");
        }
        if (msgKeyData.getContentMimeExtended() != null && !msgKeyData.getContentMimeExtended().equals(KeyData.CONTENTMIMEEXTENDED_DEFAULT)) {
            sb.append(" contentMimeExtended='").append(msgKeyData.getContentMimeExtended()).append("'");
        }
        if (msgKeyData.getDomain() != null && msgKeyData.getDomain().length() > 0) {
            sb.append(" domain='").append(msgKeyData.getDomain()).append("'");
        }
        if (msgKeyData.getClientTags() != null) {
            sb.append(">");
            sb.append(offset).append(extraOffset).append(" ").append(msgKeyData.getClientTags());
            sb.append(offset).append("</key>");
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }

    public String getName() {
        return "MsgKeySaxFactory";
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        MsgKeySaxFactory factory = new MsgKeySaxFactory(glob);
        String xml = "<key oid='HELLO' contentMime='image/gif' contentMimeExtended='2.0' domain='RUGBY'>\n   Bla1\n   <a><b></b></a>\n   <![CDATA[Bla2]]>\n   <c></c>\n   Bla3\n</key>\n";
        try {
            MsgKeyData key = factory.readObject(xml);
            System.out.println("RESULT\n" + key.toXml());
        }
        catch (Throwable e) {
            System.out.println("ERROR: " + e.toString());
        }
    }
}

