/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.key;

import java.io.Serializable;
import java.util.ArrayList;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.I_QueryKeyFactory;
import org.xmlBlaster.util.key.KeyData;
import org.xmlBlaster.util.qos.AccessFilterQos;

public final class QueryKeyData
extends KeyData
implements Serializable,
Cloneable {
    private static final String ME = "QueryKeyData";
    private transient I_QueryKeyFactory factory;
    protected ArrayList filterList = null;
    protected transient AccessFilterQos[] filterArr = null;

    public QueryKeyData(Global glob) {
        this(glob, (I_QueryKeyFactory)null, (String)null);
    }

    public QueryKeyData(Global glob, String query, String queryType) throws XmlBlasterException {
        this(glob);
        if (query == null) {
            throw new IllegalArgumentException("QueryKeyData got query=null argument");
        }
        this.queryType = this.checkQueryType(queryType);
        if (this.isExact()) {
            this.setOid(query);
        } else if (this.isXPath()) {
            this.queryString = query;
        } else if (this.isDomain()) {
            this.setDomain(query);
        } else {
            throw new XmlBlasterException(glob, ErrorCode.INTERNAL_UNKNOWN, ME, "Your queryType=" + queryType + " is invalid, implementation is missing");
        }
    }

    public QueryKeyData(Global glob, I_QueryKeyFactory factory, String serialData) {
        super(glob, serialData);
        this.factory = factory == null ? this.glob.getQueryKeyFactory() : factory;
    }

    public static String generateSubscriptionId(String uniquePrefix) {
        StringBuffer sb = new StringBuffer(126);
        Timestamp timestamp = new Timestamp();
        sb.append("__subId:");
        sb.append(uniquePrefix);
        sb.append("-").append(timestamp.getTimestamp());
        return sb.toString();
    }

    public String checkQueryType(String queryType) throws XmlBlasterException {
        if (!("EXACT".equals(queryType = queryType.toUpperCase()) || "XPATH".equals(queryType) || "DOMAIN".equals(queryType))) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, ME, "Your queryType=" + queryType + " is invalid, use one of '" + "EXACT" + "' , '" + "XPATH" + "', '" + "DOMAIN" + "'");
        }
        return queryType;
    }

    void setQueryType(String queryType) throws XmlBlasterException {
        this.queryType = this.checkQueryType(queryType);
    }

    public void setOid(String oid) {
        this.queryType = "EXACT";
        super.setOid(oid);
    }

    public void setDomain(String domain) {
        super.setDomain(domain);
    }

    public void setQueryString(String query) {
        this.queryType = "XPATH";
        this.queryString = query;
    }

    public void appendQueryString(String query) {
        this.queryType = "XPATH";
        this.queryString = this.queryString == null ? query : this.queryString + query;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getNiceString() {
        if (this.getOid() != null && this.getOid().length() > 0) {
            return this.getOid();
        }
        return this.getQueryString();
    }

    public AccessFilterQos[] getAccessFilterArr() {
        if (this.filterArr != null) {
            return this.filterArr;
        }
        if (this.filterList == null) {
            return null;
        }
        this.filterArr = new AccessFilterQos[this.filterList.size()];
        this.filterList.toArray(this.filterArr);
        return this.filterArr;
    }

    public void addFilter(AccessFilterQos qos) {
        if (this.filterList == null) {
            this.filterList = new ArrayList();
        }
        this.filterList.add(qos);
        this.filterArr = null;
    }

    private I_QueryKeyFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.glob.getQueryKeyFactory();
        }
        return this.factory;
    }

    public String toXml() {
        return this.getFactory().writeObject(this, null);
    }

    public String toXml(String extraOffset) {
        return this.getFactory().writeObject(this, extraOffset);
    }

    public Object clone() {
        return super.clone();
    }
}

