/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.key;

import java.util.HashSet;
import java.util.Set;
import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SaxHandlerBase;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.key.I_QueryKeyFactory;
import org.xmlBlaster.util.key.KeyData;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.AccessFilterQos;

public final class QueryKeySaxFactory
extends SaxHandlerBase
implements I_QueryKeyFactory {
    private String ME = "QueryKeySaxFactory";
    private final Global glob;
    private final LogChannel log;
    private QueryKeyData queryKeyData;
    private transient int inKey = 0;
    private transient boolean inFilter = false;
    private transient AccessFilterQos tmpFilter = null;
    private StringBuffer innerTags;
    private boolean inCdata = false;
    private Set nameSpaceSet;

    public QueryKeySaxFactory(Global glob) {
        super(glob);
        this.glob = glob;
        this.log = glob.getLog("core");
    }

    public synchronized QueryKeyData readObject(String xmlKey) throws XmlBlasterException {
        if (xmlKey == null) {
            xmlKey = "<key/>";
        }
        this.queryKeyData = new QueryKeyData(this.glob, this, xmlKey);
        this.init(xmlKey);
        return this.queryKeyData;
    }

    public final void startElement(String uri, String localName, String name, Attributes attrs) {
        if (this.inKey == 0 && name.equalsIgnoreCase("key")) {
            ++this.inKey;
            if (attrs != null) {
                String tmp = attrs.getValue("oid");
                if (tmp != null) {
                    this.queryKeyData.setOid(tmp.trim());
                }
                if ((tmp = attrs.getValue("contentMime")) != null) {
                    this.queryKeyData.setContentMime(tmp.trim());
                }
                if ((tmp = attrs.getValue("contentMimeExtended")) != null) {
                    this.queryKeyData.setContentMimeExtended(tmp.trim());
                }
                if ((tmp = attrs.getValue("domain")) != null) {
                    this.queryKeyData.setDomain(tmp.trim());
                }
                tmp = attrs.getValue("queryType");
                try {
                    if (tmp != null) {
                        this.queryKeyData.setQueryType(tmp.trim());
                    }
                }
                catch (XmlBlasterException e) {
                    this.log.error(this.ME, e.toString());
                }
            }
            this.character.setLength(0);
            return;
        }
        if (this.inKey == 1 && name.equalsIgnoreCase("filter")) {
            this.inFilter = true;
            if (this.character.length() > 0) {
                if (this.innerTags == null) {
                    this.innerTags = new StringBuffer();
                }
                this.innerTags.append(this.character.toString().trim());
                this.character.setLength(0);
            }
            this.tmpFilter = new AccessFilterQos(this.glob);
            boolean ok = this.tmpFilter.startElement(uri, localName, name, this.character, attrs);
            if (ok) {
                this.queryKeyData.addFilter(this.tmpFilter);
            } else {
                this.tmpFilter = null;
            }
            return;
        }
        if (this.inKey > 0) {
            String nameSpaceStr = null;
            if (this.innerTags == null) {
                this.innerTags = new StringBuffer();
            }
            if (uri != null && uri.length() > 0) {
                if (this.nameSpaceSet == null) {
                    this.nameSpaceSet = new HashSet();
                }
                if (!this.nameSpaceSet.contains(uri)) {
                    this.nameSpaceSet.add(uri);
                    String nameSpace = name.substring(0, name.indexOf(":"));
                    nameSpaceStr = " xmlns:" + nameSpace + "='" + uri + "'";
                }
            }
            this.innerTags.append("<").append(name);
            if (nameSpaceStr != null) {
                this.innerTags.append(nameSpaceStr);
            }
            if (attrs != null) {
                int len = attrs.getLength();
                int ii = 0;
                while (ii < len) {
                    this.innerTags.append(" ").append(attrs.getQName(ii)).append("='").append(attrs.getValue(ii)).append("'");
                    ++ii;
                }
            }
            this.innerTags.append(">");
            if (this.character.length() > 0) {
                String tmp = this.character.toString().trim();
                this.character.setLength(0);
                if (tmp.indexOf("<") > -1) {
                    this.inCdata = true;
                    this.innerTags.append("<![CDATA[");
                }
                this.innerTags.append(tmp);
            }
            return;
        }
    }

    public void endElement(String uri, String localName, String name) {
        String tmp;
        if (this.inKey == 1 && name.equalsIgnoreCase("key")) {
            --this.inKey;
            tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.queryKeyData.appendQueryString(tmp);
            }
            if (this.innerTags != null && this.innerTags.length() > 0) {
                this.queryKeyData.appendQueryString(this.innerTags.toString());
                this.innerTags.setLength(0);
                this.innerTags = null;
            }
            this.character.setLength(0);
        }
        if (this.inKey == 1 && name.equalsIgnoreCase("filter")) {
            this.inFilter = false;
            if (this.tmpFilter != null) {
                this.tmpFilter.endElement(uri, localName, name, this.character);
            }
            return;
        }
        if (this.inKey > 0) {
            if (this.innerTags == null) {
                this.innerTags = new StringBuffer();
            }
            tmp = this.character.toString();
            this.character.setLength(0);
            if (tmp.indexOf("<") > -1) {
                this.inCdata = true;
                this.innerTags.append("<![CDATA[");
            }
            this.innerTags.append(tmp);
            if (this.inCdata) {
                this.inCdata = false;
                this.innerTags.append("]]>");
            }
            this.innerTags.append("</" + name + ">");
        }
    }

    public final String writeObject(QueryKeyData queryKeyData, String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<key");
        if (queryKeyData.getOid() != null) {
            sb.append(" oid='").append(queryKeyData.getOid()).append("'");
        }
        if (queryKeyData.getContentMime() != null && !queryKeyData.getContentMime().equals("text/plain")) {
            sb.append(" contentMime='").append(queryKeyData.getContentMime()).append("'");
        }
        if (queryKeyData.getContentMimeExtended() != null && !queryKeyData.getContentMimeExtended().equals(KeyData.CONTENTMIMEEXTENDED_DEFAULT)) {
            sb.append(" contentMimeExtended='").append(queryKeyData.getContentMimeExtended()).append("'");
        }
        if (queryKeyData.getDomain() != null && queryKeyData.getDomain().length() > 0) {
            sb.append(" domain='").append(queryKeyData.getDomain()).append("'");
        }
        if (queryKeyData.getQueryType() != null && !"EXACT".equals(queryKeyData.getQueryType())) {
            sb.append(" queryType='").append(queryKeyData.getQueryType()).append("'");
        }
        boolean isClosed = false;
        if (queryKeyData.getQueryString() != null) {
            if (!isClosed) {
                sb.append(">");
                isClosed = true;
            }
            sb.append(offset).append(" ").append(queryKeyData.getQueryString());
        }
        AccessFilterQos[] list = queryKeyData.getAccessFilterArr();
        int ii = 0;
        while (list != null && ii < list.length) {
            if (!isClosed) {
                sb.append(">");
                isClosed = true;
            }
            sb.append(list[ii].toXml(extraOffset + " "));
            ++ii;
        }
        if (!isClosed) {
            sb.append("/>");
        } else {
            sb.append(offset).append("</key>");
        }
        return sb.toString();
    }

    public String getName() {
        return "QueryKeySaxFactory";
    }
}

