/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.log;

import java.util.Properties;
import org.jutils.log.LogChannel;
import org.jutils.log.LogDeviceFile;
import org.jutils.log.LogableDevice;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.log.I_LogDeviceFactory;
import org.xmlBlaster.util.plugin.PluginInfo;

public class FileLogDeviceFactory
implements I_LogDeviceFactory {
    public static final String LOG_FILE = "logFile";
    protected String logFile;
    protected Global glob;

    public void init(Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        this.glob = glob;
        Properties prop = pluginInfo.getParameters();
        this.logFile = glob.getProperty().get(LOG_FILE, (String)null);
        if (this.logFile == null) {
            this.logFile = prop.getProperty(LOG_FILE, null);
        }
    }

    public String getType() {
        return "file";
    }

    public String getVersion() {
        return "1.0";
    }

    public LogableDevice getLogDevice(LogChannel channel) {
        String key = channel.getChannelKey();
        String strFilename = null;
        if (key != null) {
            strFilename = this.glob.getProperty().get("logFile[" + key + "]", this.logFile);
        }
        if (strFilename != null) {
            return new LogDeviceFile(channel, strFilename);
        }
        return null;
    }

    public void shutdown() throws XmlBlasterException {
    }
}

