/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.log;

import java.util.Hashtable;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.log.I_LogDeviceFactory;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;

public class LogDevicePluginManager
implements I_PluginManager {
    private static final String ME = "LogDevicePluginManager";
    public static final String PLUGIN_NAME = "LoggableDevicePlugin";
    protected Global glob = null;
    protected Hashtable managers = new Hashtable();

    public LogDevicePluginManager(Global glob) {
        this.glob = glob;
    }

    public String getDefaultPluginName(String type, String version) {
        return "LoggableDevicePlugin[console][1.0]=org.xmlBlaster.util.log.ConsoleLogDeviceFactory";
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public I_LogDeviceFactory getFactory(String type, String version) throws XmlBlasterException {
        return (I_LogDeviceFactory)this.getPluginObject(type, version);
    }

    public I_Plugin getPluginObject(String type, String version) throws XmlBlasterException {
        I_LogDeviceFactory plug = null;
        PluginInfo pluginInfo = new PluginInfo(this.glob, (I_PluginManager)this, type, version);
        plug = (I_LogDeviceFactory)this.managers.get(pluginInfo.getClassName());
        if (plug != null) {
            return plug;
        }
        plug = this.instantiatePlugin(pluginInfo);
        return plug;
    }

    public final String createPluginPropertyKey(String type, String version) {
        StringBuffer buf = new StringBuffer(80);
        buf.append(this.getName());
        if (type != null) {
            buf.append("[").append(type).append("]");
        }
        if (version != null) {
            buf.append("[").append(version).append("]");
        }
        return buf.toString();
    }

    protected I_LogDeviceFactory instantiatePlugin(PluginInfo pluginInfo) throws XmlBlasterException {
        I_LogDeviceFactory plugin = null;
        String pluginName = pluginInfo.getClassName();
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(pluginName);
            plugin = (I_LogDeviceFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new XmlBlasterException(ME, "Could not find class: " + pluginName + " " + e);
        }
        catch (InstantiationException e) {
            throw new XmlBlasterException(ME, "Could not instantiate class: " + pluginName + " " + e);
        }
        catch (IllegalAccessException e) {
            throw new XmlBlasterException(ME, "Could not access class: " + pluginName + " " + e);
        }
        if (plugin != null) {
            try {
                plugin.init(this.glob, pluginInfo);
            }
            catch (XmlBlasterException e) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, ME, "Initializing of plugin " + plugin.getType() + " failed", e);
            }
        }
        this.managers.put(pluginName, plugin);
        return plugin;
    }
}

