/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.plugin;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.context.ContextNode;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.property.PropString;

public class PluginInfo {
    private Global glob;
    private LogChannel log;
    private String ME;
    private String propertyName;
    private String propertyKey;
    private String type;
    private String version;
    private String className;
    private Properties params;
    private Object userData;

    public PluginInfo(Global glob, String type, String className, Properties params) {
        this.ME = "PluginInfo-" + type;
        this.glob = glob;
        this.log = glob.getLog("core");
        if (this.log.CALL) {
            this.log.call(this.ME, "constructor type='" + type + "' className='" + className + "'");
        }
        this.type = type.trim();
        this.className = className;
        this.params = params;
        this.version = "1.0";
    }

    public String getId() {
        return this.getTypeVersion();
    }

    public PluginInfo(Global glob, I_PluginManager manager, String typeVersion) throws XmlBlasterException {
        this(glob, manager, typeVersion, (ContextNode)null);
    }

    public PluginInfo(Global glob, I_PluginManager manager, String typeVersion, ContextNode contextNode) throws XmlBlasterException {
        String type_;
        String version_;
        if (typeVersion == null) {
            this.init(glob, manager, null, null, null);
            return;
        }
        int i = typeVersion.indexOf(44);
        if (i == -1) {
            version_ = null;
            type_ = typeVersion.trim();
        } else {
            version_ = typeVersion.substring(i + 1);
            type_ = typeVersion.substring(0, i);
        }
        this.init(glob, manager, type_, version_, contextNode);
    }

    public PluginInfo(Global glob, I_PluginManager manager, String type, String version, ContextNode contextNode) throws XmlBlasterException {
        this.init(glob, manager, type, version, contextNode);
    }

    public PluginInfo(Global glob, I_PluginManager manager, String type, String version) throws XmlBlasterException {
        this(glob, manager, type, version, null);
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Object getUserData() {
        return this.userData;
    }

    private void init(Global glob, I_PluginManager manager, String type_, String version_, ContextNode contextNode) throws XmlBlasterException {
        String rawString;
        this.glob = glob;
        this.log = glob.getLog("plugin");
        if (type_ == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Plugin type is null, ignoring plugin");
            }
            return;
        }
        this.type = type_.trim();
        String string = this.version = version_ == null ? "1.0" : version_.trim();
        if (manager == null) {
            return;
        }
        this.propertyName = manager.getName();
        this.ME = "PluginInfo-" + this.propertyName;
        if (this.ignorePlugin()) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Plugin type set to 'undef', ignoring plugin");
            }
            return;
        }
        this.propertyKey = manager.createPluginPropertyKey(this.type, this.version);
        String defaultClass = null;
        PropString prop = new PropString(defaultClass);
        String usedPropertyKey = prop.setFromEnv(glob, contextNode, this.propertyKey);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Trying contextNode=" + (contextNode == null ? "null" : contextNode.getRelativeName()) + " propertyKey=" + this.propertyKey);
        }
        if ((rawString = prop.getValue()) == null) {
            if (this.type != null) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Plugin '" + this.toString() + "' not found, giving up.");
                }
                throw new XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, "Plugin '" + this.toString() + "' not found, please check your configuration");
            }
            rawString = manager.getDefaultPluginName(this.type, this.version);
        }
        this.parsePropertyValue(rawString);
    }

    private void parsePropertyValue(String rawString) throws XmlBlasterException {
        if (rawString == null) {
            throw new IllegalArgumentException(this.ME + ".parsePropertyValue(null)");
        }
        this.params = new Properties();
        if (rawString != null) {
            StringTokenizer st = new StringTokenizer(rawString, ",");
            boolean first = true;
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (first) {
                    this.className = tok;
                    first = false;
                    continue;
                }
                int pos = tok.indexOf("=");
                if (pos < 0) {
                    this.log.info(this.ME, "Accepting param " + tok + " without value (missing '=')");
                    ((Hashtable)this.params).put(tok, "");
                }
                ((Hashtable)this.params).put(tok.substring(0, pos), tok.substring(pos + 1));
            }
        } else {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".parsePropertyValue", "Missing plugin configuration for property " + this.propertyKey + ", please check your settings");
        }
    }

    public boolean ignorePlugin() {
        return "undef".equalsIgnoreCase(this.type) || "undef,1.0".equalsIgnoreCase(this.type);
    }

    public String getClassName() {
        return this.className;
    }

    public Properties getParameters() {
        if (this.params == null) {
            this.params = new Properties();
        }
        return this.params;
    }

    private String[] getParameterArr() {
        String[] arr = new String[((Hashtable)this.getParameters()).size() * 2];
        Enumeration e = ((Hashtable)this.params).keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            arr[i++] = key;
            arr[i++] = (String)((Hashtable)this.params).get(key);
        }
        return arr;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTypeVersion() {
        if (this.type == null) {
            return null;
        }
        if (this.version == null) {
            return this.type;
        }
        return this.type + "," + this.version;
    }

    public String dumpPluginParameters() {
        String[] arr = this.getParameterArr();
        StringBuffer buf = new StringBuffer();
        buf.append(this.className);
        if (arr.length > 0) {
            buf.append(',');
        }
        char ch = ',';
        int i = 0;
        while (i < arr.length) {
            buf.append(arr[i]);
            ch = ch == ',' ? (char)'=' : ',';
            if (i != arr.length - 1) {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        return this.propertyKey;
    }
}

