/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.plugin;

import java.net.URLClassLoader;
import java.util.Hashtable;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.classloader.ClassLoaderFactory;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;

public class PluginManagerBase
implements I_PluginManager {
    private static String ME = "PluginManagerBase";
    private Hashtable pluginCache;
    protected final Global glob;
    private final LogChannel log;
    public static final String NO_PLUGIN_TYPE = "undef";

    public PluginManagerBase(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("classloader");
    }

    protected Global getGlobal() {
        return this.glob;
    }

    public I_Plugin getPluginObject(String typeVersion) throws XmlBlasterException {
        String type_;
        String version_;
        if (typeVersion == null) {
            return null;
        }
        int i = typeVersion.indexOf(44);
        if (i == -1) {
            version_ = null;
            type_ = typeVersion;
        } else {
            version_ = typeVersion.substring(i + 1);
            type_ = typeVersion.substring(0, i);
        }
        return this.getPluginObject(type_, version_);
    }

    public I_Plugin getPluginObject(String type, String version) throws XmlBlasterException {
        PluginInfo pluginInfo = new PluginInfo(this.glob, (I_PluginManager)this, type, version);
        return this.getPluginObject(pluginInfo);
    }

    public I_Plugin getPluginObject(PluginInfo pluginInfo) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME + ".getPluginObject()", "Loading plugin " + pluginInfo.toString());
        }
        I_Plugin plug = null;
        if (pluginInfo.ignorePlugin()) {
            return null;
        }
        PluginManagerBase pluginManagerBase = this;
        synchronized (pluginManagerBase) {
            plug = this.glob.getPluginRegistry().getPlugin(pluginInfo.getId());
            if (plug != null) {
                I_Plugin i_Plugin = plug;
                return i_Plugin;
            }
            plug = this.instantiatePluginFirstPhase(pluginInfo, true);
        }
        if (plug == null) {
            return null;
        }
        I_Plugin i_Plugin = plug;
        synchronized (i_Plugin) {
            I_Plugin i_Plugin2 = this.instantiatePluginSecondPhase(plug, pluginInfo);
            return i_Plugin2;
        }
    }

    public I_Plugin getFromPluginCache(String id) {
        if (id == null) {
            return null;
        }
        return this.glob.getPluginRegistry().getPlugin(id);
    }

    public I_Plugin removeFromPluginCache(String id) {
        if (id == null) {
            return null;
        }
        return this.glob.getPluginRegistry().unRegister(id);
    }

    protected void postInstantiate(I_Plugin plugin, PluginInfo pluginInfo) throws XmlBlasterException {
    }

    public String getDefaultPluginName(String type, String version) {
        return null;
    }

    public I_Plugin getDummyPlugin() throws XmlBlasterException {
        return this.getPluginObject(null, null);
    }

    protected String getPluginPropertyName() {
        return null;
    }

    public String getName() {
        return this.getPluginPropertyName();
    }

    public final String createPluginPropertyKey(String type, String version) {
        StringBuffer buf = new StringBuffer(80);
        buf.append(this.getPluginPropertyName());
        if (type != null) {
            buf.append("[").append(type).append("]");
        }
        if (version != null) {
            buf.append("[").append(version).append("]");
        }
        return buf.toString();
    }

    protected I_Plugin instantiatePlugin(PluginInfo pluginInfo) throws XmlBlasterException {
        return this.instantiatePlugin(pluginInfo, false);
    }

    protected I_Plugin instantiatePlugin(PluginInfo pluginInfo, boolean usePluginCache) throws XmlBlasterException {
        I_Plugin plugin = this.instantiatePluginFirstPhase(pluginInfo, usePluginCache);
        if (plugin != null) {
            return this.instantiatePluginSecondPhase(plugin, pluginInfo);
        }
        return null;
    }

    private I_Plugin instantiatePluginFirstPhase(PluginInfo pluginInfo, boolean usePluginCache) throws XmlBlasterException {
        if (pluginInfo.ignorePlugin()) {
            return null;
        }
        I_Plugin plugin = null;
        String pluginName = pluginInfo.getClassName();
        if (pluginName == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, ME, "The plugin class name is null, please check the property setting of '" + pluginInfo.toString() + "'");
        }
        try {
            ClassLoaderFactory factory = this.glob.getClassLoaderFactory();
            if (factory != null) {
                if (this.log.TRACE) {
                    this.log.trace(ME, "useXmlBlasterClassloader=true: Trying Class.forName('" + pluginName + "') ...");
                }
                URLClassLoader myLoader = factory.getPluginClassLoader(pluginInfo);
                if (this.log.TRACE) {
                    this.log.trace(ME, "Found " + myLoader.getURLs().length + " plugin specific jar files for '" + pluginName + "' preferenced by xmlBlaster classLoader");
                }
                plugin = (I_Plugin)myLoader.loadClass(pluginName).newInstance();
                if (this.log.TRACE) {
                    this.log.trace(ME, "Found I_Plugin '" + pluginName + "', loaded by PluginClassLoader");
                }
            } else {
                Class<?> cl = Class.forName(pluginName);
                plugin = (I_Plugin)cl.newInstance();
            }
            if (usePluginCache) {
                this.glob.getPluginRegistry().register(pluginInfo.getId(), plugin);
            }
            return plugin;
        }
        catch (XmlBlasterException e) {
            if (this.log.TRACE) {
                this.log.trace(ME, "instantiatePlugin for() '" + pluginName + "' failed: " + e.getMessage());
            }
            throw e;
        }
        catch (IllegalAccessException e) {
            this.log.error(ME, "The plugin class '" + pluginName + "' is not accessible\n -> check the plugin name and/or the CLASSPATH to the plugin: " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, ME + ".NoClass", "The Plugin class '" + pluginName + "' is not accessible\n -> check the plugin name and/or the CLASSPATH to the plugin", e);
        }
        catch (SecurityException e) {
            this.log.error(ME, "No right to access the plugin class or initializer '" + pluginName + "': " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, ME + ".NoAccess", "No right to access the plugin class or initializer '" + pluginName + "'", e);
        }
        catch (InstantiationException e) {
            String text = "The plugin class or initializer '" + pluginName + "' is invalid, check if the plugin has a default constructor";
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, ME + ".Invalid", text, e);
        }
        catch (Throwable e) {
            String text = "The plugin class or initializer '" + pluginName + "' is invalid, check the plugin name, check if the plugin has a default constructor and check the CLASSPATH to the plugin";
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, ME + ".Invalid", text, e);
        }
    }

    private I_Plugin instantiatePluginSecondPhase(I_Plugin plugin, PluginInfo pluginInfo) throws XmlBlasterException {
        try {
            plugin.init(this.glob, pluginInfo);
            this.postInstantiate(plugin, pluginInfo);
            if (this.log.TRACE) {
                this.log.trace(ME, "Plugin '" + pluginInfo.getId() + " successfully initialized.");
            }
        }
        catch (XmlBlasterException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, ME + ".NoInit", "Initializing of plugin " + plugin.getType() + " failed:" + e.getMessage());
        }
        return plugin;
    }

    public static final boolean ignorePlugin(String typeVersion) {
        return NO_PLUGIN_TYPE.equalsIgnoreCase(typeVersion.trim()) || "undef,1.0".equalsIgnoreCase(typeVersion.trim());
    }

    public void shutdown() {
        if (this.pluginCache != null) {
            this.pluginCache.clear();
        }
    }
}

