/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.plugin;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jutils.log.LogChannel;
import org.xmlBlaster.protocol.I_Driver;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.queue.I_Queue;

public class PluginRegistry {
    private static String ME = "PluginRegistry";
    private final Global glob;
    private final LogChannel log;
    private Hashtable plugins;

    public PluginRegistry(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("core");
        this.plugins = new Hashtable();
    }

    public I_Plugin getPlugin(String id) {
        if (id == null) {
            return null;
        }
        PluginRegistry pluginRegistry = this;
        synchronized (pluginRegistry) {
            I_Plugin i_Plugin = (I_Plugin)this.plugins.get(id);
            return i_Plugin;
        }
    }

    public boolean register(String id, I_Plugin plugin) {
        if (id == null) {
            return false;
        }
        PluginRegistry pluginRegistry = this;
        synchronized (pluginRegistry) {
            if (this.plugins.containsKey(id)) {
                boolean bl = false;
                return bl;
            }
            this.plugins.put(id, plugin);
            boolean bl = false;
            return bl;
        }
    }

    public I_Plugin unRegister(String id) {
        if (id == null) {
            return null;
        }
        PluginRegistry pluginRegistry = this;
        synchronized (pluginRegistry) {
            I_Plugin i_Plugin = (I_Plugin)this.plugins.remove(id);
            return i_Plugin;
        }
    }

    public Vector getPluginsOfInterfaceI_Driver() {
        if (this.log.CALL) {
            this.log.call(ME, "getPluginsOfInterfaceI_Driver()");
        }
        Vector ret = new Vector();
        PluginRegistry pluginRegistry = this;
        synchronized (pluginRegistry) {
            Enumeration enumer = this.plugins.elements();
            while (enumer.hasMoreElements()) {
                Object next = enumer.nextElement();
                if (!(next instanceof I_Driver)) continue;
                if (this.log.TRACE) {
                    this.log.trace(ME, "Added I_Driver implementation " + next.getClass().getName());
                }
                ret.add(next);
            }
        }
        return ret;
    }

    public Vector getPluginsOfInterfaceI_Queue() {
        if (this.log.CALL) {
            this.log.call(ME, "getPluginsOfInterfaceI_Queue()");
        }
        Vector ret = new Vector();
        PluginRegistry pluginRegistry = this;
        synchronized (pluginRegistry) {
            Enumeration enumer = this.plugins.elements();
            while (enumer.hasMoreElements()) {
                Object next = enumer.nextElement();
                if (!(next instanceof I_Queue)) continue;
                if (this.log.TRACE) {
                    this.log.trace(ME, "Added I_Queue implementation " + next.getClass().getName());
                }
                ret.add(next);
            }
        }
        return ret;
    }
}

