/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.pool;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.xmlBlaster.util.Timeout;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.pool.I_PoolManager;
import org.xmlBlaster.util.pool.ResourceWrapper;

public final class PoolManager {
    private String ME = "PoolManager";
    private String poolName = "Resource";
    private I_PoolManager callback = null;
    private Hashtable busy = null;
    private Vector idle = null;
    private int maxInstances = 100;
    private long busyToIdleTimeout = 0L;
    private long idleToEraseTimeout = 0L;
    private long counter = 1L;
    public static final String USE_HASH_CODE = "h";
    public static final String USE_OBJECT_REF = "o";
    public static final String GENERATE_RANDOM = "r";
    private Timeout transitionTimer;
    private final Object meetingPoint = new Object();

    public PoolManager(String poolName, I_PoolManager callback, int maxInstances, long busyToIdleTimeout, long idleToEraseTimeout) {
        this.poolName = poolName;
        this.callback = callback;
        this.ME = poolName + "-PoolManager";
        this.setMaxInstances(maxInstances);
        this.setBusyToIdleTimeout(busyToIdleTimeout);
        this.setIdleToEraseTimeout(idleToEraseTimeout);
        this.busy = new Hashtable(maxInstances);
        this.idle = new Vector(maxInstances);
    }

    public Timeout getTransistionTimer() {
        if (this.transitionTimer == null) {
            PoolManager poolManager = this;
            synchronized (poolManager) {
                if (this.transitionTimer == null) {
                    this.transitionTimer = new Timeout("XmlBlaster.PoolManagerTimer");
                }
            }
        }
        return this.transitionTimer;
    }

    private void setMaxInstances(int maxInstances) {
        this.maxInstances = maxInstances;
    }

    private void setBusyToIdleTimeout(long busyToIdleTimeout) {
        this.busyToIdleTimeout = busyToIdleTimeout > 0L && busyToIdleTimeout < 100L ? 100L : busyToIdleTimeout;
    }

    private void setIdleToEraseTimeout(long idleToEraseTimeout) {
        this.idleToEraseTimeout = idleToEraseTimeout > 0L && idleToEraseTimeout < 100L ? 100L : idleToEraseTimeout;
    }

    public ResourceWrapper reserve() throws XmlBlasterException {
        return this.reserve(this.busyToIdleTimeout, this.idleToEraseTimeout, GENERATE_RANDOM);
    }

    public ResourceWrapper reserve(String instanceId) throws XmlBlasterException {
        return this.reserve(this.busyToIdleTimeout, this.idleToEraseTimeout, instanceId);
    }

    public ResourceWrapper reserve(long localBusyToIdleTimeout, long localIdleToEraseTimeout, String instanceId) throws XmlBlasterException {
        Object object = this.meetingPoint;
        synchronized (object) {
            ResourceWrapper rw = null;
            if (instanceId != null && instanceId.length() > 1 && (rw = this.findBusySilent(instanceId)) != null) {
                ResourceWrapper resourceWrapper = rw;
                return resourceWrapper;
            }
            if (this.idle.size() > 0) {
                rw = (ResourceWrapper)this.idle.lastElement();
                rw.init(this.createId(instanceId), rw.getResource(), localBusyToIdleTimeout, localIdleToEraseTimeout);
                this.swap(rw, true);
            } else {
                if (this.busy.size() >= this.maxInstances) {
                    XmlBlasterException e = new XmlBlasterException("ResourceExhaust", "Sorry, " + this.maxInstances + " resources consumed, no more resources available");
                    e.changeErrorCode(ErrorCode.RESOURCE_EXHAUST);
                    throw e;
                }
                instanceId = this.createId(instanceId);
                Object resource = this.callback.toCreate(instanceId);
                rw = new ResourceWrapper(this, instanceId, resource, localBusyToIdleTimeout, this.idleToEraseTimeout);
                rw.toBusy();
                this.busy.put(rw.getInstanceId(), rw);
            }
            ResourceWrapper resourceWrapper = rw;
            return resourceWrapper;
        }
    }

    public void release(String instanceId) throws XmlBlasterException {
        Object object = this.meetingPoint;
        synchronized (object) {
            this.swap(this.findLow(instanceId), false);
        }
    }

    private String createId(String instanceId) throws XmlBlasterException {
        if (instanceId == null || !instanceId.equals(GENERATE_RANDOM)) {
            return instanceId;
        }
        try {
            String ip;
            try {
                InetAddress addr = InetAddress.getLocalHost();
                ip = addr.getHostAddress();
            }
            catch (Exception e) {
                ip = "localhost";
            }
            Random ran = new Random();
            return ip + "-" + this.poolName + "-" + System.currentTimeMillis() + "-" + ran.nextInt() + "-" + this.counter++;
        }
        catch (Exception e) {
            String text = "Can't generate a unique instanceId: " + e.toString();
            throw new XmlBlasterException("ResourceNoId", text);
        }
    }

    private void swap(ResourceWrapper rw, boolean toBusy) {
        if (rw == null) {
            System.err.println("##########INTERNAL PROBLEM IN PollManager");
            return;
        }
        if (toBusy) {
            this.idle.removeElementAt(this.idle.size() - 1);
            this.busy.put(rw.getInstanceId(), rw);
            rw.toBusy();
            this.callback.idleToBusy(rw.getResource());
        } else {
            this.busy.remove(rw.getInstanceId());
            this.idle.addElement(rw);
            rw.toIdle();
            this.callback.busyToIdle(rw.getResource());
        }
    }

    private ResourceWrapper findBusySilent(String instanceId) {
        if (instanceId == null) {
            return null;
        }
        return (ResourceWrapper)this.busy.get(instanceId);
    }

    private ResourceWrapper findIdleSilent(String instanceId) {
        if (instanceId == null) {
            return null;
        }
        int ii = 0;
        while (ii < this.idle.size()) {
            ResourceWrapper rw = (ResourceWrapper)this.idle.elementAt(ii);
            if (rw.getInstanceId().equals(instanceId)) {
                return rw;
            }
            ++ii;
        }
        return null;
    }

    private ResourceWrapper findLow(String instanceId) throws XmlBlasterException {
        if (instanceId == null) {
            String text = "Your resource ID is null";
            throw new XmlBlasterException("ResourceNotFound", text);
        }
        ResourceWrapper rw = this.findBusySilent(instanceId);
        if (rw == null) {
            String text = "Resource '" + instanceId + "' is invalid, timed out?";
            throw new XmlBlasterException("ResourceNotFound", text);
        }
        return rw;
    }

    public boolean isBusy(String instanceId) {
        ResourceWrapper rw = this.findBusySilent(instanceId);
        return rw != null;
    }

    public void busyRefresh(String instanceId) throws XmlBlasterException {
        Object object = this.meetingPoint;
        synchronized (object) {
            ResourceWrapper rw = this.findLow(instanceId);
            rw.touchBusy();
        }
    }

    public int getNumBusy() {
        return this.busy.size();
    }

    public int getNumIdle() {
        return this.idle.size();
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public String getState() {
        return "Overview for '" + this.ME + "':" + " BUSY=" + this.busy.size() + " IDLE=" + this.idle.size() + " MAX_AVAILABLE=" + (this.maxInstances - this.busy.size());
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer buf = new StringBuffer();
        String offset = "\n";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        Object object = this.meetingPoint;
        synchronized (object) {
            buf.append(offset).append("<").append(this.ME).append(" maxInstances='").append(this.maxInstances);
            buf.append("' busyToIdleTimeout='").append(this.busyToIdleTimeout);
            buf.append("' idleToEraseTimeout='").append(this.idleToEraseTimeout).append("'>");
            buf.append(offset).append("   <busy num='").append(this.busy.size()).append("'>");
            Enumeration e = this.busy.elements();
            while (e.hasMoreElements()) {
                ResourceWrapper rw = (ResourceWrapper)e.nextElement();
                buf.append(rw.toXml(extraOffset + "   "));
            }
            buf.append(offset).append("   </busy>");
            buf.append(offset).append("   <idle num='").append(this.idle.size()).append("'>");
            int ii = 0;
            while (ii < this.idle.size()) {
                ResourceWrapper rw = (ResourceWrapper)this.idle.elementAt(ii);
                buf.append(rw.toXml(extraOffset + "   "));
                ++ii;
            }
            buf.append(offset).append("   </idle>");
            buf.append(offset).append("</" + this.ME + ">");
        }
        return buf.toString();
    }

    void timeoutBusyToIdle(ResourceWrapper rw) {
        Object object = this.meetingPoint;
        synchronized (object) {
            this.swap(rw, false);
        }
    }

    void timeoutIdleToErase(ResourceWrapper rw) {
        this.erase(rw);
    }

    public void erase(String instanceId) {
        if (instanceId == null || instanceId.length() < 1) {
            return;
        }
        Object object = this.meetingPoint;
        synchronized (object) {
            ResourceWrapper rw = this.findBusySilent(instanceId);
            if (rw == null) {
                rw = this.findIdleSilent(instanceId);
            }
            this.erase(rw);
        }
    }

    private void erase(ResourceWrapper rw) {
        if (rw == null) {
            return;
        }
        Object object = this.meetingPoint;
        synchronized (object) {
            if (this.busy.get(rw.getInstanceId()) != null) {
                this.swap(rw, false);
            }
            this.idle.remove(rw);
            this.callback.toErased(rw.getResource());
            rw.destroy();
        }
    }

    public void destroy() {
        Object object = this.meetingPoint;
        synchronized (object) {
            Enumeration e = this.busy.elements();
            while (e.hasMoreElements()) {
                this.erase((ResourceWrapper)e.nextElement());
            }
            this.busy.clear();
            int ii = 0;
            while (ii < this.idle.size()) {
                ResourceWrapper rw = (ResourceWrapper)this.idle.elementAt(ii);
                this.callback.toErased(rw.getResource());
                rw.destroy();
                ++ii;
            }
            this.idle.removeAllElements();
        }
    }
}

