/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.pool;

import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.pool.PoolManager;

public class ResourceWrapper
implements I_Timeout {
    private String ME = "ResourceWrapper";
    private String instanceId;
    private Object resource;
    private long creationTime;
    private static final String BUSY_TO_IDLE_TIMEOUT = "BI";
    private static final String IDLE_TO_ERASE_TIMEOUT = "IE";
    private long busyToIdleTimeout;
    private Timestamp busyToIdleTimeoutHandle;
    private final Object BUSYTOIDLETIMEOUT_MONITOR = new Object();
    private long idleToEraseTimeout;
    private Timestamp idleToEraseTimeoutHandle;
    private PoolManager poolManager;

    ResourceWrapper(PoolManager poolManager, String instanceId, Object resource, long busyToIdleTimeout, long idleToEraseTimeout) {
        this.poolManager = poolManager;
        this.init(instanceId, resource, busyToIdleTimeout, idleToEraseTimeout);
    }

    ResourceWrapper(PoolManager poolManager) {
        this.poolManager = poolManager;
        this.init(null, null, 0L, 0L);
    }

    void init(String instanceId, Object resource, long busyToIdleTimeout, long idleToEraseTimeout) {
        this.creationTime = System.currentTimeMillis();
        this.instanceId = instanceId;
        this.resource = resource;
        this.setBusyToIdle(busyToIdleTimeout);
        this.setIdleToErase(idleToEraseTimeout);
        if (resource != null) {
            if (this.instanceId == null || this.instanceId.equals("h")) {
                this.instanceId = "" + resource.hashCode();
            } else if (this.instanceId.equals("o")) {
                this.instanceId = "" + resource;
            }
        }
    }

    void toBusy() {
        this.stopIdleToEraseTimeout();
        this.startBusyToIdleTimeout();
    }

    void toIdle() {
        this.stopBusyToIdleTimeout();
        this.startIdleToEraseTimeout();
    }

    private void setBusyToIdle(long val) {
        this.stopBusyToIdleTimeout();
        if (val > 0L && val < 100L) {
            val = 100L;
        }
        this.busyToIdleTimeout = val;
    }

    private void startBusyToIdleTimeout() {
        this.stopBusyToIdleTimeout();
        if (this.busyToIdleTimeout > 0L) {
            this.busyToIdleTimeoutHandle = this.poolManager.getTransistionTimer().addTimeoutListener(this, this.busyToIdleTimeout, BUSY_TO_IDLE_TIMEOUT);
        }
    }

    private void stopBusyToIdleTimeout() {
        if (this.busyToIdleTimeoutHandle != null) {
            this.poolManager.getTransistionTimer().removeTimeoutListener(this.busyToIdleTimeoutHandle);
            this.busyToIdleTimeoutHandle = null;
        }
    }

    private void setIdleToErase(long val) {
        this.stopIdleToEraseTimeout();
        if (val > 0L && val < 100L) {
            val = 100L;
        }
        this.idleToEraseTimeout = val;
    }

    private void startIdleToEraseTimeout() {
        this.stopIdleToEraseTimeout();
        if (this.idleToEraseTimeout > 0L) {
            this.idleToEraseTimeoutHandle = this.poolManager.getTransistionTimer().addTimeoutListener(this, this.idleToEraseTimeout, IDLE_TO_ERASE_TIMEOUT);
        }
    }

    private void stopIdleToEraseTimeout() {
        if (this.idleToEraseTimeoutHandle != null) {
            this.poolManager.getTransistionTimer().removeTimeoutListener(this.idleToEraseTimeoutHandle);
            this.idleToEraseTimeoutHandle = null;
        }
    }

    public void timeout(Object obj) {
        String type = (String)obj;
        if (type.equals(BUSY_TO_IDLE_TIMEOUT)) {
            this.busyToIdleTimeoutHandle = null;
            this.poolManager.timeoutBusyToIdle(this);
        } else if (type.equals(IDLE_TO_ERASE_TIMEOUT)) {
            this.idleToEraseTimeoutHandle = null;
            this.poolManager.timeoutIdleToErase(this);
        }
    }

    public boolean isBusyExpired() {
        if (this.busyToIdleTimeout <= 0L) {
            return false;
        }
        if (this.busyToIdleTimeoutHandle == null) {
            return false;
        }
        return this.poolManager.getTransistionTimer().isExpired(this.busyToIdleTimeoutHandle);
    }

    public long busyElapsed() {
        if (this.busyToIdleTimeout <= 0L) {
            return -1L;
        }
        return System.currentTimeMillis() - this.creationTime;
    }

    public long spanOfTimeToErase() {
        if (this.idleToEraseTimeout <= 0L) {
            return 0L;
        }
        if (this.idleToEraseTimeoutHandle == null) {
            return 0L;
        }
        return this.poolManager.getTransistionTimer().spanToTimeout(this.idleToEraseTimeoutHandle);
    }

    public long spanOfTimeToIdle() {
        if (this.busyToIdleTimeout <= 0L) {
            return 0L;
        }
        if (this.busyToIdleTimeoutHandle == null) {
            return 0L;
        }
        return this.poolManager.getTransistionTimer().spanToTimeout(this.busyToIdleTimeoutHandle);
    }

    public void touchBusy() {
        if (this.busyToIdleTimeoutHandle == null) {
            return;
        }
        try {
            Object object = this.BUSYTOIDLETIMEOUT_MONITOR;
            synchronized (object) {
                this.busyToIdleTimeoutHandle = this.poolManager.getTransistionTimer().refreshTimeoutListener(this.busyToIdleTimeoutHandle, this.busyToIdleTimeout);
            }
        }
        catch (XmlBlasterException xmlBlasterException) {
            // empty catch block
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Object getResource() {
        return this.resource;
    }

    void setResource(Object resource) {
        this.resource = resource;
        if (resource != null) {
            if (this.instanceId == null || this.instanceId.equals("h")) {
                this.instanceId = "" + resource.hashCode();
            } else if (this.instanceId.equals("o")) {
                this.instanceId = "" + resource;
            }
        }
        System.out.println("AAAAAAAAAAAAAA:" + this.instanceId);
    }

    public long getBusyToIdleTimeout() {
        return this.poolManager.getTransistionTimer().getTimeout(this.busyToIdleTimeoutHandle);
    }

    public long getIdleToEraseTimeout() {
        return this.poolManager.getTransistionTimer().getTimeout(this.idleToEraseTimeoutHandle);
    }

    public void destroy() {
        if (this.busyToIdleTimeoutHandle != null) {
            this.poolManager.getTransistionTimer().removeTimeoutListener(this.busyToIdleTimeoutHandle);
            this.busyToIdleTimeoutHandle = null;
        }
        if (this.idleToEraseTimeoutHandle != null) {
            this.poolManager.getTransistionTimer().removeTimeoutListener(this.idleToEraseTimeoutHandle);
            this.idleToEraseTimeoutHandle = null;
        }
        this.instanceId = null;
        this.resource = null;
        this.poolManager = null;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer();
        String offset = "\n   ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<").append(this.ME).append(" instanceId='").append(this.instanceId);
        sb.append("'>");
        sb.append(offset).append("   <busyToIdle timeout='").append(this.busyToIdleTimeout).append("' handle='").append(this.busyToIdleTimeoutHandle).append("' />");
        sb.append(offset).append("   <idleToErase timeout='").append(this.idleToEraseTimeout).append("' handle='").append(this.idleToEraseTimeoutHandle).append("' />");
        sb.append(offset).append("</").append(this.ME).append("'>");
        return sb.toString();
    }
}

