/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.property;

import java.io.Serializable;
import org.xmlBlaster.util.property.PropEntry;

public final class PropDouble
extends PropEntry
implements Serializable,
Cloneable {
    private double value;

    public PropDouble(double value) {
        super(null);
        this.value = value;
    }

    public PropDouble(String propName, double value) {
        super(propName);
        this.value = value;
    }

    public final String getTypeString() {
        return "double";
    }

    public final String getValueString() {
        return "" + this.value;
    }

    public void setValue(double value) {
        this.value = value;
        this.creationOrigin = 4;
    }

    public void setValue(String value, int creationOrigin) {
        if (value == null) {
            return;
        }
        this.setValue(Double.parseDouble(value), creationOrigin);
    }

    public void setValue(double value, int creationOrigin) {
        this.value = value;
        this.creationOrigin = creationOrigin;
    }

    public double getValue() {
        return this.value;
    }

    public Object clone() {
        return super.clone();
    }

    public static void main(String[] args) {
        PropDouble lifeTime = new PropDouble("lifeTime", 123456.789);
        System.out.println(lifeTime.toXml());
    }
}

