/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.property;

import java.io.Serializable;
import org.jutils.init.Property;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.context.ContextNode;

public abstract class PropEntry
implements Serializable,
Cloneable {
    public static final String SEP = "/";
    public static final int CREATED_BY_DEFAULT = 0;
    public static final int CREATED_BY_JVMENV = 1;
    public static final int CREATED_BY_PROPFILE = 2;
    public static final int CREATED_BY_CMDLINE = 3;
    public static final int CREATED_BY_SETTER = 4;
    protected int creationOrigin;
    protected final String propName;

    public PropEntry(String propName) {
        this.propName = propName;
    }

    public final boolean isModified() {
        return this.creationOrigin != 0;
    }

    public final boolean isDefault() {
        return this.creationOrigin == 0;
    }

    public void setCreationOrigin(int creationOrigin) {
        this.creationOrigin = creationOrigin;
    }

    public abstract String getTypeString();

    public abstract String getValueString();

    public abstract void setValue(String var1, int var2);

    public final String setFromEnv(Global glob, ContextNode contextNode, String propName) {
        String className = null;
        String instanceName = null;
        if (contextNode != null) {
            className = contextNode.getClassName();
            instanceName = contextNode.getInstanceName();
        }
        return this.setFromEnv(glob, glob.getStrippedId(), null, className, instanceName, propName);
    }

    public final String setFromEnv(Global glob, String nodeId, String context, String className, String instanceName, String propName) {
        return this.setFromEnv(glob, nodeId, context, className, instanceName, propName, true);
    }

    public final String setFromEnv(Global glob, String nodeId, String context, String className, String instanceName, String propName, boolean simpleLookup) {
        if (propName == null && (propName = this.propName) == null) {
            throw new IllegalArgumentException("setFromEnv(): Internal problem: Missing property name");
        }
        if (this.creationOrigin == 4) {
            return "";
        }
        Property props = glob.getProperty();
        StringBuffer name = new StringBuffer(100);
        String usedName = name.toString();
        if (simpleLookup) {
            name.append(propName);
            if (props.propertyExists(name.toString())) {
                this.setValue(props.get(name.toString(), this.getValueString()), 2);
                usedName = name.toString();
            }
        }
        if (nodeId != null) {
            name.setLength(0);
            name.append("/node/").append(nodeId);
            name.append(SEP).append(propName);
            if (props.propertyExists(name.toString())) {
                this.setValue(props.get(name.toString(), this.getValueString()), 2);
                usedName = name.toString();
            }
        }
        if (className != null) {
            name.setLength(0);
            name.append(className).append(SEP).append(propName);
            if (props.propertyExists(name.toString())) {
                this.setValue(props.get(name.toString(), this.getValueString()), 2);
                usedName = name.toString();
            }
        }
        if (className != null && instanceName != null) {
            name.setLength(0);
            name.append(className).append(SEP).append(instanceName).append(SEP).append(propName);
            if (props.propertyExists(name.toString())) {
                this.setValue(props.get(name.toString(), this.getValueString()), 2);
                usedName = name.toString();
            }
        }
        if (nodeId != null && className != null && instanceName != null) {
            name.setLength(0);
            name.append("/node/").append(nodeId);
            name.append(SEP).append(className).append(SEP).append(instanceName);
            name.append(SEP).append(propName);
            if (props.propertyExists(name.toString())) {
                this.setValue(props.get(name.toString(), this.getValueString()), 2);
                usedName = name.toString();
            }
        }
        if (nodeId != null && className != null && instanceName != null && context != null) {
            name.setLength(0);
            name.append("/node/").append(nodeId);
            name.append(SEP).append(context);
            name.append(SEP).append(className).append(SEP).append(instanceName);
            name.append(SEP).append(propName);
            if (props.propertyExists(name.toString())) {
                this.setValue(props.get(name.toString(), this.getValueString()), 2);
                usedName = name.toString();
            }
        }
        return usedName;
    }

    public String toXml() {
        return this.toXml("");
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(100);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<property");
        if (this.propName != null) {
            sb.append(" key='").append(this.propName).append("'");
        }
        sb.append(" type='").append(this.getTypeString()).append("'");
        if (this.isModified()) {
            sb.append(" modified='").append(true).append("'");
        }
        sb.append(">");
        String value = this.getValueString();
        if (value != null && value.indexOf("<") > -1) {
            sb.append("<![CDATA[").append(value).append("]]>");
        } else {
            sb.append(value);
        }
        sb.append("</property>");
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

