/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.property;

import java.io.Serializable;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.property.PropEntry;

public final class PropLong
extends PropEntry
implements Serializable,
Cloneable {
    private long valueDefault;
    private long value;

    public PropLong(long value) {
        this(null, value);
    }

    public PropLong(String propName, long value) {
        super(propName);
        this.valueDefault = value;
        this.value = value;
    }

    public final String getTypeString() {
        return "long";
    }

    public final String getValueString() {
        return "" + this.value;
    }

    public void setValue(long value) {
        this.value = value;
        this.creationOrigin = 4;
    }

    public void setValue(String value, int creationOrigin) {
        if (value == null) {
            return;
        }
        this.setValue(Long.parseLong(value), creationOrigin);
    }

    public void setValue(long value, int creationOrigin) {
        if (creationOrigin >= this.creationOrigin) {
            this.value = value;
            this.creationOrigin = creationOrigin;
        } else {
            System.out.println("Old value=" + this.value + " not overwritten with " + value + " as old origin=" + this.creationOrigin + " and new origin=" + creationOrigin + " is weaker");
        }
    }

    public long getValue() {
        return this.value;
    }

    public void setDefaultValue(long value) {
        this.valueDefault = value;
        if (0 == this.creationOrigin) {
            this.value = value;
        }
    }

    public long getDefaultValue() {
        return this.valueDefault;
    }

    public Object clone() {
        return super.clone();
    }

    public static void main(String[] args) {
        PropLong maxEntries = new PropLong(123456L);
        System.out.println(maxEntries.toXml());
        Global glob = new Global(args);
        String nodeId = null;
        String prefix = null;
        String className = null;
        String instanceName = null;
        String propName = "maxEntries";
        try {
            glob.getProperty().set("maxEntries", "444444");
            glob.getProperty().set("persistence/msgUnitStore/maxEntries", "666666");
            glob.getProperty().set("topic/hello/persistence/msgUnitStore/maxEntries", "777777");
            glob.getProperty().set("/node/heron/topic/hello/persistence/msgUnitStore/maxEntries", "999999");
            System.out.println("PropName=" + propName + ", used env name=" + maxEntries.setFromEnv(glob, nodeId, prefix, className, instanceName, propName) + ": " + maxEntries.toXml(""));
            nodeId = "heron";
            prefix = "topic/hello";
            className = "persistence";
            instanceName = "msgUnitStore";
            System.out.println("PropName=" + propName + ", used env name=" + maxEntries.setFromEnv(glob, nodeId, prefix, className, instanceName, propName) + ": " + maxEntries.toXml(""));
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.toString());
        }
    }
}

