/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.protocol;

import java.util.Enumeration;
import java.util.Vector;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;

public class ProtoConverter {
    private static final String ME = "ProtoConverter";

    public static MsgUnitRaw vector2MsgUnitRaw(Vector vec) throws XmlBlasterException {
        MsgUnitRaw ret = null;
        int size = vec.size();
        if (size != 3) {
            throw new XmlBlasterException("Not a valid Message Unit", "Wrong size");
        }
        try {
            Enumeration enumeration = vec.elements();
            String xmlKey = (String)enumeration.nextElement();
            byte[] content = (byte[])enumeration.nextElement();
            String qos = (String)enumeration.nextElement();
            ret = new MsgUnitRaw(xmlKey, content, qos);
        }
        catch (ClassCastException e) {
            throw new XmlBlasterException("Not a valid Message Unit", "Class Cast Exception");
        }
        return ret;
    }

    public static Vector messageUnit2Vector(MsgUnitRaw msg) {
        Vector<Object> ret = new Vector<Object>();
        ret.addElement(msg.getKey());
        ret.addElement(msg.getContent());
        ret.addElement(msg.getQos());
        return ret;
    }

    public static MsgUnitRaw[] vector2MsgUnitRawArray(Vector vec) throws XmlBlasterException {
        int size = vec.size();
        MsgUnitRaw[] msgUnitArr = new MsgUnitRaw[size];
        try {
            Enumeration enumeration = vec.elements();
            int i = 0;
            while (i < size) {
                msgUnitArr[i] = ProtoConverter.vector2MsgUnitRaw((Vector)enumeration.nextElement());
                ++i;
            }
        }
        catch (ClassCastException e) {
            throw new XmlBlasterException("Not a valid MsgUnitRaw[]", "Class Cast Exception");
        }
        return msgUnitArr;
    }

    public static Vector messageUnitArray2Vector(MsgUnitRaw[] msgs) {
        int size = msgs.length;
        Vector<Vector> ret = new Vector<Vector>();
        int i = 0;
        while (i < size) {
            ret.addElement(ProtoConverter.messageUnit2Vector(msgs[i]));
            ++i;
        }
        return ret;
    }

    public static String[] vector2StringArray(Vector vec) throws XmlBlasterException {
        int size = vec.size();
        String[] ret = new String[size];
        try {
            Enumeration enumeration = vec.elements();
            int i = 0;
            while (i < size) {
                ret[i] = (String)enumeration.nextElement();
                ++i;
            }
        }
        catch (ClassCastException e) {
            throw new XmlBlasterException("Not a valid String", "Class Cast Exception");
        }
        return ret;
    }

    public static String vector2String(Vector vec) throws XmlBlasterException {
        int size = vec.size();
        if (size == 0) {
            throw new XmlBlasterException("ProtoConvertervector2String", "There is no string in the vector");
        }
        if (size > 1) {
            Global.instance().getLog("core").error("ProtoConvertor.vector2String", "There are too many strings in the vector");
        }
        try {
            return (String)vec.elementAt(0);
        }
        catch (ClassCastException e) {
            throw new XmlBlasterException("ProtoConverter.vector2String", "Class Cast Exception, not a valid String");
        }
    }

    public static Vector stringArray2Vector(String[] strings) {
        int size = strings.length;
        Vector<String> ret = new Vector<String>();
        int i = 0;
        while (i < size) {
            ret.addElement(strings[i]);
            ++i;
        }
        return ret;
    }

    public static void main(String[] args) {
        byte[] content = new byte[100];
        MsgUnitRaw[] msgs = new MsgUnitRaw[5];
        String[] strings = new String[5];
        System.out.println("The Original Messages & strings: \n\n");
        try {
            int i = 0;
            while (i < 5) {
                msgs[i] = new MsgUnitRaw("<key uid='" + i + "'></key>", content, "<qos></qos>");
                strings[i] = new String("string nr. " + (i + 1));
                System.out.println(msgs[i].getKey() + " " + strings[i]);
                ++i;
            }
            Vector vec = ProtoConverter.messageUnitArray2Vector(msgs);
            Vector strVector = ProtoConverter.stringArray2Vector(strings);
            MsgUnitRaw[] msgs2 = ProtoConverter.vector2MsgUnitRawArray(vec);
            String[] strings2 = ProtoConverter.vector2StringArray(strVector);
            System.out.println("\n\nReconverted Messages: ");
            int i2 = 0;
            while (i2 < msgs2.length) {
                System.out.println(msgs2[i2].getKey() + " " + strings2[i2]);
                ++i2;
            }
        }
        catch (XmlBlasterException ex) {
            System.err.println("Exception: " + ex.toString());
        }
    }
}

