/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import org.xmlBlaster.authentication.plugins.I_ClientPlugin;
import org.xmlBlaster.authentication.plugins.I_SecurityQos;
import org.xmlBlaster.client.PluginLoader;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.property.PropBoolean;
import org.xmlBlaster.util.qos.I_ConnectQosFactory;
import org.xmlBlaster.util.qos.QosData;
import org.xmlBlaster.util.qos.SessionQos;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.qos.address.ServerRef;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.qos.storage.ClientQueueProperty;

public final class ConnectQosData
extends QosData
implements Serializable,
Cloneable {
    private final String ME = "ConnectQosData";
    protected transient I_ConnectQosFactory factory;
    private ConnectionStateEnum initialConnectionState = ConnectionStateEnum.UNDEF;
    protected PropBoolean ptpAllowed = new PropBoolean(true);
    protected PropBoolean clusterNode = new PropBoolean(false);
    protected PropBoolean duplicateUpdates = new PropBoolean(true);
    protected PropBoolean reconnected = new PropBoolean(false);
    private SessionQos sessionQos;
    protected transient PluginLoader pMgr;
    protected I_ClientPlugin clientPlugin;
    protected I_SecurityQos securityQos;
    protected transient ServerRef[] serverRefArr;
    protected Vector serverRefVec = new Vector();
    private transient CbQueueProperty subjectQueueProperty;
    private transient CbQueueProperty sessionCbQueueProperty;
    protected transient ArrayList clientQueuePropertyList = new ArrayList();
    private NodeId nodeId;

    public ConnectQosData(Global glob) {
        this(glob, null, null, null);
        this.initialize(glob);
    }

    public ConnectQosData(Global glob, I_ConnectQosFactory factory, String serialData, NodeId nodeId) {
        super(glob, serialData, MethodName.CONNECT);
        this.factory = factory == null ? this.glob.getConnectQosFactory() : factory;
        this.nodeId = nodeId == null ? new NodeId(this.glob.getStrippedId()) : nodeId;
        this.sessionQos = new SessionQos(this.glob);
    }

    public ConnectQosData(Global glob, NodeId nodeId) {
        this(glob, null, null, nodeId);
        this.initialize(glob);
    }

    private void initialize(Global glob) {
        this.securityQos = this.getClientPlugin().createSecurityQos();
        this.securityQos.setCredential(this.accessPassword(null));
        if (this.sessionQos.getSessionName() != null) {
            this.securityQos.setUserId(this.sessionQos.getSessionName().getLoginName());
        }
    }

    public CbQueueProperty getSubjectQueueProperty() {
        if (this.subjectQueueProperty == null) {
            this.subjectQueueProperty = new CbQueueProperty(this.glob, "subject", this.nodeId.toString());
        }
        return this.subjectQueueProperty;
    }

    public void setSubjectQueueProperty(CbQueueProperty subjectQueueProperty) {
        this.subjectQueueProperty = subjectQueueProperty;
    }

    public boolean hasSubjectQueueProperty() {
        return this.subjectQueueProperty != null;
    }

    public CbQueueProperty getSessionCbQueueProperty() {
        if (this.sessionCbQueueProperty == null) {
            this.sessionCbQueueProperty = new CbQueueProperty(this.glob, "callback", this.nodeId.toString());
        }
        return this.sessionCbQueueProperty;
    }

    public void setSessionCbQueueProperty(CbQueueProperty sessionCbQueueProperty) {
        this.sessionCbQueueProperty = sessionCbQueueProperty;
    }

    public boolean hasSessionCbQueueProperty() {
        return this.sessionCbQueueProperty != null;
    }

    void setSecurityQos(I_SecurityQos securityQos) {
        this.securityQos = securityQos;
        if (!this.sessionQos.isSessionNameModified()) {
            SessionName sessionName = new SessionName(this.glob, this.securityQos.getUserId());
            this.sessionQos.setSessionName(sessionName, false);
        }
    }

    public I_ClientPlugin loadClientPlugin(String type, String version, String userId, String credential) throws XmlBlasterException {
        I_ClientPlugin c = this.getClientPlugin(type, version);
        this.securityQos = c.createSecurityQos();
        this.setUserId(userId);
        this.securityQos.setCredential(this.accessPassword(credential));
        return c;
    }

    public void setUserId(String userId) throws XmlBlasterException {
        if (this.securityQos == null) {
            this.securityQos = this.getClientPlugin().createSecurityQos();
            this.securityQos.setCredential(this.accessPassword(null));
        }
        SessionName sessionName = new SessionName(this.glob, userId);
        this.securityQos.setUserId(sessionName.getLoginName());
        if (!this.sessionQos.isSessionNameModified()) {
            this.sessionQos.setSessionName(sessionName, false);
        }
    }

    protected I_ClientPlugin getClientPlugin(String type, String version) {
        if (this.clientPlugin == null || !this.clientPlugin.getType().equals(type) || !this.clientPlugin.getVersion().equals(version)) {
            if (this.pMgr == null) {
                this.pMgr = this.glob.getClientSecurityPluginLoader();
            }
            try {
                this.clientPlugin = type != null ? this.pMgr.getClientPlugin(type, version) : this.pMgr.getCurrentClientPlugin();
            }
            catch (XmlBlasterException e) {
                this.log.error("ConnectQosData.ConnectQosData", "Security plugin initialization failed. Reason: " + e.toString());
                this.log.error("ConnectQosData.ConnectQosData", "No plugin. Trying to continue without the plugin.");
            }
        }
        return this.clientPlugin;
    }

    private I_ClientPlugin getClientPlugin() {
        if (this.clientPlugin == null) {
            this.getClientPlugin(null, null);
        }
        return this.clientPlugin;
    }

    private String accessPassword(String passwd) {
        if (passwd != null) {
            return passwd;
        }
        passwd = this.glob.getProperty().get("passwd", "secret");
        if (this.nodeId != null) {
            passwd = this.glob.getProperty().get("passwd[" + this.nodeId + "]", passwd);
        }
        if (this.log.TRACE) {
            this.log.trace("ConnectQosData", "Initializing passwd=" + passwd + " nodeId=" + this.nodeId);
        }
        return passwd;
    }

    public SessionQos getSessionQos() {
        return this.sessionQos;
    }

    public SessionName getSessionName() {
        if (this.sessionQos.getSessionName() == null && this.getSecurityQos() != null) {
            this.sessionQos.setSessionName(new SessionName(this.glob, this.getSecurityQos().getUserId()), false);
        }
        return this.sessionQos.getSessionName();
    }

    public ServerRef[] getServerRefs() {
        if (this.serverRefArr == null) {
            this.serverRefArr = new ServerRef[this.serverRefVec.size()];
            int ii = 0;
            while (ii < this.serverRefArr.length) {
                this.serverRefArr[ii] = (ServerRef)this.serverRefVec.elementAt(ii);
                ++ii;
            }
        }
        return this.serverRefArr;
    }

    public ServerRef getServerRef() {
        ServerRef[] arr = this.getServerRefs();
        if (arr.length > 0) {
            return arr[0];
        }
        return null;
    }

    public void addServerRef(ServerRef addr) {
        int n = this.serverRefVec.size();
        int i = 0;
        while (i < n) {
            if (((ServerRef)this.serverRefVec.elementAt(i)).equals(addr)) {
                return;
            }
            ++i;
        }
        this.serverRefVec.addElement(addr);
        this.serverRefArr = null;
    }

    public boolean removeServerRef(ServerRef addr) {
        boolean rem = this.serverRefVec.remove(addr);
        if (rem) {
            this.serverRefArr = null;
        }
        return rem;
    }

    public boolean removeServerRef(String type) {
        ServerRef[] refArr = this.getServerRefs();
        int i = 0;
        while (i < refArr.length) {
            if (refArr[i].getType().equalsIgnoreCase(type)) {
                return this.removeServerRef(refArr[i]);
            }
            ++i;
        }
        return false;
    }

    public void setPtpAllowed(boolean ptpAllowed) {
        this.ptpAllowed.setValue(ptpAllowed);
    }

    public boolean isPtpAllowed() {
        return this.ptpAllowed.getValue();
    }

    public PropBoolean isPtpAllowedProp() {
        return this.ptpAllowed;
    }

    public void setClusterNode(boolean clusterNode) {
        this.clusterNode.setValue(clusterNode);
    }

    public boolean isClusterNode() {
        return this.clusterNode.getValue();
    }

    public PropBoolean getClusterNodeProp() {
        return this.clusterNode;
    }

    public void setDuplicateUpdates(boolean duplicateUpdates) {
        this.duplicateUpdates.setValue(duplicateUpdates);
    }

    public boolean duplicateUpdates() {
        return this.duplicateUpdates.getValue();
    }

    public PropBoolean duplicateUpdatesProp() {
        return this.duplicateUpdates;
    }

    public void setReconnected(boolean reconnected) {
        this.reconnected.setValue(reconnected);
    }

    public boolean isReconnected() {
        return this.reconnected.getValue();
    }

    public PropBoolean getReconnectedProp() {
        return this.reconnected;
    }

    public void setAddress(Address address) {
        ClientQueueProperty prop = new ClientQueueProperty(this.glob, this.nodeId.toString());
        prop.setAddress(address);
        this.addClientQueueProperty(prop);
    }

    public Address getAddress() {
        Address address = this.getClientQueueProperty().getCurrentAddress();
        if (address == null) {
            this.log.error("ConnectQosData", "Internal error, can't access address instance in queue");
            throw new IllegalArgumentException("ConnectQosData: Internal error, can't access address instance in queue");
        }
        return address;
    }

    public AddressBase[] getAddresses() {
        return this.getClientQueueProperty().getAddresses();
    }

    public void addClientQueueProperty(ClientQueueProperty prop) {
        if (prop == null) {
            return;
        }
        this.clientQueuePropertyList.add(prop);
    }

    public ClientQueueProperty getClientQueueProperty() {
        if (this.clientQueuePropertyList.size() < 1) {
            if (this.log.TRACE) {
                this.log.trace("ConnectQosData", "Creating default server address instance");
            }
            this.setAddress(new Address(this.glob));
        }
        if (this.clientQueuePropertyList.size() < 1) {
            this.log.error("ConnectQosData", "Internal error, can't access address instance");
            throw new IllegalArgumentException("ConnectQosData: Internal error, can't access address instance");
        }
        return (ClientQueueProperty)this.clientQueuePropertyList.get(0);
    }

    public ClientQueueProperty[] getClientQueuePropertyArr() {
        if (this.clientQueuePropertyList.size() < 1) {
            this.getClientQueueProperty();
        }
        return this.clientQueuePropertyList.toArray(new ClientQueueProperty[this.clientQueuePropertyList.size()]);
    }

    public void eraseClientQueueProperty() {
        this.clientQueuePropertyList.clear();
    }

    public void addCallbackAddress(CallbackAddress callback) {
        CbQueueProperty prop = this.getSessionCbQueueProperty();
        prop.setCallbackAddress(callback);
    }

    public I_SecurityQos getSecurityQos() {
        return this.securityQos;
    }

    public String getClientPluginType() {
        I_ClientPlugin c = this.getClientPlugin();
        if (c == null) {
            return null;
        }
        return c.getType();
    }

    public String getClientPluginVersion() {
        I_ClientPlugin c = this.getClientPlugin();
        if (c == null) {
            return null;
        }
        return c.getVersion();
    }

    public String getUserId() {
        I_SecurityQos securityQos = this.getSecurityQos();
        if (securityQos == null) {
            return "NoLoginName";
        }
        return securityQos.getUserId();
    }

    public ConnectionStateEnum getInitialConnectionState() {
        return this.initialConnectionState;
    }

    public void setInitialConnectionState(ConnectionStateEnum initialConnectionState) {
        this.initialConnectionState = initialConnectionState;
    }

    public int size() {
        return this.toXml().length();
    }

    public String toString() {
        return this.toXml();
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        return this.factory.writeObject(this, extraOffset);
    }

    public Object clone() {
        this.log.error("ConnectQosData", "clone() is not tested");
        ConnectQosData newOne = null;
        newOne = (ConnectQosData)super.clone();
        ConnectQosData connectQosData = this;
        synchronized (connectQosData) {
            newOne.ptpAllowed = (PropBoolean)this.ptpAllowed.clone();
            newOne.clusterNode = (PropBoolean)this.clusterNode.clone();
            newOne.duplicateUpdates = (PropBoolean)this.duplicateUpdates.clone();
            newOne.reconnected = (PropBoolean)this.reconnected.clone();
            newOne.serverRefVec = this.serverRefVec;
            newOne.nodeId = this.nodeId;
        }
        return newOne;
    }
}

