/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.authentication.plugins.I_SecurityQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.StopParseException;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlQoSBase;
import org.xmlBlaster.util.qos.ConnectQosData;
import org.xmlBlaster.util.qos.I_ConnectQosFactory;
import org.xmlBlaster.util.qos.SessionQos;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.qos.address.ServerRef;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.qos.storage.ClientQueueProperty;

public final class ConnectQosSaxFactory
extends XmlQoSBase
implements I_ConnectQosFactory {
    private String ME = "ConnectQosSaxFactory";
    private final Global glob;
    private final LogChannel log;
    private ConnectQosData connectQosData;
    private boolean inServerRef;
    private boolean inQueue;
    private boolean inSecurityService;
    private boolean inSession;
    private boolean inCallback;
    private boolean inAddress;
    private ServerRef tmpServerRef;
    private CbQueueProperty tmpCbProp;
    private CallbackAddress tmpCbAddr;
    private ClientQueueProperty tmpProp;
    private Address tmpAddr;
    protected String tmpSecurityPluginType;
    protected String tmpSecurityPluginVersion;
    private boolean inIsPersistent = false;

    public ConnectQosSaxFactory(Global glob) {
        super(glob);
        this.glob = glob;
        this.log = glob.getLog("core");
    }

    public synchronized ConnectQosData readObject(String xmlQos) throws XmlBlasterException {
        if (xmlQos == null) {
            xmlQos = "<qos/>";
        }
        this.connectQosData = new ConnectQosData(this.glob, this, xmlQos, null);
        if (!this.isEmpty(xmlQos)) {
            this.init(xmlQos);
        }
        return this.connectQosData;
    }

    public void startElement(String uri, String localName, String name, Attributes attrs) {
        int len;
        if (super.startElementBase(uri, localName, name, attrs)) {
            return;
        }
        if (name.equalsIgnoreCase("serverRef")) {
            this.inServerRef = true;
            String tmp = this.character.toString().trim();
            String type = null;
            if (attrs != null) {
                int len2 = attrs.getLength();
                int i = 0;
                while (i < len2) {
                    if (attrs.getQName(i).equalsIgnoreCase("type")) {
                        type = attrs.getValue(i).trim();
                        break;
                    }
                    ++i;
                }
            }
            if (type == null) {
                this.log.error(this.ME, "Missing 'serverRef' attribute 'type' in login-qos");
                type = "IOR";
            }
            this.tmpServerRef = new ServerRef(type);
            if (tmp.length() > 0) {
                this.tmpServerRef.setAddress(tmp);
                this.character.setLength(0);
            }
            return;
        }
        if (this.inCallback) {
            this.tmpCbAddr.startElement(uri, localName, name, this.character, attrs);
            return;
        }
        if (name.equalsIgnoreCase("callback")) {
            this.inCallback = true;
            if (!this.inQueue) {
                this.tmpCbProp = new CbQueueProperty(this.glob, "callback", null);
                this.connectQosData.setSessionCbQueueProperty(this.tmpCbProp);
            }
            this.tmpCbAddr = new CallbackAddress(this.glob);
            this.tmpCbAddr.startElement(uri, localName, name, this.character, attrs);
            this.tmpCbProp.setCallbackAddress(this.tmpCbAddr);
            return;
        }
        if (name.equalsIgnoreCase("address")) {
            this.inAddress = true;
            if (!this.inQueue) {
                this.tmpProp = new ClientQueueProperty(this.glob, null);
                this.connectQosData.addClientQueueProperty(this.tmpProp);
            }
            this.tmpAddr = new Address(this.glob);
            this.tmpAddr.startElement(uri, localName, name, this.character, attrs);
            this.tmpProp.setAddress(this.tmpAddr);
            return;
        }
        if (name.equalsIgnoreCase("queue")) {
            this.inQueue = true;
            if (this.inCallback) {
                this.log.error(this.ME, "<queue> tag is not allowed inside <callback> tag, element ignored.");
                this.character.setLength(0);
                return;
            }
            if (this.inAddress) {
                this.log.error(this.ME, "<queue> tag is not allowed inside <address> tag, element ignored.");
                this.character.setLength(0);
                return;
            }
            String related = attrs.getValue("relating");
            if ("connection".equalsIgnoreCase(related)) {
                this.tmpProp = new ClientQueueProperty(this.glob, null);
                this.tmpProp.startElement(uri, localName, name, attrs);
                this.connectQosData.addClientQueueProperty(this.tmpProp);
            } else if ("callback".equalsIgnoreCase(related)) {
                this.tmpCbProp = new CbQueueProperty(this.glob, "callback", null);
                this.tmpCbProp.startElement(uri, localName, name, attrs);
                this.connectQosData.setSessionCbQueueProperty(this.tmpCbProp);
            } else if ("subject".equalsIgnoreCase(related)) {
                this.tmpCbProp = new CbQueueProperty(this.glob, "subject", null);
                this.tmpCbProp.startElement(uri, localName, name, attrs);
                this.connectQosData.setSubjectQueueProperty(this.tmpCbProp);
            } else {
                this.log.warn(this.ME, "The given relating='" + related + "' is not supported, configuration for '" + related + "' is ignored");
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("securityService")) {
            this.inSecurityService = true;
            boolean existsTypeAttr = false;
            boolean existsVersionAttr = false;
            if (attrs != null) {
                int len3 = attrs.getLength();
                int ii = 0;
                ii = 0;
                while (ii < len3) {
                    if (attrs.getQName(ii).equalsIgnoreCase("type")) {
                        existsTypeAttr = true;
                        this.tmpSecurityPluginType = attrs.getValue(ii).trim();
                    } else if (attrs.getQName(ii).equalsIgnoreCase("version")) {
                        existsVersionAttr = true;
                        this.tmpSecurityPluginVersion = attrs.getValue(ii).trim();
                    }
                    ++ii;
                }
            }
            if (!existsTypeAttr) {
                this.log.error(this.ME, "Missing 'type' attribute in login-qos <securityService>");
            }
            if (!existsVersionAttr) {
                this.log.error(this.ME, "Missing 'version' attribute in login-qos <securityService>");
            }
            this.character.setLength(0);
        }
        if (name.equalsIgnoreCase("session")) {
            this.inSession = true;
            if (attrs != null) {
                len = attrs.getLength();
                int ii = 0;
                SessionQos sessionQos = this.connectQosData.getSessionQos();
                ii = 0;
                while (ii < len) {
                    if (attrs.getQName(ii).equalsIgnoreCase("name")) {
                        if (this.glob.isServer()) {
                            sessionQos.setSessionName(new SessionName(this.glob, this.glob.getNodeId(), attrs.getValue(ii).trim()));
                        } else {
                            sessionQos.setSessionName(new SessionName(this.glob, attrs.getValue(ii).trim()));
                        }
                    } else if (attrs.getQName(ii).equalsIgnoreCase("timeout")) {
                        sessionQos.setSessionTimeout(new Long(attrs.getValue(ii).trim()));
                    } else if (attrs.getQName(ii).equalsIgnoreCase("maxSessions")) {
                        sessionQos.setMaxSessions(new Integer(attrs.getValue(ii).trim()));
                    } else if (attrs.getQName(ii).equalsIgnoreCase("clearSessions")) {
                        sessionQos.clearSessions(new Boolean(attrs.getValue(ii).trim()));
                    } else if (attrs.getQName(ii).equalsIgnoreCase("reconnectSameClientOnly")) {
                        sessionQos.setReconnectSameClientOnly(new Boolean(attrs.getValue(ii).trim()));
                    } else if (attrs.getQName(ii).equalsIgnoreCase("sessionId")) {
                        sessionQos.setSecretSessionId(attrs.getValue(ii));
                    } else {
                        this.log.warn(this.ME, "Ignoring unknown attribute '" + attrs.getQName(ii) + "' of <session> element");
                    }
                    ++ii;
                }
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("ptp")) {
            this.connectQosData.setPtpAllowed(true);
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("clusterNode")) {
            this.connectQosData.setClusterNode(true);
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("duplicateUpdates")) {
            this.connectQosData.setDuplicateUpdates(true);
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("reconnected")) {
            this.connectQosData.setReconnected(true);
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("persistent")) {
            if (!this.inQos) {
                return;
            }
            this.inIsPersistent = true;
            this.character.setLength(0);
            this.connectQosData.setPersistent(true);
            return;
        }
        if (this.inSecurityService) {
            this.character.append("<").append(name);
            if (attrs != null) {
                len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.character.append(" ").append(attrs.getQName(i)).append("=\"").append(attrs.getValue(i)).append("\"");
                    ++i;
                }
            }
            this.character.append(">");
            if (name.equalsIgnoreCase("securityService")) {
                this.character.append("<![CDATA[");
            }
        }
    }

    public void endElement(String uri, String localName, String name) {
        String tmp;
        if (super.endElementBase(uri, localName, name)) {
            if (name.equalsIgnoreCase("clientProperty")) {
                this.connectQosData.addClientProperty(this.clientProperty);
            }
            return;
        }
        if (name.equalsIgnoreCase("serverRef")) {
            this.inServerRef = false;
            String tmp2 = this.character.toString().trim();
            if (this.tmpServerRef != null) {
                if (tmp2.length() > 0) {
                    this.tmpServerRef.setAddress(tmp2);
                }
                this.connectQosData.addServerRef(this.tmpServerRef);
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("queue")) {
            this.inQueue = false;
            this.character.setLength(0);
            return;
        }
        if (this.inCallback) {
            if (name.equalsIgnoreCase("callback")) {
                this.inCallback = false;
            }
            this.tmpCbAddr.endElement(uri, localName, name, this.character);
            return;
        }
        if (this.inAddress) {
            if (name.equalsIgnoreCase("address")) {
                this.inAddress = false;
            }
            this.tmpAddr.endElement(uri, localName, name, this.character);
            return;
        }
        if (name.equalsIgnoreCase("ptp")) {
            String tmp3 = this.character.toString().trim();
            if (tmp3.length() > 0) {
                this.connectQosData.setPtpAllowed(new Boolean(tmp3));
            }
            return;
        }
        if (name.equalsIgnoreCase("clusterNode")) {
            String tmp4 = this.character.toString().trim();
            if (tmp4.length() > 0) {
                this.connectQosData.setClusterNode(new Boolean(tmp4));
            }
            return;
        }
        if (name.equalsIgnoreCase("duplicateUpdates")) {
            String tmp5 = this.character.toString().trim();
            if (tmp5.length() > 0) {
                this.connectQosData.setDuplicateUpdates(new Boolean(tmp5));
            }
            return;
        }
        if (name.equalsIgnoreCase("reconnected")) {
            String tmp6 = this.character.toString().trim();
            if (tmp6.length() > 0) {
                this.connectQosData.setReconnected(new Boolean(tmp6));
            }
            return;
        }
        if (name.equalsIgnoreCase("securityService")) {
            this.inSecurityService = false;
            this.character.append("]]>\n");
            this.character.append("</").append(name).append(">");
            tmp = this.character.toString().trim();
            try {
                I_SecurityQos securityQos = this.connectQosData.getClientPlugin(this.tmpSecurityPluginType, this.tmpSecurityPluginVersion).createSecurityQos();
                securityQos.parse(tmp);
                this.connectQosData.setSecurityQos(securityQos);
            }
            catch (XmlBlasterException e) {
                this.log.warn(this.ME, "Can't parse security string - " + e.toString() + "\n Check:\n" + tmp);
                throw new StopParseException();
            }
        }
        if (name.equalsIgnoreCase("persistent")) {
            this.inIsPersistent = false;
            tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.connectQosData.setPersistent(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("session")) {
            this.inSession = false;
        }
        if (this.inSecurityService) {
            this.character.append("</" + name + ">");
        }
    }

    public String writeObject(ConnectQosData connectQosData, String extraOffset) {
        return ConnectQosSaxFactory.toXml(connectQosData, extraOffset);
    }

    public static final String toXml(ConnectQosData data, String extraOffset) {
        StringBuffer sb = new StringBuffer(2000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<qos>");
        if (data.getSecurityQos() != null) {
            sb.append(data.getSecurityQos().toXml(extraOffset + " "));
        }
        if (data.isPtpAllowedProp().isModified()) {
            if (data.isPtpAllowed()) {
                sb.append(offset).append(" <ptp/>");
            } else {
                sb.append(offset).append(" <ptp>false</ptp>");
            }
        }
        if (data.getClusterNodeProp().isModified()) {
            if (data.isClusterNode()) {
                sb.append(offset).append(" <clusterNode/>");
            } else {
                sb.append(offset).append(" <clusterNode>false</clusterNode>");
            }
        }
        if (data.duplicateUpdatesProp().isModified()) {
            if (data.duplicateUpdates()) {
                sb.append(offset).append(" <duplicateUpdates/>");
            } else {
                sb.append(offset).append(" <duplicateUpdates>false</duplicateUpdates>");
            }
        }
        if (data.getReconnectedProp().isModified()) {
            if (data.isReconnected()) {
                sb.append(offset).append(" <reconnected/>");
            } else {
                sb.append(offset).append(" <reconnected>false</reconnected>");
            }
        }
        if (data.getPersistentProp().isModified()) {
            if (data.isPersistent()) {
                sb.append(offset).append(" <persistent/>");
            } else {
                sb.append(offset).append(" <persistent>false</persistent>");
            }
        }
        sb.append(data.getSessionQos().toXml(extraOffset + " "));
        Object[] arr = data.getClientQueuePropertyArr();
        int ii = 0;
        while (arr != null && ii < arr.length) {
            sb.append(arr[ii].toXml(extraOffset + " "));
            ++ii;
        }
        sb.append(data.getSubjectQueueProperty().toXml(extraOffset + " "));
        sb.append(data.getSessionCbQueueProperty().toXml(extraOffset + " "));
        arr = data.getServerRefs();
        ii = 0;
        while (arr != null && ii < arr.length) {
            sb.append(((ServerRef)arr[ii]).toXml(extraOffset + " "));
            ++ii;
        }
        sb.append(data.writePropertiesXml(extraOffset + " "));
        sb.append(offset).append("</qos>");
        return sb.toString();
    }

    public String getName() {
        return "ConnectQosSaxFactory";
    }
}

