/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import java.io.Serializable;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.property.PropBoolean;
import org.xmlBlaster.util.qos.I_DisconnectQosFactory;
import org.xmlBlaster.util.qos.QosData;

public class DisconnectQosData
extends QosData
implements Serializable,
Cloneable {
    private String ME = "DisconnectQosData";
    protected transient I_DisconnectQosFactory factory;
    private PropBoolean deleteSubjectQueue = new PropBoolean(true);
    private PropBoolean clearSessions = new PropBoolean(false);

    public DisconnectQosData(Global glob) {
        this(glob, (I_DisconnectQosFactory)null, (String)null);
    }

    public DisconnectQosData(Global glob, I_DisconnectQosFactory factory, String serialData) {
        super(glob, serialData, MethodName.DISCONNECT);
        this.factory = factory == null ? this.glob.getDisconnectQosFactory() : factory;
    }

    public boolean isPersistent() {
        if (super.isPersistent()) {
            this.glob.getLog("client").warn(this.ME, "DisconnectQos messages is changed to be not persistent, as this would disconnect a client automatically on restart if the disconnect is queued on client side");
        }
        return false;
    }

    public String toString() {
        return this.toXml();
    }

    public boolean deleteSubjectQueue() {
        return this.deleteSubjectQueue.getValue();
    }

    public PropBoolean deleteSubjectQueueProp() {
        return this.deleteSubjectQueue;
    }

    public void deleteSubjectQueue(boolean del) {
        this.deleteSubjectQueue.setValue(del);
    }

    public boolean clearSessions() {
        return this.clearSessions.getValue();
    }

    public PropBoolean clearSessionsProp() {
        return this.clearSessions;
    }

    public void clearSessions(boolean del) {
        this.clearSessions.setValue(del);
    }

    public final String toXml() {
        return this.toXml("");
    }

    public final String toXml(String extraOffset) {
        return this.factory.writeObject(this, extraOffset);
    }

    public Object clone() {
        DisconnectQosData newOne = null;
        newOne = (DisconnectQosData)super.clone();
        DisconnectQosData disconnectQosData = this;
        synchronized (disconnectQosData) {
            newOne.deleteSubjectQueue = (PropBoolean)this.deleteSubjectQueue.clone();
            newOne.clearSessions = (PropBoolean)this.clearSessions.clone();
        }
        return newOne;
    }
}

