/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.util.Global;

public final class HistoryQos {
    private static final String ME = "HistoryQos";
    private final Global glob;
    private final LogChannel log;
    public static final int DEFAULT_numEntries = 1;
    private int numEntries = 1;
    public static final boolean DEFAULT_newestFirst = true;
    private boolean newestFirst = true;

    public HistoryQos(Global glob) {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("core");
        this.setNumEntries(this.glob.getProperty().get("history.numEntries", 1));
    }

    public HistoryQos(Global glob, int numEntries) {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("core");
        this.setNumEntries(numEntries);
    }

    public void setNumEntries(int numEntries) {
        this.numEntries = numEntries < -1 ? -1 : numEntries;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public void setNewestFirst(boolean newestFirst) {
        this.newestFirst = newestFirst;
    }

    public boolean getNewestFirst() {
        return this.newestFirst;
    }

    public boolean startElement(String uri, String localName, String name, StringBuffer character, Attributes attrs) {
        String tmp = character.toString().trim();
        if (tmp.length() > 0) {
            this.log.warn(ME, "Ignoring history QoS query data '" + tmp + "'");
        }
        character.setLength(0);
        if (name.equalsIgnoreCase("history")) {
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    if (attrs.getQName(i).equalsIgnoreCase("numEntries")) {
                        String entryStr = attrs.getValue(i).trim();
                        try {
                            this.setNumEntries(Integer.parseInt(entryStr));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(ME, "Invalid history - numEntries =" + entryStr);
                        }
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("newestFirst")) {
                        this.setNewestFirst(new Boolean(attrs.getValue(i).trim()));
                    } else {
                        this.log.warn(ME, "Ignoring unknown attribute " + attrs.getQName(i) + " in history section.");
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public void endElement(String uri, String localName, String name, StringBuffer character) {
        String tmp;
        if (name.equalsIgnoreCase("history") && (tmp = character.toString().trim()).length() > 0) {
            this.log.warn(ME, "Ignoring history QoS query data '" + tmp + "'");
        }
        character.setLength(0);
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        if (this.getNumEntries() == 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer(300);
        String offset = "\n ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<history");
        sb.append(" numEntries='").append(this.getNumEntries()).append("'");
        sb.append(" newestFirst='").append(this.getNewestFirst()).append("'");
        sb.append("/>");
        return sb.toString();
    }
}

