/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.cluster.RouteInfo;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.property.PropBoolean;
import org.xmlBlaster.util.property.PropLong;
import org.xmlBlaster.util.qos.ClientProperty;
import org.xmlBlaster.util.qos.I_MsgQosFactory;
import org.xmlBlaster.util.qos.QosData;
import org.xmlBlaster.util.qos.TopicProperty;
import org.xmlBlaster.util.qos.address.Destination;

public final class MsgQosData
extends QosData
implements Serializable,
Cloneable {
    private String ME = "MsgQosData";
    private transient I_MsgQosFactory factory;
    private transient boolean isExpired = false;
    private TopicProperty topicProperty;
    private static final long maxLifeTime;
    private String subscriptionId;
    public static final transient boolean DEFAULT_isSubscribable = true;
    private PropBoolean subscribable = new PropBoolean(true);
    private int redeliver;
    private long queueIndex = -1L;
    private long queueSize = -1L;
    private boolean fromPersistenceStore = false;
    public static final transient boolean DEFAULT_persistent = false;
    private PropBoolean persistent = new PropBoolean(false);
    public static final transient boolean DEFAULT_forceUpdate = true;
    private PropBoolean forceUpdate = new PropBoolean(true);
    public static final long DEFAULT_lifeTime;
    private PropLong lifeTime = new PropLong(DEFAULT_lifeTime);
    private long remainingLifeStatic = -1L;
    public static final transient boolean DEFAULT_administrative = false;
    private PropBoolean administrative = new PropBoolean(false);
    public static final transient boolean DEFAULT_forceDestroy = false;
    private PropBoolean forceDestroy = new PropBoolean(false);
    private PriorityEnum priority = PriorityEnum.NORM_PRIORITY;
    private boolean priorityIsModified = false;
    protected ArrayList destinationList;
    protected transient Destination[] destinationArrCache;
    public static final Destination[] EMPTY_DESTINATION_ARR;
    private static final boolean receiveTimestampHumanReadable;

    public MsgQosData(Global glob, MethodName methodName) {
        this(glob, null, null, methodName);
    }

    public MsgQosData(Global glob, I_MsgQosFactory factory, MethodName methodName) {
        this(glob, factory, null, methodName);
    }

    public MsgQosData(Global glob, I_MsgQosFactory factory, String serialData, MethodName methodName) {
        super(glob, serialData, methodName);
        this.factory = factory == null ? this.glob.getMsgQosFactory() : factory;
    }

    public void setSubscribable(boolean isSubscribable) {
        this.subscribable.setValue(isSubscribable);
    }

    public boolean isSubscribable() {
        return this.subscribable.getValue();
    }

    public PropBoolean getSubscribableProp() {
        return this.subscribable;
    }

    public boolean isPtp() {
        return this.destinationList != null;
    }

    public void setVolatile(boolean volatileFlag) {
        if (volatileFlag) {
            this.setLifeTime(0L);
            this.setForceDestroy(false);
            this.setRemainingLifeStatic(0L);
        }
    }

    public boolean isVolatile() {
        return this.getLifeTime() == 0L && !this.isForceDestroy();
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate.setValue(forceUpdate);
    }

    public boolean isForceUpdate() {
        return this.forceUpdate.getValue();
    }

    public PropBoolean getForceUpdateProp() {
        return this.forceUpdate;
    }

    public void setReadonly(boolean readonly) {
        TopicProperty prop = this.getTopicProperty();
        prop.setReadonly(true);
    }

    public boolean isReadonly() {
        return this.getTopicProperty().isReadonly();
    }

    public void setRedeliver(int redeliver) {
        this.redeliver = redeliver;
    }

    public void incrRedeliver() {
        ++this.redeliver;
    }

    public int getRedeliver() {
        return this.redeliver;
    }

    public void setQueueSize(long queueSize) {
        this.queueSize = queueSize;
    }

    public long getQueueSize() {
        return this.queueSize;
    }

    public void setQueueIndex(long queueIndex) {
        this.queueIndex = queueIndex;
    }

    public long getQueueIndex() {
        return this.queueIndex;
    }

    public PriorityEnum getPriority() {
        return this.priority;
    }

    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
        this.priorityIsModified = true;
    }

    public boolean isFromPersistenceStore() {
        return this.fromPersistenceStore;
    }

    public void setFromPersistenceStore(boolean fromPersistenceStore) {
        this.fromPersistenceStore = fromPersistenceStore;
    }

    public long getLifeTime() {
        return this.lifeTime.getValue();
    }

    public PropLong getLifeTimeProp() {
        return this.lifeTime;
    }

    public void setLifeTime(long lifeTime) {
        this.lifeTime.setValue(lifeTime);
    }

    public long getRemainingLife() {
        if (this.getLifeTime() > 0L && this.getLifeTime() < Long.MAX_VALUE && this.getRcvTimestamp() != null) {
            long ttl = this.getRcvTimestamp().getMillis() + this.getLifeTime() - System.currentTimeMillis();
            return ttl < 0L ? 0L : ttl;
        }
        return -1L;
    }

    public long getRemainingLifeStatic() {
        return this.remainingLifeStatic;
    }

    public void setRemainingLifeStatic(long remainingLifeStatic) {
        this.remainingLifeStatic = remainingLifeStatic;
    }

    public boolean isExpired() {
        if (this.getLifeTime() == Long.MAX_VALUE || this.getLifeTime() <= 0L) {
            return false;
        }
        if (this.getRcvTimestamp() == null) {
            return false;
        }
        if (this.isExpired) {
            return true;
        }
        this.isExpired = System.currentTimeMillis() > this.getRcvTimestamp().getMillis() + this.getLifeTime();
        return this.isExpired;
    }

    public static long getMaxLifeTime() {
        return maxLifeTime;
    }

    public String getXmlRcvTimestamp() {
        if (this.getRcvTimestamp() == null) {
            return "";
        }
        if (receiveTimestampHumanReadable) {
            return this.getRcvTimestamp().toXml(null, true);
        }
        return this.getRcvTimestamp().toXml();
    }

    public String getRcvTime() {
        return this.rcvTimestamp != null ? this.rcvTimestamp.toString() : "";
    }

    public void setForceDestroy(boolean forceDestroy) {
        this.forceDestroy.setValue(forceDestroy);
    }

    public boolean isForceDestroy() {
        return this.forceDestroy.getValue();
    }

    public PropBoolean getForceDestroyProp() {
        return this.forceDestroy;
    }

    public void setAdministrative(boolean administrative) {
        this.administrative.setValue(administrative);
        if (!this.priorityIsModified) {
            this.priority = administrative ? PriorityEnum.MAX_PRIORITY : PriorityEnum.NORM_PRIORITY;
        }
    }

    public boolean isAdministrative() {
        return this.administrative.getValue();
    }

    public PropBoolean getAdministrativeProp() {
        return this.administrative;
    }

    public ArrayList getDestinations() {
        return this.destinationList;
    }

    public int getNumDestinations() {
        if (this.destinationList == null) {
            return 0;
        }
        return this.destinationList.size();
    }

    public Destination[] getDestinationArr() {
        if (this.destinationArrCache == null) {
            this.destinationArrCache = this.destinationList == null ? EMPTY_DESTINATION_ARR : this.destinationList.toArray(new Destination[this.destinationList.size()]);
        }
        return this.destinationArrCache;
    }

    public void addDestination(Destination destination) {
        if (destination == null) {
            return;
        }
        if (this.destinationList == null) {
            this.destinationList = new ArrayList();
        }
        this.destinationArrCache = null;
        this.destinationList.add(destination);
        if (!this.lifeTime.isModified()) {
            this.lifeTime.setValue(0L, 0);
        }
    }

    public void removeDestination(Destination destination) {
        if (destination == null || this.destinationList == null) {
            return;
        }
        this.destinationArrCache = null;
        ((AbstractCollection)this.destinationList).remove(destination);
        if (this.destinationList.size() < 1) {
            this.destinationList = null;
        }
    }

    public boolean hasTopicProperty() {
        return this.topicProperty != null;
    }

    public TopicProperty getTopicProperty() {
        if (this.topicProperty == null) {
            this.topicProperty = new TopicProperty(this.glob);
        }
        return this.topicProperty;
    }

    public void setTopicProperty(TopicProperty topicProperty) {
        this.topicProperty = topicProperty;
    }

    public Hashtable toJXPath() {
        SessionName sender;
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("/qos/rcvTimestamp/@nanos", "" + this.getRcvTimestamp());
        map.put("/qos/rcvTimestamp/text()", "" + this.getRcvTime());
        MethodName methodName = this.getMethod();
        if (methodName != null) {
            map.put("/qos/methodName/text()", methodName.toString());
        }
        map.put("/qos/persistent/text()", "" + this.isPersistent());
        Map pMap = this.getClientProperties();
        Iterator it = pMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            ClientProperty p = (ClientProperty)pMap.get(key);
            map.put("/qos/clientProperty[@name='" + key + "']/text()", p.getValueRaw());
            map.put("/qos/clientProperty[@name='" + key + "']/@type", p.getType());
            map.put("/qos/clientProperty[@name='" + key + "']/@encoding", p.getEncoding());
        }
        if (this.isUpdate() || this.isGet()) {
            RouteInfo[] routes = this.getRouteNodes();
            int i = 0;
            while (i < routes.length) {
                map.put("/qos/route/node[@id='" + routes[i].getId() + "']/@stratum", "" + routes[i].getStratum());
                map.put("/qos/route/node[@id='" + routes[i].getId() + "']/@timestamp", "" + routes[i].getTimestamp());
                map.put("/qos/route/node[@id='" + routes[i].getId() + "']/@dirtyRead", "" + routes[i].getDirtyRead());
                ++i;
            }
            if (this.getState() != null) {
                map.put("/qos/state/@id", this.getState());
            }
            if (this.getStateInfo() != null) {
                map.put("/qos/state/@info", this.getStateInfo());
            }
        }
        if (this.isUpdate()) {
            if (this.getSubscriptionId() != null) {
                map.put("/qos/subscribe/@id", this.getSubscriptionId());
            }
            map.put("/qos/queue/@index", "" + this.getQueueIndex());
            map.put("/qos/queue/@size", "" + this.getQueueSize());
            map.put("/qos/redeliver/text()", "" + this.getRedeliver());
        }
        if ((sender = this.getSender()) != null) {
            map.put("/qos/sender/text()", sender.toString());
        }
        map.put("/qos/expiration/@lifeTime", "" + this.getLifeTime());
        map.put("/qos/expiration/@remainingLife", "" + this.getRemainingLife());
        if (this.isPublish()) {
            // empty if block
        }
        return map;
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        return this.factory.writeObject(this, extraOffset);
    }

    public Object clone() {
        MsgQosData newOne = null;
        newOne = (MsgQosData)super.clone();
        MsgQosData msgQosData = this;
        synchronized (msgQosData) {
            newOne.subscribable = (PropBoolean)this.subscribable.clone();
            newOne.persistent = (PropBoolean)this.persistent.clone();
            newOne.forceUpdate = (PropBoolean)this.forceUpdate.clone();
            newOne.lifeTime = (PropLong)this.lifeTime.clone();
            newOne.administrative = (PropBoolean)this.administrative.clone();
            newOne.forceDestroy = (PropBoolean)this.forceDestroy.clone();
        }
        return newOne;
    }

    public void setGlobal(Global glob) {
        super.setGlobal(glob);
        this.factory = glob.getMsgQosFactory();
    }

    public static void main(String[] args) {
        MsgQosData md = new MsgQosData(new Global(args), MethodName.UPDATE);
        Hashtable map = md.toJXPath();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            System.out.println(key + " -> '" + map.get(key) + "'");
        }
    }

    static {
        DEFAULT_lifeTime = maxLifeTime = Global.instance().getProperty().get("message.maxLifeTime", -1L);
        EMPTY_DESTINATION_ARR = new Destination[0];
        receiveTimestampHumanReadable = Global.instance().getProperty().get("cb.receiveTimestampHumanReadable", false);
    }
}

