/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import java.util.ArrayList;
import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.RcvTimestamp;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlQoSBase;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.cluster.RouteInfo;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.qos.I_MsgQosFactory;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.qos.TopicProperty;
import org.xmlBlaster.util.qos.address.Destination;
import org.xmlBlaster.util.qos.storage.HistoryQueueProperty;
import org.xmlBlaster.util.qos.storage.MsgUnitStoreProperty;

public class MsgQosSaxFactory
extends XmlQoSBase
implements I_MsgQosFactory {
    private String ME = "MsgQosSaxFactory";
    private final Global glob;
    private final LogChannel log;
    private MsgQosData msgQosData;
    private boolean inState = false;
    private boolean inSubscribe = false;
    private boolean inRedeliver = false;
    private boolean inTopic = false;
    private boolean inQueue = false;
    private boolean inPersistence = false;
    private boolean inSubscribable = false;
    private boolean inDestination = false;
    private boolean inSender = false;
    private boolean inPriority = false;
    private boolean inExpiration = false;
    private boolean inRcvTimestamp = false;
    private boolean inIsVolatile = false;
    private boolean inAdministrative = false;
    private boolean inIsPersistent = false;
    private boolean inForceUpdate = false;
    private boolean inReadonly = false;
    private boolean inRoute = false;
    private Destination destination;
    private RouteInfo routeInfo;
    private boolean sendRemainingLife = true;

    public MsgQosSaxFactory(Global glob) {
        super(glob);
        this.glob = glob;
        this.log = glob.getLog("core");
    }

    public synchronized MsgQosData readObject(String xmlQos) throws XmlBlasterException {
        if (xmlQos == null) {
            xmlQos = "<qos/>";
        }
        this.msgQosData = new MsgQosData(this.glob, this, xmlQos, MethodName.UNKNOWN);
        if (!this.isEmpty(xmlQos)) {
            this.init(xmlQos);
        }
        return this.msgQosData;
    }

    public final void startElement(String uri, String localName, String name, Attributes attrs) {
        if (super.startElementBase(uri, localName, name, attrs)) {
            return;
        }
        if (name.equalsIgnoreCase("state")) {
            if (!this.inQos) {
                return;
            }
            this.inState = true;
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    if (attrs.getQName(i).equalsIgnoreCase("id")) {
                        this.msgQosData.setState(attrs.getValue(i).trim());
                    } else if (attrs.getQName(i).equalsIgnoreCase("info")) {
                        this.msgQosData.setStateInfo(attrs.getValue(i).trim());
                    }
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("subscribable")) {
            if (!this.inQos) {
                return;
            }
            this.inSubscribable = true;
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.log.warn(this.ME, "Ignoring sent <subscribable> tag " + attrs.getQName(i) + "=" + attrs.getValue(i).trim());
                    ++i;
                }
            }
            this.msgQosData.setSubscribable(true);
            return;
        }
        if (name.equalsIgnoreCase("destination")) {
            String tmp;
            if (!this.inQos) {
                return;
            }
            this.inDestination = true;
            this.destination = new Destination();
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    String tmp2;
                    if (attrs.getQName(i).equalsIgnoreCase("queryType")) {
                        String queryType = attrs.getValue(i).trim();
                        if (queryType.equalsIgnoreCase("EXACT")) {
                            this.destination.setQueryType(queryType);
                        } else if (queryType.equalsIgnoreCase("XPATH")) {
                            this.destination.setQueryType(queryType);
                        } else {
                            this.log.error(this.ME, "Sorry, destination queryType='" + queryType + "' is not supported");
                        }
                    } else if (attrs.getQName(i).equalsIgnoreCase("forceQueuing") && (tmp2 = attrs.getValue(i).trim()).length() > 0) {
                        this.destination.forceQueuing(new Boolean(tmp2));
                    }
                    ++i;
                }
            }
            if ((tmp = this.character.toString().trim()).length() > 0) {
                this.destination.setDestination(new SessionName(this.glob, tmp));
                this.character.setLength(0);
            }
            return;
        }
        if (name.equalsIgnoreCase("sender")) {
            if (!this.inQos) {
                return;
            }
            this.inSender = true;
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.log.warn(this.ME, "Ignoring sent <sender> attribute " + attrs.getQName(i) + "=" + attrs.getValue(i).trim());
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("priority")) {
            if (!this.inQos) {
                return;
            }
            this.inPriority = true;
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.log.warn(this.ME, "Ignoring sent <priority> attribute " + attrs.getQName(i) + "=" + attrs.getValue(i).trim());
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("expiration")) {
            if (!this.inQos) {
                return;
            }
            this.inExpiration = true;
            if (attrs != null) {
                int len = attrs.getLength();
                String tmp = attrs.getValue("lifeTime");
                if (tmp != null) {
                    try {
                        this.msgQosData.setLifeTime(Long.parseLong(tmp.trim()));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(this.ME, "Invalid lifeTime - millis =" + tmp);
                    }
                } else {
                    this.log.warn(this.ME, "QoS <expiration> misses lifeTime attribute, setting default of " + MsgQosData.getMaxLifeTime());
                    this.msgQosData.setLifeTime(MsgQosData.getMaxLifeTime());
                }
                tmp = attrs.getValue("forceDestroy");
                if (tmp != null) {
                    this.msgQosData.setForceDestroy(new Boolean(tmp.trim()));
                }
                if ((tmp = attrs.getValue("remainingLife")) != null) {
                    try {
                        this.msgQosData.setRemainingLifeStatic(Long.parseLong(tmp.trim()));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(this.ME, "Invalid remainingLife - millis =" + tmp);
                    }
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("topic")) {
            if (!this.inQos) {
                return;
            }
            this.inTopic = true;
            TopicProperty tmpProp = new TopicProperty(this.glob);
            String tmp = attrs.getValue("readonly");
            if (tmp != null) {
                tmpProp.setReadonly(new Boolean(tmp.trim()));
            }
            if ((tmp = attrs.getValue("destroyDelay")) != null) {
                try {
                    tmpProp.setDestroyDelay(Long.parseLong(tmp.trim()));
                }
                catch (NumberFormatException e) {
                    this.log.warn(this.ME, "Invalid topic destroyDelay - millis =" + tmp);
                }
            }
            if ((tmp = attrs.getValue("createDomEntry")) != null) {
                tmpProp.setCreateDomEntry(new Boolean(tmp.trim()));
            }
            this.msgQosData.setTopicProperty(tmpProp);
            return;
        }
        if (name.equalsIgnoreCase("queue")) {
            if (!this.inQos) {
                return;
            }
            this.inQueue = true;
            if (attrs != null) {
                String indexVal = attrs.getValue("index");
                if (indexVal != null) {
                    try {
                        this.msgQosData.setQueueIndex(Integer.parseInt(indexVal));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(this.ME, "Invalid queue - index =" + indexVal);
                    }
                    String tmp = attrs.getValue("size");
                    if (tmp != null) {
                        try {
                            this.msgQosData.setQueueSize(Integer.parseInt(tmp));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(this.ME, "Invalid queue - index =" + tmp);
                        }
                    }
                    return;
                }
                if (this.inTopic) {
                    String relatedVal = attrs.getValue("relating");
                    if (relatedVal == null) {
                        relatedVal = "msgUnitStore";
                    }
                    if ("msgUnitStore".equalsIgnoreCase(relatedVal = relatedVal.trim())) {
                        MsgUnitStoreProperty tmpProp = new MsgUnitStoreProperty(this.glob, this.glob.getId());
                        tmpProp.startElement(uri, localName, name, attrs);
                        this.msgQosData.getTopicProperty().setMsgUnitStoreProperty(tmpProp);
                    } else {
                        HistoryQueueProperty tmpProp = new HistoryQueueProperty(this.glob, this.glob.getId());
                        tmpProp.startElement(uri, localName, name, attrs);
                        this.msgQosData.getTopicProperty().setHistoryQueueProperty(tmpProp);
                    }
                    return;
                }
                this.log.warn(this.ME, "Found queue tag but don't know how to handle it: " + this.xmlLiteral);
            }
            return;
        }
        if (name.equalsIgnoreCase("persistence")) {
            if (!this.inQos) {
                return;
            }
            this.inPersistence = true;
            if (attrs != null) {
                if (this.inTopic) {
                    MsgUnitStoreProperty tmpProp = new MsgUnitStoreProperty(this.glob, this.glob.getId());
                    tmpProp.startElement(uri, localName, name, attrs);
                    this.msgQosData.getTopicProperty().setMsgUnitStoreProperty(tmpProp);
                    return;
                }
                this.log.warn(this.ME, "Found msgUnitStore tag but don't know how to handle it: " + this.xmlLiteral);
            }
            return;
        }
        if (name.equalsIgnoreCase("rcvTimestamp")) {
            if (!this.inQos) {
                return;
            }
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    if (attrs.getQName(i).equalsIgnoreCase("nanos")) {
                        String tmp = attrs.getValue(i).trim();
                        try {
                            this.msgQosData.setRcvTimestamp(new RcvTimestamp(Long.parseLong(tmp)));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(this.ME, "Invalid rcvTimestamp - nanos =" + tmp);
                        }
                    }
                    ++i;
                }
            }
            this.inRcvTimestamp = true;
            return;
        }
        if (name.equalsIgnoreCase("redeliver")) {
            if (!this.inQos) {
                return;
            }
            this.inRedeliver = true;
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.log.warn(this.ME, "Ignoring sent <redeliver> attribute " + attrs.getQName(i) + "=" + attrs.getValue(i).trim());
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("route")) {
            if (!this.inQos) {
                return;
            }
            this.inRoute = true;
            return;
        }
        if (name.equalsIgnoreCase("node")) {
            if (!this.inRoute) {
                this.log.error(this.ME, "Ignoring <node>, it is not inside <route>");
                return;
            }
            if (attrs != null) {
                String id = attrs.getValue("id");
                if (id == null || id.length() < 1) {
                    this.log.error(this.ME, "QoS <route><node> misses id attribute, ignoring node");
                    return;
                }
                NodeId nodeId = new NodeId(id);
                int stratum = 0;
                String tmp = attrs.getValue("stratum");
                if (tmp != null) {
                    try {
                        stratum = Integer.parseInt(tmp.trim());
                    }
                    catch (NumberFormatException e) {
                        this.log.error(this.ME, "Invalid stratum =" + tmp);
                    }
                } else {
                    this.log.warn(this.ME, "QoS <route><node> misses stratum attribute, setting to 0: " + this.xmlLiteral);
                }
                Timestamp timestamp = null;
                tmp = attrs.getValue("timestamp");
                if (tmp != null) {
                    try {
                        timestamp = new Timestamp(Long.parseLong(tmp.trim()));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(this.ME, "Invalid route Timestamp - nanos =" + tmp);
                    }
                } else {
                    this.log.warn(this.ME, "QoS <route><node> misses receive timestamp attribute, setting to 0");
                    timestamp = new Timestamp(0L);
                }
                String tmpDirty = attrs.getValue("dirtyRead");
                boolean dirtyRead = false;
                if (tmpDirty != null) {
                    try {
                        dirtyRead = new Boolean(tmpDirty.trim());
                    }
                    catch (NumberFormatException e) {
                        this.log.error(this.ME, "Invalid dirtyRead =" + tmpDirty);
                    }
                }
                this.routeInfo = new RouteInfo(nodeId, stratum, timestamp);
                if (tmpDirty != null) {
                    this.routeInfo.setDirtyRead(dirtyRead);
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("forceQueuing")) {
            if (!this.inDestination) {
                return;
            }
            this.log.error(this.ME, "forceQueuing is an attribute of destination - change your code");
            return;
        }
        if (name.equalsIgnoreCase("subscribe")) {
            if (!this.inQos) {
                return;
            }
            this.inSubscribe = true;
            if (attrs != null) {
                this.msgQosData.setSubscriptionId(attrs.getValue("id"));
            }
            return;
        }
        if (name.equalsIgnoreCase("isVolatile")) {
            if (!this.inQos) {
                return;
            }
            this.inIsVolatile = true;
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.log.warn(this.ME, "Ignoring sent <isVolatile> attribute " + attrs.getQName(i) + "=" + attrs.getValue(i).trim());
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("administrative")) {
            if (!this.inQos) {
                return;
            }
            this.inAdministrative = true;
            this.msgQosData.setAdministrative(true);
            return;
        }
        if (name.equalsIgnoreCase("persistent")) {
            if (!this.inQos) {
                return;
            }
            this.inIsPersistent = true;
            this.msgQosData.setPersistent(true);
            return;
        }
        if (name.equalsIgnoreCase("forceUpdate")) {
            if (!this.inQos) {
                return;
            }
            this.inForceUpdate = true;
            this.msgQosData.setForceUpdate(true);
            return;
        }
        if (name.equalsIgnoreCase("readonly")) {
            if (!this.inQos) {
                return;
            }
            this.inReadonly = true;
            this.msgQosData.setReadonly(true);
            this.log.error(this.ME, "<qos><readonly/></qos> is deprecated, please use readonly as topic attribute <qos><topic readonly='true'></qos>");
            return;
        }
        if (name.equalsIgnoreCase("isPublish")) {
            if (!this.inQos) {
                return;
            }
            this.msgQosData.setMethod(MethodName.PUBLISH);
            return;
        }
        if (name.equalsIgnoreCase("isUpdate")) {
            if (!this.inQos) {
                return;
            }
            this.msgQosData.setMethod(MethodName.UPDATE);
            return;
        }
        if (name.equalsIgnoreCase("isGet")) {
            if (!this.inQos) {
                return;
            }
            this.msgQosData.setMethod(MethodName.GET);
            return;
        }
        if (name.equalsIgnoreCase("msgDistributor")) {
            if (!this.inTopic) {
                return;
            }
            String typeVersion = attrs.getValue("typeVersion");
            this.msgQosData.getTopicProperty().setMsgDistributor(typeVersion);
            this.character.setLength(0);
            return;
        }
    }

    public void endElement(String uri, String localName, String name) {
        if (super.endElementBase(uri, localName, name)) {
            if (name.equalsIgnoreCase("clientProperty")) {
                this.msgQosData.addClientProperty(this.clientProperty);
            }
            return;
        }
        if (name.equalsIgnoreCase("state")) {
            this.inState = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("subscribable")) {
            this.inSubscribable = false;
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.msgQosData.setSubscribable(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("destination")) {
            this.inDestination = false;
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.destination.setDestination(new SessionName(this.glob, tmp));
                this.character.setLength(0);
            }
            this.msgQosData.addDestination(this.destination);
            return;
        }
        if (name.equalsIgnoreCase("sender")) {
            this.inSender = false;
            this.msgQosData.setSender(new SessionName(this.glob, this.character.toString().trim()));
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("priority")) {
            this.inPriority = false;
            try {
                this.msgQosData.setPriority(PriorityEnum.parsePriority(this.character.toString()));
            }
            catch (IllegalArgumentException e) {
                this.msgQosData.setPriority(PriorityEnum.NORM_PRIORITY);
                this.log.warn(this.ME, "Problems parsing priority, setting priority to " + this.msgQosData.getPriority().toString() + ": " + e.toString());
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("expiration")) {
            this.inExpiration = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("topic")) {
            this.inTopic = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("queue")) {
            this.inQueue = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("persistence")) {
            this.inPersistence = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("rcvTimestamp")) {
            this.inRcvTimestamp = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("subscribe")) {
            this.inSubscribe = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isVolatile")) {
            this.inIsVolatile = false;
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.msgQosData.setVolatile(new Boolean(tmp));
                if (this.msgQosData.isVolatile()) {
                    this.log.warn(this.ME, "Found 'isVolatile=" + this.msgQosData.isVolatile() + "' which is deprecated, use lifeTime==0&&forceDestroy==false instead");
                }
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("administrative")) {
            this.inAdministrative = false;
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.msgQosData.setAdministrative(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("persistent")) {
            this.inIsPersistent = false;
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.msgQosData.setPersistent(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("forceUpdate")) {
            this.inForceUpdate = false;
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.msgQosData.setForceUpdate(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("readonly")) {
            this.inReadonly = false;
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.msgQosData.setReadonly(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("redeliver")) {
            this.inRedeliver = false;
            String tmp = this.character.toString().trim();
            try {
                this.msgQosData.setRedeliver(Integer.parseInt(tmp));
            }
            catch (NumberFormatException e) {
                this.log.error(this.ME, "Invalid redeliver =" + tmp);
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("node")) {
            this.msgQosData.addRouteInfo(this.routeInfo);
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("route")) {
            this.inRoute = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isPublish")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isUpdate")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isGet")) {
            this.character.setLength(0);
            return;
        }
        this.character.setLength(0);
    }

    public final String writeObject(MsgQosData msgQosData, String extraOffset) {
        RouteInfo[] routeInfoArr;
        ArrayList list;
        StringBuffer sb = new StringBuffer(1024);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<qos>");
        if (!msgQosData.isOk() || msgQosData.getStateInfo() != null && msgQosData.getStateInfo().length() > 0) {
            sb.append(offset).append(" <state id='").append(msgQosData.getState());
            if (msgQosData.getStateInfo() != null) {
                sb.append("' info='").append(msgQosData.getStateInfo());
            }
            sb.append("'/>");
        }
        if (msgQosData.getSubscribableProp().isModified()) {
            if (msgQosData.isSubscribable()) {
                sb.append(offset).append(" <subscribable/>");
            } else {
                sb.append(offset).append(" <subscribable>false</subscribable>");
            }
        }
        if ((list = msgQosData.getDestinations()) != null) {
            int ii = 0;
            while (ii < list.size()) {
                Destination destination = (Destination)list.get(ii);
                sb.append(destination.toXml(extraOffset + " "));
                ++ii;
            }
        }
        if (msgQosData.getSender() != null) {
            sb.append(offset).append(" <sender>").append(msgQosData.getSender().getAbsoluteName()).append("</sender>");
        }
        if (PriorityEnum.NORM_PRIORITY != msgQosData.getPriority()) {
            if (PriorityEnum.NORM_PRIORITY.toString().equals(msgQosData.getPriority().toString())) {
                int hash1 = PriorityEnum.NORM_PRIORITY.hashCode();
                int hash2 = msgQosData.getPriority().hashCode();
                this.log.error(this.ME, "The strings should not equal: PriorityEnum.NORM_PRIORITY=" + PriorityEnum.NORM_PRIORITY + " hash1=" + hash1 + " msgQosData.getPriority()=" + msgQosData.getPriority() + " hash2=" + hash2);
            }
            sb.append(offset).append(" <priority>").append(msgQosData.getPriority()).append("</priority>");
        }
        if (msgQosData.getSubscriptionId() != null) {
            sb.append(offset).append(" <subscribe id='").append(msgQosData.getSubscriptionId()).append("'/>");
        }
        if (msgQosData.getLifeTimeProp().isModified() || msgQosData.getForceDestroyProp().isModified()) {
            sb.append(offset).append(" <expiration");
            if (msgQosData.getLifeTimeProp().isModified()) {
                sb.append(" lifeTime='").append(msgQosData.getLifeTime()).append("'");
            }
            if (this.sendRemainingLife()) {
                long remainCached = msgQosData.getRemainingLife();
                if (remainCached > 0L) {
                    sb.append(" remainingLife='").append(remainCached).append("'");
                } else if (msgQosData.getRemainingLifeStatic() >= 0L) {
                    sb.append(" remainingLife='").append(msgQosData.getRemainingLifeStatic()).append("'");
                }
            }
            if (msgQosData.getForceDestroyProp().isModified()) {
                sb.append(" forceDestroy='").append(msgQosData.isForceDestroy()).append("'");
            }
            sb.append("/>");
        }
        if (msgQosData.getRcvTimestamp() != null) {
            sb.append(msgQosData.getRcvTimestamp().toXml(extraOffset + " ", false));
        }
        if (msgQosData.getQueueSize() > 0L) {
            sb.append(offset).append(" <queue index='").append(msgQosData.getQueueIndex()).append("' size='").append(msgQosData.getQueueSize()).append("'/>");
        }
        if (msgQosData.getAdministrativeProp().isModified()) {
            if (msgQosData.isAdministrative()) {
                sb.append(offset).append(" <administrative/>");
            } else {
                sb.append(offset).append(" <administrative>false</administrative>");
            }
        }
        if (msgQosData.getPersistentProp().isModified()) {
            if (msgQosData.isPersistent()) {
                sb.append(offset).append(" <persistent/>");
            } else {
                sb.append(offset).append(" <persistent>false</persistent>");
            }
        }
        if (msgQosData.getForceUpdateProp().isModified()) {
            if (msgQosData.isForceUpdate()) {
                sb.append(offset).append(" <forceUpdate/>");
            } else {
                sb.append(offset).append(" <forceUpdate>false</forceUpdate>");
            }
        }
        if (msgQosData.getRedeliver() > 0) {
            sb.append(offset).append(" <redeliver>").append(msgQosData.getRedeliver()).append("</redeliver>");
        }
        if ((routeInfoArr = msgQosData.getRouteNodes()).length > 0) {
            sb.append(offset).append(" <route>");
            int ii = 0;
            while (ii < routeInfoArr.length) {
                sb.append(routeInfoArr[ii].toXml(extraOffset + " "));
                ++ii;
            }
            sb.append(offset).append(" </route>");
        }
        if (msgQosData.getMethod() == MethodName.PUBLISH) {
            sb.append(offset).append(" <isPublish/>");
        } else if (msgQosData.getMethod() == MethodName.UPDATE) {
            sb.append(offset).append(" <isUpdate/>");
        } else if (msgQosData.getMethod() == MethodName.GET) {
            sb.append(offset).append(" <isGet/>");
        }
        if (msgQosData.hasTopicProperty()) {
            sb.append(msgQosData.getTopicProperty().toXml(extraOffset + " "));
        }
        sb.append(msgQosData.writePropertiesXml(extraOffset + " "));
        sb.append(offset).append("</qos>");
        if (sb.length() < 16) {
            return "<qos/>";
        }
        return sb.toString();
    }

    public String getName() {
        return "MsgQosSaxFactory";
    }

    public void sendRemainingLife(boolean sendRemainingLife) {
        this.sendRemainingLife = sendRemainingLife;
    }

    public boolean sendRemainingLife() {
        return this.sendRemainingLife;
    }
}

