/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.EncodableData;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.RcvTimestamp;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.cluster.RouteInfo;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.property.PropBoolean;
import org.xmlBlaster.util.qos.ClientProperty;

public abstract class QosData
implements Serializable,
Cloneable {
    private final transient String ME = "QosData";
    protected transient Global glob;
    protected transient LogChannel log;
    protected final transient String serialData;
    private String state = "OK";
    private String stateInfo;
    private boolean fromPersistenceRecovery = false;
    protected Timestamp rcvTimestamp;
    public static final transient boolean DEFAULT_persistent = false;
    private PropBoolean persistent = new PropBoolean(false);
    private SessionName sender;
    protected ArrayList routeNodeList;
    protected transient RouteInfo[] routeNodes;
    private static RouteInfo[] ROUTE_INFO_ARR_DUMMY = new RouteInfo[0];
    private MethodName methodName;
    private Map clientProperties;

    public QosData(Global glob, String serialData, MethodName methodName) {
        this.methodName = methodName;
        this.setGlobal(glob);
        this.serialData = serialData;
        this.clientProperties = new HashMap();
    }

    public void setGlobal(Global glob) {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = glob.getLog("core");
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state == null ? "OK" : this.state;
    }

    public void setStateInfo(String stateInfo) {
        this.stateInfo = stateInfo;
    }

    public String getStateInfo() {
        return this.stateInfo;
    }

    public boolean isOk() {
        return this.state == null || this.state.length() < 0 || "OK".equals(this.state);
    }

    public boolean isErased() {
        return "ERASED".equals(this.state);
    }

    public final boolean isTimeout() {
        return "TIMEOUT".equals(this.state);
    }

    public final boolean isForwardError() {
        return "FORWARD_ERROR".equals(this.state);
    }

    public void isFromPersistenceRecovery(boolean fromPersistenceRecovery) {
        this.fromPersistenceRecovery = fromPersistenceRecovery;
    }

    public boolean isFromPersistenceRecovery() {
        return this.fromPersistenceRecovery;
    }

    public SessionName getSender() {
        return this.sender;
    }

    public void setSender(SessionName senderSessionName) {
        this.sender = senderSessionName;
    }

    public void setRcvTimestamp(Timestamp rcvTimestamp) {
        this.rcvTimestamp = rcvTimestamp;
    }

    public Timestamp getRcvTimestamp() {
        return this.rcvTimestamp;
    }

    public void touchRcvTimestamp() {
        this.rcvTimestamp = new RcvTimestamp();
    }

    public String getRcvTime() {
        return this.rcvTimestamp != null ? this.rcvTimestamp.toString() : "";
    }

    public void setPersistent(boolean persistent) {
        this.persistent.setValue(persistent);
    }

    public boolean isPersistent() {
        return this.persistent.getValue();
    }

    public PropBoolean getPersistentProp() {
        return this.persistent;
    }

    public final void addRouteInfo(RouteInfo routeInfo) {
        if (routeInfo == null) {
            this.log.error("QosData", "Adding null routeInfo");
            return;
        }
        this.routeNodes = null;
        if (this.routeNodeList == null) {
            this.routeNodeList = new ArrayList();
        }
        this.routeNodeList.add(routeInfo);
        int offset = routeInfo.getStratum();
        if (offset < 0) {
            offset = 0;
        }
        int ii = this.routeNodeList.size() - 1;
        while (ii >= 0) {
            RouteInfo ri = (RouteInfo)this.routeNodeList.get(ii);
            ri.setStratum(offset++);
            --ii;
        }
    }

    public final int getNumRouteNodes() {
        return this.routeNodeList == null ? 0 : this.routeNodeList.size();
    }

    public final RouteInfo[] getRouteNodes() {
        if (this.routeNodeList == null) {
            this.routeNodes = ROUTE_INFO_ARR_DUMMY;
        }
        if (this.routeNodes == null) {
            this.routeNodes = this.routeNodeList.toArray(new RouteInfo[this.routeNodeList.size()]);
        }
        return this.routeNodes;
    }

    public final void clearRoutes() {
        this.routeNodes = null;
        if (this.routeNodeList != null) {
            this.routeNodeList.clear();
        }
    }

    public int count(NodeId nodeId) {
        int count = 0;
        if (this.routeNodeList == null) {
            return count;
        }
        int ii = 0;
        while (ii < this.routeNodeList.size()) {
            RouteInfo ri = (RouteInfo)this.routeNodeList.get(ii);
            if (ri.getNodeId().equals(nodeId)) {
                ++count;
            }
            ++ii;
        }
        return count;
    }

    public boolean dirtyRead(NodeId nodeId) {
        boolean count = false;
        if (this.routeNodeList == null || nodeId == null) {
            return false;
        }
        int ii = 0;
        while (ii < this.routeNodeList.size()) {
            RouteInfo ri = (RouteInfo)this.routeNodeList.get(ii);
            if (ri.getNodeId().equals(nodeId)) {
                return ri.getDirtyRead();
            }
            ++ii;
        }
        return false;
    }

    public int size() {
        return this.toXml().length();
    }

    public abstract String toXml();

    public abstract String toXml(String var1);

    public final Global getGlobal() {
        return this.glob;
    }

    public final MethodName getMethod() {
        return this.methodName;
    }

    public final void setMethod(MethodName methodName) {
        this.methodName = methodName;
    }

    public final boolean isPublish() {
        return this.methodName == MethodName.PUBLISH;
    }

    public final boolean isSubscribe() {
        return this.methodName == MethodName.SUBSCRIBE;
    }

    public final boolean isUnSubscribe() {
        return this.methodName == MethodName.UNSUBSCRIBE;
    }

    public final boolean isErase() {
        return this.methodName == MethodName.ERASE;
    }

    public final boolean isGet() {
        return this.methodName == MethodName.GET;
    }

    public final boolean isUpdate() {
        return this.methodName == MethodName.UPDATE;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public final void addClientProperty(ClientProperty clientProperty) {
        this.clientProperties.put(clientProperty.getName(), clientProperty);
    }

    public final void addClientProperty(String key, String type, Object value) {
        String encoding = null;
        String str = value == null ? null : value.toString();
        ClientProperty clientProperty = new ClientProperty(this.glob, key, type, encoding, str);
        this.clientProperties.put(clientProperty.getName(), clientProperty);
    }

    public final void addClientProperty(String key, Object value) {
        this.addClientProperty(key, EncodableData.getPropertyType(value), value);
    }

    public final void addClientProperty(String key, boolean value) {
        this.addClientProperty(key, "boolean", "" + value);
    }

    public final void addClientProperty(String key, int value) {
        this.addClientProperty(key, "int", "" + value);
    }

    public final void addClientProperty(String key, byte value) {
        this.addClientProperty(key, "byte", "" + value);
    }

    public final void addClientProperty(String key, long value) {
        this.addClientProperty(key, "long", "" + value);
    }

    public final void addClientProperty(String key, short value) {
        this.addClientProperty(key, "short", "" + value);
    }

    public final void addClientProperty(String key, double value) {
        this.addClientProperty(key, "double", "" + value);
    }

    public final void addClientProperty(String key, float value) {
        this.addClientProperty(key, "float", "" + value);
    }

    public final ClientProperty getClientProperty(String name) {
        if (name == null) {
            return null;
        }
        return (ClientProperty)this.clientProperties.get(name);
    }

    public final boolean propertyExists(String name) {
        if (name == null) {
            return false;
        }
        return this.clientProperties.get(name) != null;
    }

    public final String getClientProperty(String name, String defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        ClientProperty p = (ClientProperty)this.clientProperties.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p.getStringValue();
    }

    public final int getClientProperty(String name, int defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        ClientProperty p = (ClientProperty)this.clientProperties.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p.getIntValue();
    }

    public final boolean getClientProperty(String name, boolean defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        ClientProperty p = (ClientProperty)this.clientProperties.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p.getBooleanValue();
    }

    public final double getClientProperty(String name, double defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        ClientProperty p = (ClientProperty)this.clientProperties.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p.getDoubleValue();
    }

    public final float getClientProperty(String name, float defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        ClientProperty p = (ClientProperty)this.clientProperties.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p.getFloatValue();
    }

    public final byte getClientProperty(String name, byte defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        ClientProperty p = (ClientProperty)this.clientProperties.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p.getByteValue();
    }

    public final byte[] getClientProperty(String name, byte[] defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        ClientProperty p = (ClientProperty)this.clientProperties.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p.getBlobValue();
    }

    public final long getClientProperty(String name, long defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        ClientProperty p = (ClientProperty)this.clientProperties.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p.getLongValue();
    }

    public final short getClientProperty(String name, short defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        ClientProperty p = (ClientProperty)this.clientProperties.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p.getShortValue();
    }

    public final Map getClientProperties() {
        return this.clientProperties;
    }

    public final String writePropertiesXml(String offset) {
        if (this.clientProperties.size() > 0) {
            Object[] arr = this.clientProperties.keySet().toArray();
            StringBuffer sb = new StringBuffer(arr.length * 256);
            int i = 0;
            while (i < arr.length) {
                ClientProperty p = (ClientProperty)this.clientProperties.get(arr[i]);
                sb.append(p.toXml(offset));
                ++i;
            }
            return sb.toString();
        }
        return "";
    }
}

