/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlQoSBase;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.qos.AccessFilterQos;
import org.xmlBlaster.util.qos.HistoryQos;
import org.xmlBlaster.util.qos.I_QueryQosFactory;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.qos.QuerySpecQos;

public class QueryQosSaxFactory
extends XmlQoSBase
implements I_QueryQosFactory {
    private String ME = "QueryQosSaxFactory";
    private final Global glob;
    private final LogChannel log;
    private QueryQosData queryQosData;
    private boolean inSubscribe = false;
    private boolean inErase = false;
    private boolean inMeta = false;
    private boolean inContent = false;
    private boolean inMultiSubscribe = false;
    private boolean inLocal = false;
    private boolean inInitialUpdate = false;
    private boolean inNotify = false;
    private boolean inFilter = false;
    private boolean inQuerySpec = false;
    private boolean inHistory = false;
    private boolean inIsPersistent = false;
    private AccessFilterQos tmpFilter = null;
    private QuerySpecQos tmpQuerySpec = null;
    private HistoryQos tmpHistory = null;

    public QueryQosSaxFactory(Global glob) {
        super(glob);
        this.glob = glob;
        this.log = glob.getLog("core");
    }

    public synchronized QueryQosData readObject(String xmlQos) throws XmlBlasterException {
        if (xmlQos == null) {
            xmlQos = "<qos/>";
        }
        this.queryQosData = new QueryQosData(this.glob, this, xmlQos, MethodName.UNKNOWN);
        if (!this.isEmpty(xmlQos)) {
            this.init(xmlQos);
        }
        return this.queryQosData;
    }

    public final void startElement(String uri, String localName, String name, Attributes attrs) {
        if (super.startElementBase(uri, localName, name, attrs)) {
            return;
        }
        if (name.equalsIgnoreCase("subscribe")) {
            if (!this.inQos) {
                return;
            }
            this.inSubscribe = true;
            if (attrs != null) {
                this.queryQosData.setSubscriptionId(attrs.getValue("id"));
            }
            return;
        }
        if (name.equalsIgnoreCase("erase")) {
            if (!this.inQos) {
                return;
            }
            this.inErase = true;
            if (attrs != null) {
                this.queryQosData.setForceDestroy(new Boolean(attrs.getValue("forceDestroy")));
            }
            return;
        }
        if (name.equalsIgnoreCase("meta")) {
            if (!this.inQos) {
                return;
            }
            this.inMeta = true;
            this.queryQosData.setWantMeta(true);
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.log.warn(this.ME, "Ignoring sent <meta> attribute " + attrs.getQName(i) + "=" + attrs.getValue(i).trim());
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("content")) {
            if (!this.inQos) {
                return;
            }
            this.inContent = true;
            this.queryQosData.setWantContent(true);
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.log.warn(this.ME, "Ignoring sent <content> attribute " + attrs.getQName(i) + "=" + attrs.getValue(i).trim());
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("multiSubscribe")) {
            if (!this.inQos) {
                return;
            }
            this.inMultiSubscribe = true;
            this.queryQosData.setMultiSubscribe(true);
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.log.warn(this.ME, "Ignoring sent <multiSubscribe> attribute " + attrs.getQName(i) + "=" + attrs.getValue(i).trim());
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("local")) {
            if (!this.inQos) {
                return;
            }
            this.inLocal = true;
            this.queryQosData.setWantLocal(true);
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.log.warn(this.ME, "Ignoring sent <local> attribute " + attrs.getQName(i) + "=" + attrs.getValue(i).trim());
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("initialUpdate")) {
            if (!this.inQos) {
                return;
            }
            this.inInitialUpdate = true;
            this.queryQosData.setWantInitialUpdate(true);
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.log.warn(this.ME, "Ignoring sent <initialUpdate> attribute " + attrs.getQName(i) + "=" + attrs.getValue(i).trim());
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("notify")) {
            if (!this.inQos) {
                return;
            }
            this.inNotify = true;
            this.queryQosData.setWantNotify(true);
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    this.log.warn(this.ME, "Ignoring sent <notify> attribute " + attrs.getQName(i) + "=" + attrs.getValue(i).trim());
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("filter")) {
            this.inFilter = true;
            this.tmpFilter = new AccessFilterQos(this.glob);
            boolean ok = this.tmpFilter.startElement(uri, localName, name, this.character, attrs);
            if (ok) {
                this.queryQosData.addAccessFilter(this.tmpFilter);
            } else {
                this.tmpFilter = null;
            }
            return;
        }
        if (name.equalsIgnoreCase("querySpec")) {
            this.inQuerySpec = true;
            this.tmpQuerySpec = new QuerySpecQos(this.glob);
            boolean ok = this.tmpQuerySpec.startElement(uri, localName, name, this.character, attrs);
            if (ok) {
                this.queryQosData.addQuerySpec(this.tmpQuerySpec);
            } else {
                this.tmpQuerySpec = null;
            }
            return;
        }
        if (name.equalsIgnoreCase("history")) {
            this.inHistory = true;
            this.tmpHistory = new HistoryQos(this.glob);
            boolean ok = this.tmpHistory.startElement(uri, localName, name, this.character, attrs);
            if (ok) {
                this.queryQosData.setHistoryQos(this.tmpHistory);
            } else {
                this.tmpHistory = null;
            }
            return;
        }
        if (name.equalsIgnoreCase("isErase")) {
            if (!this.inQos) {
                return;
            }
            this.queryQosData.setMethod(MethodName.ERASE);
            return;
        }
        if (name.equalsIgnoreCase("isGet")) {
            if (!this.inQos) {
                return;
            }
            this.queryQosData.setMethod(MethodName.GET);
            return;
        }
        if (name.equalsIgnoreCase("isSubscribe")) {
            if (!this.inQos) {
                return;
            }
            this.queryQosData.setMethod(MethodName.SUBSCRIBE);
            return;
        }
        if (name.equalsIgnoreCase("isUnSubscribe")) {
            if (!this.inQos) {
                return;
            }
            this.queryQosData.setMethod(MethodName.UNSUBSCRIBE);
            return;
        }
        if (name.equalsIgnoreCase("persistent")) {
            if (!this.inQos) {
                return;
            }
            this.inIsPersistent = true;
            this.character.setLength(0);
            this.queryQosData.setPersistent(true);
            return;
        }
    }

    public void endElement(String uri, String localName, String name) {
        if (super.endElementBase(uri, localName, name)) {
            if (name.equalsIgnoreCase("clientProperty")) {
                this.queryQosData.addClientProperty(this.clientProperty);
            }
            return;
        }
        if (name.equalsIgnoreCase("subscribe")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("erase")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("meta")) {
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.queryQosData.setWantMeta(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("content")) {
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.queryQosData.setWantContent(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("multiSubscribe")) {
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.queryQosData.setMultiSubscribe(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("local")) {
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.queryQosData.setWantLocal(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("initialUpdate")) {
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.queryQosData.setWantInitialUpdate(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("notify")) {
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.queryQosData.setWantNotify(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("filter")) {
            this.inFilter = false;
            if (this.tmpFilter != null) {
                this.tmpFilter.endElement(uri, localName, name, this.character);
            }
            return;
        }
        if (name.equalsIgnoreCase("querySpec")) {
            this.inQuerySpec = false;
            if (this.tmpQuerySpec != null) {
                this.tmpQuerySpec.endElement(uri, localName, name, this.character);
            }
            return;
        }
        if (name.equalsIgnoreCase("history")) {
            this.inHistory = false;
            if (this.tmpHistory != null) {
                this.tmpHistory.endElement(uri, localName, name, this.character);
            }
            return;
        }
        if (name.equalsIgnoreCase("isErase")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isGet")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isSubscribe")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isUnSubscribe")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("persistent")) {
            this.inIsPersistent = false;
            String tmp = this.character.toString().trim();
            if (tmp.length() > 0) {
                this.queryQosData.setPersistent(new Boolean(tmp));
            }
            this.character.setLength(0);
            return;
        }
        this.character.setLength(0);
    }

    public final String writeObject(QueryQosData queryQosData, String extraOffset) {
        return QueryQosSaxFactory.writeObject_(queryQosData, extraOffset);
    }

    public static final String writeObject_(QueryQosData queryQosData, String extraOffset) {
        StringBuffer sb = new StringBuffer(1024);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<qos>");
        if (queryQosData.getSubscriptionId() != null) {
            sb.append(offset).append(" <subscribe id='").append(queryQosData.getSubscriptionId()).append("'/>");
        }
        if (queryQosData.getForceDestroyProp().isModified()) {
            sb.append(offset).append(" <erase forceDestroy='").append(queryQosData.getForceDestroy()).append("'/>");
        }
        if (queryQosData.getMetaProp().isModified()) {
            if (queryQosData.getWantMeta()) {
                sb.append(offset).append(" <meta/>");
            } else {
                sb.append(offset).append(" <meta>false</meta>");
            }
        }
        if (queryQosData.getContentProp().isModified()) {
            if (queryQosData.getWantContent()) {
                sb.append(offset).append(" <content/>");
            } else {
                sb.append(offset).append(" <content>false</content>");
            }
        }
        if (queryQosData.getMultiSubscribeProp().isModified()) {
            if (queryQosData.getMultiSubscribe()) {
                sb.append(offset).append(" <multiSubscribe/>");
            } else {
                sb.append(offset).append(" <multiSubscribe>false</multiSubscribe>");
            }
        }
        if (queryQosData.getLocalProp().isModified()) {
            if (queryQosData.getWantLocal()) {
                sb.append(offset).append(" <local/>");
            } else {
                sb.append(offset).append(" <local>false</local>");
            }
        }
        if (queryQosData.getInitialUpdateProp().isModified()) {
            if (queryQosData.getWantInitialUpdate()) {
                sb.append(offset).append(" <initialUpdate/>");
            } else {
                sb.append(offset).append(" <initialUpdate>false</initialUpdate>");
            }
        }
        if (queryQosData.getNotifyProp().isModified()) {
            if (queryQosData.getWantNotify()) {
                sb.append(offset).append(" <notify/>");
            } else {
                sb.append(offset).append(" <notify>false</notify>");
            }
        }
        if (queryQosData.getPersistentProp().isModified()) {
            if (queryQosData.isPersistent()) {
                sb.append(offset).append(" <persistent/>");
            } else {
                sb.append(offset).append(" <persistent>false</persistent>");
            }
        }
        AccessFilterQos[] list = queryQosData.getAccessFilterArr();
        int ii = 0;
        while (list != null && ii < list.length) {
            sb.append(list[ii].toXml(extraOffset + " "));
            ++ii;
        }
        QuerySpecQos[] querySpeclist = queryQosData.getQuerySpecArr();
        int ii2 = 0;
        while (querySpeclist != null && ii2 < querySpeclist.length) {
            sb.append(querySpeclist[ii2].toXml(extraOffset + " "));
            ++ii2;
        }
        HistoryQos historyQos = queryQosData.getHistoryQos();
        if (historyQos != null) {
            sb.append(historyQos.toXml(extraOffset + " "));
        }
        if (queryQosData.getMethod() == MethodName.ERASE) {
            sb.append(offset).append(" <isErase/>");
        } else if (queryQosData.getMethod() == MethodName.GET) {
            sb.append(offset).append(" <isGet/>");
        } else if (queryQosData.getMethod() == MethodName.SUBSCRIBE) {
            sb.append(offset).append(" <isSubscribe/>");
        } else if (queryQosData.getMethod() == MethodName.UNSUBSCRIBE) {
            sb.append(offset).append(" <isUnSubscribe/>");
        }
        sb.append(queryQosData.writePropertiesXml(extraOffset + " "));
        sb.append(offset).append("</qos>");
        if (sb.length() < 16) {
            return "<qos/>";
        }
        return sb.toString();
    }

    public String getName() {
        return "QueryQosSaxFactory";
    }
}

