/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.engine.mime.Query;
import org.xmlBlaster.util.Global;

public abstract class QueryRefinementQos {
    protected String ME = "QueryRefinementQos";
    protected final Global glob;
    protected final LogChannel log;
    protected Query query;
    protected String type;
    public static final String DEFAULT_version = "1.0";
    private String version = "1.0";
    protected String tagName = "filter";
    protected String logName = "mime";
    protected String versionProp = "accessFilter.version";

    protected QueryRefinementQos(Global glob, String tagName, String logName, String versionProp) {
        this.tagName = tagName;
        this.logName = logName;
        this.versionProp = versionProp;
        this.glob = glob;
        this.log = this.glob.getLog(this.logName);
        this.setVersion(glob.getProperty().get(this.versionProp, DEFAULT_version));
    }

    protected QueryRefinementQos(Global glob, String type, String version, String query, String tagName, String logName, String versionProp) {
        this.tagName = tagName;
        this.logName = logName;
        this.versionProp = versionProp;
        this.glob = glob;
        this.log = this.glob.getLog(this.logName);
        this.setType(type);
        this.setVersion(version);
        this.setQuery(new Query(glob, query));
    }

    protected QueryRefinementQos(Global glob, String type, String version, Query query, String tagName, String logName, String versionProp) {
        this.tagName = tagName;
        this.logName = logName;
        this.versionProp = versionProp;
        this.glob = glob;
        this.log = this.glob.getLog(this.logName);
        this.setType(type);
        this.setVersion(version);
        this.setQuery(query);
    }

    public final void setType(String type) {
        this.type = type;
    }

    public final String getType() {
        return this.type;
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setQuery(Query query) {
        this.query = query;
    }

    public final Query getQuery() {
        return this.query;
    }

    public final boolean startElement(String uri, String localName, String name, StringBuffer character, Attributes attrs) {
        String tmp = character.toString().trim();
        if (tmp.length() > 0) {
            this.setQuery(new Query(this.glob, tmp));
        }
        character.setLength(0);
        if (name.equalsIgnoreCase(this.tagName)) {
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    if (attrs.getQName(i).equalsIgnoreCase("type")) {
                        this.setType(attrs.getValue(i).trim());
                    } else if (attrs.getQName(i).equalsIgnoreCase("version")) {
                        this.setVersion(attrs.getValue(i).trim());
                    } else {
                        this.log.warn(this.ME, "Ignoring unknown attribute " + attrs.getQName(i) + " in " + this.tagName + " section.");
                    }
                    ++i;
                }
            }
            if (this.getType() == null) {
                this.log.warn(this.ME, "Missing '" + this.tagName + "' attribute 'type' in QoS, ignoring the " + this.tagName + " request");
                this.setType(null);
                return false;
            }
            return true;
        }
        return false;
    }

    public final void endElement(String uri, String localName, String name, StringBuffer character) {
        if (name.equalsIgnoreCase(this.tagName)) {
            String tmp = character.toString().trim();
            if (tmp.length() > 0) {
                this.setQuery(new Query(this.glob, tmp));
            } else if (this.getQuery() == null) {
                this.log.error(this.ME, this.tagName + " QoS contains no query data");
            }
        }
        character.setLength(0);
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(300);
        String offset = "\n ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<" + this.tagName + " type='").append(this.getType()).append("'");
        if (!DEFAULT_version.equals(this.getVersion())) {
            sb.append(" version='").append(this.getVersion()).append("'");
        }
        sb.append(">");
        if (this.getQuery().toString().indexOf("<![CDATA[") >= 0) {
            sb.append(offset).append(" ").append(this.getQuery());
        } else {
            sb.append(offset).append(" <![CDATA[").append(this.getQuery()).append("]]>");
        }
        sb.append(offset).append("</" + this.tagName + ">");
        return sb.toString();
    }
}

