/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import java.io.Serializable;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.property.PropBoolean;
import org.xmlBlaster.util.property.PropInt;
import org.xmlBlaster.util.property.PropLong;

public final class SessionQos
implements Serializable,
Cloneable {
    private final String ME = "SessionQos";
    private final transient Global glob;
    private final transient LogChannel log;
    private PropLong sessionTimeout = new PropLong(86400000L);
    public static final int DEFAULT_maxSessions = 10;
    private PropInt maxSessions = new PropInt(10);
    private PropBoolean clearSessions = new PropBoolean(false);
    protected PropBoolean reconnectSameClientOnly = new PropBoolean(false);
    private String sessionId = null;
    private SessionName sessionName;
    private boolean sessionNameModified = false;
    private NodeId nodeId = null;

    public SessionQos(Global glob) {
        this(glob, null);
    }

    public SessionQos(Global glob, NodeId nodeId) {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = glob.getLog(null);
        this.nodeId = nodeId;
        this.initialize();
    }

    private final void initialize() {
        String defaultLoginName = this.glob.getProperty().get("user.name", "guest");
        String sessionNameStr = this.glob.getProperty().get("session.name", defaultLoginName);
        this.setSessionTimeout(this.glob.getProperty().get("session.timeout", 86400000L));
        this.setMaxSessions(this.glob.getProperty().get("session.maxSessions", 10));
        this.clearSessions(this.glob.getProperty().get("session.clearSessions", false));
        this.setReconnectSameClientOnly(this.glob.getProperty().get("session.reconnectSameClientOnly", false));
        this.setSecretSessionId(this.glob.getProperty().get("session.secretSessionId", (String)null));
        if (this.nodeId != null) {
            sessionNameStr = this.glob.getProperty().get("session.name[" + this.nodeId + "]", sessionNameStr);
            this.setSessionTimeout(this.glob.getProperty().get("session.timeout[" + this.nodeId + "]", this.getSessionTimeout()));
            this.setMaxSessions(this.glob.getProperty().get("session.maxSessions[" + this.nodeId + "]", this.getMaxSessions()));
            this.clearSessions(this.glob.getProperty().get("session.clearSessions[" + this.nodeId + "]", this.clearSessions()));
            this.setReconnectSameClientOnly(this.glob.getProperty().get("session.reconnectSameClientOnly[" + this.nodeId + "]", this.reconnectSameClientOnly()));
            this.setSecretSessionId(this.glob.getProperty().get("session.secretSessionId[" + this.nodeId + "]", this.getSecretSessionId()));
        }
        this.sessionName = new SessionName(this.glob, this.nodeId, sessionNameStr);
        String loginName = this.glob.getProperty().get("loginName", (String)null);
        if (loginName != null) {
            this.log.warn("SessionQos", "session.name=" + this.sessionName + " is stronger than loginName=" + loginName + ", we proceed with " + this.sessionName);
        }
        if (this.log.TRACE) {
            this.log.trace("SessionQos", "initialize session.name=" + this.sessionName + " nodeId=" + this.nodeId);
        }
    }

    public final long getSessionTimeout() {
        return this.sessionTimeout.getValue();
    }

    public final void setSessionTimeout(long timeout) {
        if (timeout < 0L) {
            this.sessionTimeout.setValue(0L);
        } else {
            this.sessionTimeout.setValue(timeout);
        }
    }

    public final int getMaxSessions() {
        return this.maxSessions.getValue();
    }

    public final void setMaxSessions(int max) {
        if (max < 0) {
            this.maxSessions.setValue(0);
        } else {
            this.maxSessions.setValue(max);
        }
    }

    public final boolean clearSessions() {
        return this.clearSessions.getValue();
    }

    public void clearSessions(boolean clear) {
        this.clearSessions.setValue(clear);
    }

    public void setReconnectSameClientOnly(boolean reconnectSameClientOnly) {
        this.reconnectSameClientOnly.setValue(reconnectSameClientOnly);
    }

    public boolean reconnectSameClientOnly() {
        return this.reconnectSameClientOnly.getValue();
    }

    public PropBoolean reconnectSameClientOnlyProp() {
        return this.reconnectSameClientOnly;
    }

    public void setSecretSessionId(String id) {
        if (id == null || id.equals("")) {
            id = null;
        }
        this.sessionId = id;
    }

    public final String getSecretSessionId() {
        return this.sessionId;
    }

    public final long getPublicSessionId() {
        if (this.sessionName != null) {
            return this.sessionName.getPublicSessionId();
        }
        return 0L;
    }

    public final boolean hasPublicSessionId() {
        if (this.sessionName != null) {
            return this.sessionName.isSession();
        }
        return false;
    }

    public void setSessionName(SessionName sessionName) {
        this.sessionName = sessionName;
        this.sessionNameModified = true;
    }

    void setSessionName(SessionName sessionName, boolean markAsModified) {
        this.sessionName = sessionName;
        if (markAsModified) {
            this.sessionNameModified = markAsModified;
        }
    }

    public boolean isSessionNameModified() {
        return this.sessionNameModified;
    }

    public final SessionName getSessionName() {
        return this.sessionName;
    }

    public String toString() {
        return this.toXml();
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(250);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<session");
        if (this.getSessionName() != null) {
            sb.append(" name='").append(this.getSessionName().getAbsoluteName()).append("'");
        }
        if (this.sessionTimeout.isModified()) {
            sb.append(" timeout='").append(this.getSessionTimeout()).append("'");
        }
        if (this.maxSessions.isModified()) {
            sb.append(" maxSessions='").append(this.getMaxSessions()).append("'");
        }
        if (this.clearSessions.isModified()) {
            sb.append(" clearSessions='").append(this.clearSessions()).append("'");
        }
        if (this.reconnectSameClientOnly.isModified()) {
            sb.append(" reconnectSameClientOnly='").append(this.reconnectSameClientOnly()).append("'");
        }
        if (this.sessionId != null) {
            sb.append(" sessionId='").append(this.sessionId).append("'");
        }
        sb.append("/>");
        return sb.toString();
    }

    public Object clone() {
        try {
            this.log.error("SessionQos", "clone() is not tested");
            SessionQos newOne = null;
            newOne = (SessionQos)super.clone();
            SessionQos sessionQos = this;
            synchronized (sessionQos) {
                newOne.sessionTimeout = (PropLong)this.sessionTimeout.clone();
                newOne.maxSessions = (PropInt)this.maxSessions.clone();
                newOne.clearSessions = (PropBoolean)this.clearSessions.clone();
                newOne.reconnectSameClientOnly = (PropBoolean)this.reconnectSameClientOnly.clone();
            }
            return newOne;
        }
        catch (CloneNotSupportedException e) {
            this.log.error("SessionQos", e.toString());
            return null;
        }
    }

    public String usage() {
        String text = "\n";
        text = text + "Control my session settings\n";
        text = text + "   -session.name       The name for login, e.g. 'joe' or with public session ID 'joe/2' []\n";
        text = text + "   -session.timeout    How long lasts our login session in milliseconds, 0 is forever,\n";
        text = text + "                       defaults to one day [86400000].\n";
        text = text + "   -session.maxSessions\n";
        text = text + "                       Maximum number of simultanous logins per client [10].\n";
        text = text + "   -session.clearSessions\n";
        text = text + "                       Kill other sessions running under my login name [false]\n";
        text = text + "   -session.reconnectSameClientOnly\n";
        text = text + "                       Only creator client may reconnect to session [false]\n";
        text = text + "   -session.secretSessionId\n";
        text = text + "                       The secret sessionId []\n";
        text = text + "\n";
        return text;
    }
}

