/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.RcvTimestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.qos.I_StatusQosFactory;
import org.xmlBlaster.util.qos.StatusQosData;
import org.xmlBlaster.util.qos.StatusQosSaxFactory;

public class StatusQosQuickParseFactory
implements I_StatusQosFactory {
    private String ME = "StatusQosQuickParseFactory";
    private final Global glob;
    private StatusQosData statusQosData;

    public StatusQosQuickParseFactory(Global glob) {
        this.glob = glob;
    }

    public synchronized StatusQosData readObject(String xmlQos) throws XmlBlasterException {
        this.statusQosData = new StatusQosData(this.glob, this, xmlQos, MethodName.UNKNOWN);
        if (xmlQos != null && xmlQos.length() > 15) {
            this.statusQosData.setState(this.parseOurself(xmlQos, "<state id="));
            this.statusQosData.setStateInfo(this.parseOurself(xmlQos, "info="));
            this.statusQosData.setSubscriptionId(this.parseOurself(xmlQos, "<subscribe id="));
            this.statusQosData.setKeyOid(this.parseOurself(xmlQos, "<key oid="));
            String tmp = this.parseOurself(xmlQos, "<rcvTimestamp nanos=");
            if (tmp != null) {
                try {
                    this.statusQosData.setRcvTimestamp(new RcvTimestamp(Long.parseLong(tmp)));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    this.glob.getLog(null).error(this.ME, "Invalid rcvTimestamp - nanos =" + tmp);
                }
            }
        }
        return this.statusQosData;
    }

    private final String parseOurself(String str, String token) {
        int from;
        char apo;
        int end;
        int index = str.indexOf(token);
        if (index >= 0 && (end = str.indexOf(apo = str.charAt(from = index + token.length()), from + 1)) > 0) {
            return str.substring(from + 1, end);
        }
        return null;
    }

    public final String writeObject(StatusQosData statusQosData, String extraOffset) {
        return StatusQosSaxFactory.writeObject_(statusQosData, extraOffset);
    }

    public String getName() {
        return "StatusQosQuickParseFactory";
    }
}

