/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.RcvTimestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlQoSBase;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.qos.I_StatusQosFactory;
import org.xmlBlaster.util.qos.StatusQosData;

public class StatusQosSaxFactory
extends XmlQoSBase
implements I_StatusQosFactory {
    private String ME = "StatusQosSaxFactory";
    private final Global glob;
    private final LogChannel log;
    private StatusQosData statusQosData;
    private boolean inState = false;
    private boolean inSubscribe = false;
    private boolean inKey = false;
    private boolean inRcvTimestamp = false;

    public StatusQosSaxFactory(Global glob) {
        super(glob);
        this.glob = glob;
        this.log = glob.getLog("core");
    }

    public synchronized StatusQosData readObject(String xmlQos) throws XmlBlasterException {
        if (xmlQos == null) {
            xmlQos = "<qos/>";
        }
        this.statusQosData = new StatusQosData(this.glob, this, xmlQos, MethodName.UNKNOWN);
        if (!this.isEmpty(xmlQos)) {
            this.init(xmlQos);
        }
        return this.statusQosData;
    }

    public final void startElement(String uri, String localName, String name, Attributes attrs) {
        if (super.startElementBase(uri, localName, name, attrs)) {
            return;
        }
        if (name.equalsIgnoreCase("state")) {
            if (!this.inQos) {
                return;
            }
            this.inState = true;
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    if (attrs.getQName(i).equalsIgnoreCase("id")) {
                        this.statusQosData.setState(attrs.getValue(i).trim());
                    } else if (attrs.getQName(i).equalsIgnoreCase("info")) {
                        this.statusQosData.setStateInfo(attrs.getValue(i).trim());
                    }
                    ++i;
                }
            }
            return;
        }
        if (name.equalsIgnoreCase("subscribe")) {
            if (!this.inQos) {
                return;
            }
            this.inSubscribe = true;
            if (attrs != null) {
                this.statusQosData.setSubscriptionId(attrs.getValue("id"));
            }
            return;
        }
        if (name.equalsIgnoreCase("key")) {
            if (!this.inQos) {
                return;
            }
            this.inKey = true;
            if (attrs != null) {
                this.statusQosData.setKeyOid(attrs.getValue("oid"));
            }
            return;
        }
        if (name.equalsIgnoreCase("rcvTimestamp")) {
            if (!this.inQos) {
                return;
            }
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    if (attrs.getQName(i).equalsIgnoreCase("nanos")) {
                        String tmp = attrs.getValue(i).trim();
                        try {
                            this.statusQosData.setRcvTimestamp(new RcvTimestamp(Long.parseLong(tmp)));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(this.ME, "Invalid rcvTimestamp - nanos =" + tmp);
                        }
                    }
                    ++i;
                }
            }
            this.inRcvTimestamp = true;
            return;
        }
        if (name.equalsIgnoreCase("isErase")) {
            if (!this.inQos) {
                return;
            }
            this.statusQosData.setMethod(MethodName.ERASE);
            return;
        }
        if (name.equalsIgnoreCase("isPublish")) {
            if (!this.inQos) {
                return;
            }
            this.statusQosData.setMethod(MethodName.PUBLISH);
            return;
        }
        if (name.equalsIgnoreCase("isSubscribe")) {
            if (!this.inQos) {
                return;
            }
            this.statusQosData.setMethod(MethodName.SUBSCRIBE);
            return;
        }
        if (name.equalsIgnoreCase("isUnSubscribe")) {
            if (!this.inQos) {
                return;
            }
            this.statusQosData.setMethod(MethodName.UNSUBSCRIBE);
            return;
        }
        if (name.equalsIgnoreCase("isUpdate")) {
            if (!this.inQos) {
                return;
            }
            this.statusQosData.setMethod(MethodName.UPDATE);
            return;
        }
    }

    public void endElement(String uri, String localName, String name) {
        if (super.endElementBase(uri, localName, name)) {
            return;
        }
        if (name.equalsIgnoreCase("state")) {
            this.inState = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("subscribe")) {
            this.inSubscribe = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("key")) {
            this.inKey = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("rcvTimestamp")) {
            this.inRcvTimestamp = false;
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isErase")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isPublish")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isSubscribe")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isUnSubscribe")) {
            this.character.setLength(0);
            return;
        }
        if (name.equalsIgnoreCase("isUpdate")) {
            this.character.setLength(0);
            return;
        }
        this.character.setLength(0);
    }

    public final String writeObject(StatusQosData statusQosData, String extraOffset) {
        return StatusQosSaxFactory.writeObject_(statusQosData, extraOffset);
    }

    public static final String writeObject_(StatusQosData statusQosData, String extraOffset) {
        StringBuffer sb = new StringBuffer(180);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<qos>");
        if (!statusQosData.isOk()) {
            sb.append(offset).append(" <state id='").append(statusQosData.getState());
            if (statusQosData.getStateInfo() != null) {
                sb.append("' info='").append(statusQosData.getStateInfo());
            }
            sb.append("'/>");
        }
        if (statusQosData.getSubscriptionId() != null) {
            sb.append(offset).append(" <subscribe id='").append(statusQosData.getSubscriptionId()).append("'/>");
        }
        if (statusQosData.getKeyOid() != null) {
            sb.append(offset).append(" <key oid='").append(statusQosData.getKeyOid()).append("'/>");
        }
        if (statusQosData.getRcvTimestamp() != null) {
            sb.append(statusQosData.getRcvTimestamp().toXml(extraOffset + " ", false));
        }
        if (statusQosData.getMethod() == MethodName.ERASE) {
            sb.append(offset).append("<isErase/>");
        } else if (statusQosData.getMethod() == MethodName.PUBLISH) {
            sb.append(offset).append("<isPublish/>");
        } else if (statusQosData.getMethod() == MethodName.SUBSCRIBE) {
            sb.append(offset).append("<isSubscribe/>");
        } else if (statusQosData.getMethod() == MethodName.UNSUBSCRIBE) {
            sb.append(offset).append("<isUnSubscribe/>");
        } else if (statusQosData.getMethod() == MethodName.UPDATE) {
            sb.append(offset).append("<isUpdate/>");
        }
        sb.append(offset).append("</qos>");
        if (sb.length() < 16) {
            return "<qos/>";
        }
        return sb.toString();
    }

    public String getName() {
        return "StatusQosSaxFactory";
    }
}

