/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos;

import java.io.Serializable;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.property.PropBoolean;
import org.xmlBlaster.util.property.PropLong;
import org.xmlBlaster.util.property.PropString;
import org.xmlBlaster.util.qos.storage.HistoryQueueProperty;
import org.xmlBlaster.util.qos.storage.MsgUnitStoreProperty;

public final class TopicProperty
implements Serializable {
    private String ME = "TopicProperty";
    private transient Global glob;
    private transient LogChannel log;
    private transient MsgUnitStoreProperty msgUnitStoreProperty;
    private transient HistoryQueueProperty historyQueueProperty;
    private static final long destroyDelay_DEFAULT_DEFAULT = 60000L;
    public static final long destroyDelay_DEFAULT = Global.instance().getProperty().get("topic.destroyDelay", 60000L);
    public static boolean DEFAULT_readonly = false;
    private PropBoolean readonly = new PropBoolean(DEFAULT_readonly);
    private PropLong destroyDelay = new PropLong(destroyDelay_DEFAULT);
    private PropBoolean createDomEntry = new PropBoolean(true);
    private PropString msgDistributor = new PropString("undef,1.0");

    public TopicProperty(Global glob) {
        this.setGlobal(glob);
        if (this.glob.isServer()) {
            this.msgDistributor.setFromEnv(this.glob, null, "MsgDistributorPlugin/defaultPlugin");
        }
    }

    public void setReadonly(boolean readonly) {
        this.readonly.setValue(readonly);
    }

    public boolean isReadonly() {
        return this.readonly.getValue();
    }

    public long getDestroyDelay() {
        return this.destroyDelay.getValue();
    }

    public void setDestroyDelay(long destroyDelay) {
        this.destroyDelay.setValue(destroyDelay);
    }

    public boolean createDomEntry() {
        return this.createDomEntry.getValue();
    }

    public void setCreateDomEntry(boolean createDomEntry) {
        this.createDomEntry.setValue(createDomEntry);
    }

    public boolean hasMsgUnitStoreProperty() {
        return this.msgUnitStoreProperty != null;
    }

    public MsgUnitStoreProperty getMsgUnitStoreProperty() {
        if (this.msgUnitStoreProperty == null) {
            this.msgUnitStoreProperty = new MsgUnitStoreProperty(this.glob, this.glob.getStrippedId());
        }
        return this.msgUnitStoreProperty;
    }

    public void setMsgUnitStoreProperty(MsgUnitStoreProperty msgUnitStoreProperty) {
        this.msgUnitStoreProperty = msgUnitStoreProperty;
    }

    public boolean hasHistoryQueueProperty() {
        return this.historyQueueProperty != null;
    }

    public HistoryQueueProperty getHistoryQueueProperty() {
        if (this.historyQueueProperty == null) {
            this.historyQueueProperty = new HistoryQueueProperty(this.glob, this.glob.getStrippedId());
        }
        return this.historyQueueProperty;
    }

    public void setHistoryQueueProperty(HistoryQueueProperty historyQueueProperty) {
        this.historyQueueProperty = historyQueueProperty;
    }

    public void setMsgDistributor(String typeVersion) {
        if (typeVersion == null) {
            typeVersion = "undef,1.0";
        }
        this.msgDistributor.setValue(typeVersion);
    }

    public String getMsgDistributor() {
        return this.msgDistributor.getValue();
    }

    public boolean isMsgDistributorModified() {
        return this.msgDistributor.isModified();
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(512);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<topic");
        if (this.readonly.isModified()) {
            sb.append(" readonly='").append(this.isReadonly()).append("'");
        }
        if (this.destroyDelay.isModified()) {
            sb.append(" destroyDelay='").append(this.getDestroyDelay()).append("'");
        }
        if (this.createDomEntry.isModified()) {
            sb.append(" createDomEntry='").append(this.createDomEntry()).append("'");
        }
        sb.append(">");
        if (this.msgDistributor.isModified()) {
            sb.append(offset + "  ").append("<msgDistributor typeVersion='").append(this.msgDistributor.getValue()).append("'/>");
        }
        if (this.hasMsgUnitStoreProperty()) {
            sb.append(this.getMsgUnitStoreProperty().toXml(extraOffset + " "));
        }
        if (this.hasHistoryQueueProperty()) {
            sb.append(this.getHistoryQueueProperty().toXml(extraOffset + " "));
        }
        sb.append(offset).append("</topic>");
        if (sb.length() < 22) {
            return "";
        }
        return sb.toString();
    }

    public void setGlobal(Global glob) {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("core");
    }
}

