/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos.address;

import java.util.Vector;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.qos.address.AddressBase;

public class Address
extends AddressBase {
    private static final String ME = "Address";

    public Address(Global glob) {
        super(glob, "address");
        this.instanceName = "connection";
        this.initialize();
    }

    public Address(Global glob, String type) {
        super(glob, "address");
        this.instanceName = "connection";
        if (type != null) {
            this.setType(type);
        }
        this.initialize();
    }

    public Address(Global glob, String type, String nodeId) {
        super(glob, "address");
        this.nodeId = nodeId;
        this.instanceName = "connection";
        if (type != null) {
            this.setType(type);
        }
        this.initialize();
    }

    public int getDefaultRetries() {
        return -1;
    }

    public long getDefaultDelay() {
        return 5000L;
    }

    public long getDefaultPingInterval() {
        return 10000L;
    }

    public String getSettings() {
        StringBuffer buf = new StringBuffer(126);
        buf.append(super.getSettings());
        if (this.getDelay() > 0L) {
            buf.append(" delay=").append(this.getDelay()).append(" retries=").append(this.getRetries()).append(" pingInterval=").append(this.getPingInterval());
        }
        return buf.toString();
    }

    public String toString() {
        return this.getRawAddress();
    }

    public final String usage() {
        String text = "\nControl failsafe connection to xmlBlaster server:\n";
        text = text + super.usage();
        text = text + "   -dispatch/" + this.instanceName + "/burstMode/collectTime\n";
        text = text + "                       Number of milliseconds we shall collect\n";
        text = text + "                       publish messages [0].\n";
        text = text + "                       This allows performance tuning, try set it to 200.\n";
        return text;
    }

    public static void main(String[] argsDefault) {
        try {
            Global glob = new Global(argsDefault);
            Address a = new Address(glob);
            a.setType("SOCKET");
            a.setBootstrapHostname("oioihost");
            a.setRawAddress("9999");
            a.setRawAddress("127.0.0.1:7600");
            a.setCollectTime(12345L);
            a.setPingInterval(54321L);
            a.setRetries(17);
            a.setDelay(7890L);
            a.setOneway(true);
            a.setSecretSessionId("0x4546hwi89");
            System.out.println(a.toXml());
            String nodeId = "heron";
            Vector<String> vec = new Vector<String>();
            vec.addElement("-sessionId");
            vec.addElement("ERROR");
            vec.addElement("-sessionId[" + nodeId + "]");
            vec.addElement("OK");
            vec.addElement("-pingInterval");
            vec.addElement("8888");
            vec.addElement("-delay[" + nodeId + "]");
            vec.addElement("8888");
            String[] args = vec.toArray(new String[0]);
            Global glob2 = new Global(args);
            Address a2 = new Address(glob2, "RMI", nodeId);
            System.out.println(a2.toXml());
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("TestFailed: " + e.toString());
        }
    }
}

