/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos.address;

import java.util.Hashtable;
import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.property.PropBoolean;
import org.xmlBlaster.util.property.PropInt;
import org.xmlBlaster.util.property.PropLong;
import org.xmlBlaster.util.property.PropString;

public abstract class AddressBase {
    private static final String ME = "AddressBase";
    protected final Global glob;
    protected final LogChannel log;
    private Hashtable pluginAttributes;
    protected String rootTag = null;
    protected String instanceName;
    protected final String className = "dispatch";
    protected final String context;
    protected String envPrefix = "";
    private PropString rawAddress = new PropString("");
    private PropString bootstrapHostname = new PropString("");
    public static final int DEFAULT_bootstrapPort = 3412;
    private PropInt bootstrapPort = new PropInt(3412);
    public static final String DEFAULT_type = "IOR";
    protected PropString type = new PropString("IOR");
    public static final String DEFAULT_version = "1.0";
    protected PropString version = new PropString("1.0");
    public static final long DEFAULT_collectTime = 0L;
    protected PropLong collectTime = new PropLong(0L);
    protected PropLong pingInterval = new PropLong(this.getDefaultPingInterval());
    protected PropInt retries = new PropInt(this.getDefaultRetries());
    protected PropLong delay = new PropLong(this.getDefaultDelay());
    public static final boolean DEFAULT_oneway = false;
    protected PropBoolean oneway = new PropBoolean(false);
    public static final String DEFAULT_compressType = "";
    protected PropString compressType = new PropString("");
    public static final long DEFAULT_minSize = 0L;
    protected PropLong minSize = new PropLong(0L);
    public static final int DEFAULT_burstModeMaxEntries = -1;
    protected PropInt burstModeMaxEntries = new PropInt(-1);
    public static final long DEFAULT_burstModeMaxBytes = -1L;
    protected PropLong burstModeMaxBytes = new PropLong(-1L);
    public static final boolean DEFAULT_ptpAllowed = true;
    protected PropBoolean ptpAllowed = new PropBoolean(true);
    public static final String DEFAULT_sessionId = "unknown";
    protected PropString sessionId = new PropString("unknown");
    public static final boolean DEFAULT_useForSubjectQueue = true;
    protected PropBoolean useForSubjectQueue = new PropBoolean(true);
    public String DEFAULT_dispatchPlugin = "undef";
    protected PropString dispatchPlugin = new PropString(this.DEFAULT_dispatchPlugin);
    protected String nodeId;

    public abstract long getDefaultPingInterval();

    public abstract int getDefaultRetries();

    public abstract long getDefaultDelay();

    public AddressBase(Global glob, String rootTag) {
        this.context = null;
        this.glob = glob;
        this.log = glob.getLog("core");
        this.setRootTag(rootTag);
    }

    protected void initialize() {
        this.type.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "protocol");
        this.envPrefix = "plugin/" + this.type.getValue().toLowerCase() + "/";
        if (this.log.TRACE) {
            this.log.trace(ME, "type=" + this.type.getValue() + " nodeId=" + this.nodeId + " context=" + this.context + " className=" + "dispatch" + " instanceName=" + this.instanceName + " envPrefix=" + this.envPrefix);
        }
        this.bootstrapHostname.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "bootstrapHostname");
        this.bootstrapPort.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "bootstrapPort");
        this.burstModeMaxEntries.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "burstMode/maxEntries");
        this.burstModeMaxBytes.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "burstMode/maxBytes");
        this.collectTime.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "burstMode/collectTime");
        this.pingInterval.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "pingInterval");
        this.retries.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "retries");
        this.delay.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "delay");
        this.oneway.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "oneway");
        this.compressType.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "compress/type");
        this.minSize.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "compress/minSize");
        this.ptpAllowed.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "ptpAllowed");
        this.sessionId.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "sessionId");
        this.dispatchPlugin.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, "DispatchPlugin/defaultPlugin");
    }

    public void setPluginProperty(String key, String value) {
        if (this.pluginAttributes == null) {
            this.pluginAttributes = new Hashtable();
        }
        this.pluginAttributes.put(key, value);
    }

    public PropString getEnv(String key, String defaultValue) {
        Object val;
        PropString tmp = new PropString(key, defaultValue);
        if (this.pluginAttributes != null && (val = this.pluginAttributes.get(key)) != null) {
            tmp.setValue((String)val, 4);
            return tmp;
        }
        tmp.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, this.envPrefix + key);
        return tmp;
    }

    public PropInt getEnv(String key, int defaultValue) {
        Object val;
        PropInt tmp = new PropInt(key, defaultValue);
        if (this.pluginAttributes != null && (val = this.pluginAttributes.get(key)) != null) {
            tmp.setValue((String)val, 4);
            return tmp;
        }
        tmp.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, this.envPrefix + key);
        return tmp;
    }

    public PropLong getEnv(String key, long defaultValue) {
        Object val;
        PropLong tmp = new PropLong(key, defaultValue);
        if (this.pluginAttributes != null && (val = this.pluginAttributes.get(key)) != null) {
            tmp.setValue((String)val, 4);
            return tmp;
        }
        tmp.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, this.envPrefix + key);
        return tmp;
    }

    public PropBoolean getEnv(String key, boolean defaultValue) {
        Object val;
        PropBoolean tmp = new PropBoolean(key, defaultValue);
        if (this.pluginAttributes != null && (val = this.pluginAttributes.get(key)) != null) {
            tmp.setValue((String)val, 4);
            return tmp;
        }
        tmp.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, this.envPrefix + key);
        return tmp;
    }

    public String getEnvLookupKey(String key) {
        PropString tmp = new PropString(DEFAULT_compressType);
        String k = tmp.setFromEnv(this.glob, this.nodeId, this.context, "dispatch", this.instanceName, this.envPrefix + key);
        if (k != null && k.length() > 0) {
            return k;
        }
        return key;
    }

    public final String getName() {
        return this.getLogId();
    }

    public final boolean isSameAddress(AddressBase other) {
        if (other.getType().equals(this.getType())) {
            String or = other.getRawAddress();
            if (or != null && or.length() > 0) {
                return or.equals(this.getRawAddress());
            }
            String oh = other.getBootstrapHostname();
            int op = other.getBootstrapPort();
            if (op > 0 && oh != null) {
                return op == this.getBootstrapPort() && oh.equals(this.getBootstrapHostname());
            }
        }
        return false;
    }

    private final void setRootTag(String rootTag) {
        this.rootTag = rootTag;
    }

    public String getSettings() {
        StringBuffer buf = new StringBuffer(126);
        buf.append("type=").append(this.getType()).append(" oneway=").append(this.oneway()).append(" burstMode.collectTime=").append(this.getCollectTime());
        return buf.toString();
    }

    public final void setType(String type) {
        if (type == null) {
            this.type.setValue(this.type.getDefaultValue(), 0);
        } else {
            this.type.setValue(type);
        }
    }

    public final void setVersion(String version) {
        this.version.setValue(version);
    }

    public String getLogId() {
        if (this.getRawAddress() != null && this.getRawAddress().length() > 0 && this.getRawAddress().length() < 50) {
            return this.getRawAddress();
        }
        return this.getBootstrapUrl();
    }

    public final void setBootstrapHostname(String host) {
        if (host == null) {
            this.bootstrapHostname.setValue(DEFAULT_compressType);
        } else {
            this.bootstrapHostname.setValue(host);
        }
    }

    public final void setDefaultBootstrapHostname(String host) {
        if (host == null) {
            this.bootstrapHostname.setValue(DEFAULT_compressType, 0);
        } else {
            this.bootstrapHostname.setValue(host, 0);
        }
    }

    public boolean hasBootstrapHostname() {
        return this.bootstrapHostname.getValue().length() > 0;
    }

    public final String getBootstrapHostname() {
        if (!this.hasBootstrapHostname()) {
            this.bootstrapHostname.setValue(this.glob.getLocalIP(), 0);
        }
        return this.bootstrapHostname.getValue();
    }

    public final String getBootstrapUrl() {
        return "xmlBlaster://" + this.getBootstrapHostname() + ":" + this.getBootstrapPort();
    }

    public final void setBootstrapPort(int bootstrapPort) {
        this.bootstrapPort.setValue(bootstrapPort);
    }

    public final int getBootstrapPort() {
        return this.bootstrapPort.getValue();
    }

    public final void setDefaultBootstrapPort(int defaultBootstrapPort) {
        if (this.bootstrapPort.isDefault()) {
            this.bootstrapPort.setValue(defaultBootstrapPort, 0);
        }
    }

    public final void setRawAddress(String rawAddress) {
        if (rawAddress == null) {
            rawAddress = DEFAULT_compressType;
        }
        this.rawAddress.setValue(rawAddress);
        if (this.log.TRACE) {
            this.log.trace(ME, "setRawAddress=" + this.rawAddress.getValue());
        }
    }

    public final String getRawAddress() {
        return this.rawAddress.getValue();
    }

    public final String getType() {
        return this.type.getValue();
    }

    public final String getVersion() {
        return this.version.getValue();
    }

    public final String getOnExhaust() {
        return "killSession";
    }

    public final boolean getOnExhaustKillSession() {
        return this.getOnExhaust().equalsIgnoreCase("killSession");
    }

    public final long getCollectTime() {
        return this.collectTime.getValue();
    }

    public void setCollectTime(long collectTime) {
        if (collectTime < 0L) {
            this.collectTime.setValue(0L);
        } else {
            this.collectTime.setValue(collectTime);
        }
    }

    public int getBurstModeMaxEntries() {
        return this.burstModeMaxEntries.getValue();
    }

    public void setBurstModeMaxEntries(int burstModeMaxEntries) {
        if (burstModeMaxEntries == 0) {
            this.log.warn(ME, "<burstMode maxEntries=" + burstModeMaxEntries + " is not supported and may cause strange behavior");
        } else if (burstModeMaxEntries < -1) {
            burstModeMaxEntries = -1;
        }
        this.burstModeMaxEntries.setValue(burstModeMaxEntries);
    }

    public long getBurstModeMaxBytes() {
        return this.burstModeMaxBytes.getValue();
    }

    public void setBurstModeMaxBytes(long burstModeMaxBytes) {
        if (burstModeMaxBytes == 0L) {
            this.log.warn(ME, "<burstMode maxBytes=" + burstModeMaxBytes + " is not supported and may cause strange behavior");
        } else if (burstModeMaxBytes < -1L) {
            burstModeMaxBytes = -1L;
        }
        this.burstModeMaxBytes.setValue(burstModeMaxBytes);
    }

    public final long getPingInterval() {
        return this.pingInterval.getValue();
    }

    public void setPingInterval(long pingInterval) {
        if (pingInterval <= 0L) {
            this.pingInterval.setValue(0L);
        } else if (pingInterval < 10L) {
            this.log.warn(ME, "pingInterval=" + pingInterval + " msec is too short, setting it to 10 millis");
            this.pingInterval.setValue(10L);
        } else {
            this.pingInterval.setValue(pingInterval);
        }
    }

    public final int getRetries() {
        return this.retries.getValue();
    }

    public void setRetries(int retries) {
        if (retries < -1) {
            this.retries.setValue(-1);
        } else {
            this.retries.setValue(retries);
        }
    }

    public final long getDelay() {
        return this.delay.getValue();
    }

    public void setDelay(long delay) {
        if (delay <= 0L) {
            this.delay.setValue(this.getDefaultDelay());
        } else {
            this.delay.setValue(delay);
        }
    }

    public final boolean oneway() {
        return this.oneway.getValue();
    }

    public void setOneway(boolean oneway) {
        this.oneway.setValue(oneway);
    }

    public void setPtpAllowed(boolean ptpAllowed) {
        this.ptpAllowed.setValue(ptpAllowed);
    }

    public final boolean isPtpAllowed() {
        return this.ptpAllowed.getValue();
    }

    public void setCompressType(String compressType) {
        if (compressType == null) {
            this.compressType.setValue(DEFAULT_compressType);
        }
        this.compressType.setValue(compressType);
        if (compressType.length() > 0) {
            this.log.warn(ME, "Compression of messages is not yet supported");
        }
    }

    public final String getSecretSessionId() {
        return this.sessionId.getValue();
    }

    public void setSecretSessionId(String sessionId) {
        this.sessionId.setValue(sessionId);
    }

    public final String getCompressType() {
        return this.compressType.getValue();
    }

    public long getMinSize() {
        return this.minSize.getValue();
    }

    public void setMinSize(long minSize) {
        this.minSize.setValue(minSize);
    }

    public void setDispatchPlugin(String dispatchPlugin) {
        this.dispatchPlugin.setValue(dispatchPlugin);
    }

    public String getDispatchPlugin() {
        return this.dispatchPlugin.getValue();
    }

    public final void startElement(String uri, String localName, String name, StringBuffer character, Attributes attrs) {
        String tmp = character.toString().trim();
        if (tmp.length() > 0) {
            this.setRawAddress(tmp);
        }
        character.setLength(0);
        if (name.equalsIgnoreCase(this.rootTag)) {
            if (attrs != null) {
                int len = attrs.getLength();
                int i = 0;
                while (i < len) {
                    String ll;
                    if (attrs.getQName(i).equalsIgnoreCase("type")) {
                        this.setType(attrs.getValue(i).trim());
                    } else if (attrs.getQName(i).equalsIgnoreCase("version")) {
                        this.setVersion(attrs.getValue(i).trim());
                    } else if (attrs.getQName(i).equalsIgnoreCase("bootstrapHostname")) {
                        this.setBootstrapHostname(attrs.getValue(i).trim());
                    } else if (attrs.getQName(i).equalsIgnoreCase("hostname")) {
                        this.setBootstrapHostname(attrs.getValue(i).trim());
                    } else if (attrs.getQName(i).equalsIgnoreCase("bootstrapPort")) {
                        ll = attrs.getValue(i).trim();
                        try {
                            this.setBootstrapPort(new Integer(ll));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(ME, "Wrong format of <" + this.rootTag + " bootstrapPort='" + ll + "'>, expected an integer number.");
                        }
                    } else if (attrs.getQName(i).equalsIgnoreCase("port")) {
                        ll = attrs.getValue(i).trim();
                        try {
                            this.setBootstrapPort(new Integer(ll));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(ME, "Wrong format of <" + this.rootTag + " port='" + ll + "'>, expected an integer number.");
                        }
                    } else if (attrs.getQName(i).equalsIgnoreCase("sessionId")) {
                        this.setSecretSessionId(attrs.getValue(i).trim());
                    } else if (attrs.getQName(i).equalsIgnoreCase("pingInterval")) {
                        ll = attrs.getValue(i).trim();
                        try {
                            this.setPingInterval(new Long(ll));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(ME, "Wrong format of <" + this.rootTag + " pingInterval='" + ll + "'>, expected a long in milliseconds.");
                        }
                    } else if (attrs.getQName(i).equalsIgnoreCase("retries")) {
                        ll = attrs.getValue(i).trim();
                        try {
                            this.setRetries(new Integer(ll));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(ME, "Wrong format of <" + this.rootTag + " retries='" + ll + "'>, expected an integer number.");
                        }
                    } else if (attrs.getQName(i).equalsIgnoreCase("delay")) {
                        ll = attrs.getValue(i).trim();
                        try {
                            this.setDelay(new Long(ll));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(ME, "Wrong format of <" + this.rootTag + " delay='" + ll + "'>, expected a long in milliseconds.");
                        }
                    } else if (attrs.getQName(i).equalsIgnoreCase("oneway")) {
                        this.setOneway(new Boolean(attrs.getValue(i).trim()));
                    } else if (attrs.getQName(i).equalsIgnoreCase("useForSubjectQueue")) {
                        this.useForSubjectQueue.setValue(new Boolean(attrs.getValue(i).trim()));
                    } else if (attrs.getQName(i).equalsIgnoreCase("dispatchPlugin")) {
                        this.dispatchPlugin.setValue(attrs.getValue(i).trim());
                    } else {
                        this.log.error(ME, "Ignoring unknown attribute " + attrs.getQName(i) + " in " + this.rootTag + " section.");
                    }
                    ++i;
                }
            }
            if (this.getType() == null) {
                this.log.error(ME, "Missing '" + this.rootTag + "' attribute 'type' in QoS");
                this.setType(DEFAULT_type);
            }
            if (this.getSecretSessionId() == null) {
                this.log.warn(ME, "Missing '" + this.rootTag + "' attribute 'sessionId' QoS");
            }
            return;
        }
        if (name.equalsIgnoreCase("burstMode")) {
            if (attrs != null) {
                int len = attrs.getLength();
                int ii = 0;
                ii = 0;
                while (ii < len) {
                    String ll;
                    if (attrs.getQName(ii).equalsIgnoreCase("collectTime")) {
                        ll = attrs.getValue(ii).trim();
                        try {
                            this.setCollectTime(new Long(ll));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(ME, "Wrong format of <burstMode collectTime='" + ll + "'>, expected a long in milliseconds, burst mode is switched off sync messages.");
                        }
                    } else if (attrs.getQName(ii).equalsIgnoreCase("maxEntries")) {
                        ll = attrs.getValue(ii).trim();
                        try {
                            this.setBurstModeMaxEntries(new Integer(ll));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(ME, "Wrong format of <burstMode maxEntries='" + ll + "'>, expected an integer number.");
                        }
                    } else if (attrs.getQName(ii).equalsIgnoreCase("maxBytes")) {
                        ll = attrs.getValue(ii).trim();
                        try {
                            this.setBurstModeMaxBytes(new Long(ll));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(ME, "Wrong format of <burstMode maxBytes='" + ll + "'>, expected a long in bytes.");
                        }
                    }
                    ++ii;
                }
            } else {
                this.log.error(ME, "Missing 'collectTime' attribute in login-qos <burstMode>");
            }
            return;
        }
        if (name.equalsIgnoreCase("compress")) {
            if (attrs != null) {
                int len = attrs.getLength();
                int ii = 0;
                while (ii < len) {
                    if (attrs.getQName(ii).equalsIgnoreCase("type")) {
                        this.setCompressType(attrs.getValue(ii).trim());
                    } else if (attrs.getQName(ii).equalsIgnoreCase("minSize")) {
                        String ll = attrs.getValue(ii).trim();
                        try {
                            this.setMinSize(new Long(ll));
                        }
                        catch (NumberFormatException e) {
                            this.log.error(ME, "Wrong format of <compress minSize='" + ll + "'>, expected a long in bytes, compress is switched off.");
                        }
                    }
                    ++ii;
                }
            } else {
                this.log.error(ME, "Missing 'type' attribute in qos <compress>");
            }
            return;
        }
        if (name.equalsIgnoreCase("ptp")) {
            this.setPtpAllowed(true);
            character.setLength(0);
            return;
        }
    }

    public final void endElement(String uri, String localName, String name, StringBuffer character) {
        if (name.equalsIgnoreCase(this.rootTag)) {
            String tmp = character.toString().trim();
            if (tmp.length() > 0) {
                this.setRawAddress(tmp);
            } else if (this.getRawAddress() == null) {
                this.log.error(ME, this.rootTag + " QoS contains no rawAddress data");
            }
        } else if (!name.equalsIgnoreCase("burstMode") && !name.equalsIgnoreCase("compress") && name.equalsIgnoreCase("ptp")) {
            String tmp = character.toString().trim();
            if (tmp.length() > 0) {
                this.setPtpAllowed(new Boolean(tmp));
            }
            return;
        }
        character.setLength(0);
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1200);
        if (extraOffset == null) {
            extraOffset = DEFAULT_compressType;
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<").append(this.rootTag).append(" type='").append(this.getType()).append("'");
        if (this.version.isModified()) {
            sb.append(" version='").append(this.getVersion()).append("'");
        }
        if (this.bootstrapHostname.isModified()) {
            sb.append(" bootstrapHostname='").append(this.getBootstrapHostname()).append("'");
        }
        if (this.bootstrapPort.isModified()) {
            sb.append(" bootstrapPort='").append(this.getBootstrapPort()).append("'");
        }
        if (this.sessionId.isModified()) {
            sb.append(" sessionId='").append(this.getSecretSessionId()).append("'");
        }
        if (this.pingInterval.isModified()) {
            sb.append(" pingInterval='").append(this.getPingInterval()).append("'");
        }
        if (this.retries.isModified()) {
            sb.append(" retries='").append(this.getRetries()).append("'");
        }
        if (this.delay.isModified()) {
            sb.append(" delay='").append(this.getDelay()).append("'");
        }
        if (this.oneway.isModified()) {
            sb.append(" oneway='").append(this.oneway()).append("'");
        }
        if (this.useForSubjectQueue.isModified()) {
            sb.append(" useForSubjectQueue='").append(this.useForSubjectQueue.getValue()).append("'");
        }
        if (this.dispatchPlugin.isModified()) {
            sb.append(" dispatchPlugin='").append(this.dispatchPlugin.getValue()).append("'");
        }
        sb.append(">");
        sb.append(offset).append(" ").append(this.getRawAddress());
        if (this.collectTime.isModified() || this.burstModeMaxEntries.isModified() || this.burstModeMaxBytes.isModified()) {
            sb.append(offset).append(" ").append("<burstMode");
            if (this.collectTime.isModified()) {
                sb.append(" collectTime='").append(this.getCollectTime()).append("'");
            }
            if (this.burstModeMaxEntries.isModified()) {
                sb.append(" maxEntries='").append(this.getBurstModeMaxEntries()).append("'");
            }
            if (this.burstModeMaxBytes.isModified()) {
                sb.append(" maxBytes='").append(this.getBurstModeMaxBytes()).append("'");
            }
            sb.append("/>");
        }
        if (this.compressType.isModified()) {
            sb.append(offset).append(" ").append("<compress type='").append(this.getCompressType()).append("' minSize='").append(this.getMinSize()).append("'/>");
        }
        if (this.ptpAllowed.isModified()) {
            if (this.ptpAllowed.getValue()) {
                sb.append(offset).append(" ").append("<ptp/>");
            } else {
                sb.append(offset).append(" ").append("<ptp>").append(this.ptpAllowed).append("</ptp>");
            }
        }
        sb.append(offset).append("</").append(this.rootTag).append(">");
        return sb.toString();
    }

    public String usage() {
        String text = DEFAULT_compressType;
        text = text + "   -dispatch/" + this.instanceName + "/protocol\n";
        text = text + "                       Protocol to use [IOR]\n";
        text = text + "   -dispatch/" + this.instanceName + "/pingInterval\n";
        text = text + "                       Pinging every given milliseconds [" + this.getDefaultPingInterval() + "]\n";
        text = text + "   -dispatch/" + this.instanceName + "/retries\n";
        text = text + "                       How often to retry if connection fails (-1 is forever) [" + this.getDefaultRetries() + "]\n";
        text = text + "   -dispatch/" + this.instanceName + "/delay\n";
        text = text + "                       Delay between connection retries in milliseconds [" + this.getDefaultDelay() + "]\n";
        text = text + "                       A delay value > 0 switches fails save mode on, 0 switches it off\n";
        return text;
    }
}

