/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos.address;

import java.util.Vector;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.qos.address.AddressBase;

public class CallbackAddress
extends AddressBase {
    private static final String ME = "CallbackAddress";

    public CallbackAddress(Global glob) {
        super(glob, "callback");
        this.instanceName = "callback";
        this.initialize();
    }

    public CallbackAddress(Global glob, String type) {
        super(glob, "callback");
        this.instanceName = "callback";
        this.setType(type);
        this.initialize();
    }

    public int getDefaultRetries() {
        return 0;
    }

    public long getDefaultDelay() {
        return 60000L;
    }

    public long getDefaultPingInterval() {
        return 60000L;
    }

    public CallbackAddress(Global glob, String type, String nodeId) {
        super(glob, "callback");
        this.nodeId = nodeId;
        this.setType(type);
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
    }

    public boolean useForSubjectQueue() {
        return this.useForSubjectQueue.getValue();
    }

    public void useForSubjectQueue(boolean useForSubjectQueue) {
        this.useForSubjectQueue.setValue(useForSubjectQueue);
    }

    public void setSecretCbSessionId(String cbSessionId) {
        this.setSecretSessionId(cbSessionId);
    }

    public String toString() {
        return this.getRawAddress();
    }

    public final String usage() {
        String text = "\nControl xmlBlaster server side callback (if we install a local callback server):\n";
        text = text + super.usage();
        text = text + "   -dispatch/" + this.instanceName + "/sessionId\n";
        text = text + "                       The session ID which is passed to our callback server's update() method.\n";
        text = text + "   -dispatch/" + this.instanceName + "/burstMode/collectTime\n";
        text = text + "                       Number of milliseconds xmlBlaster shall collect\n";
        text = text + "                       callback messages [0].\n";
        text = text + "                       The burst mode allows performance tuning, try set it to 200.\n";
        text = text + "   -dispatch/" + this.instanceName + "/burstMode/maxEntries\n";
        text = text + "                       The maximum bulk size of a callback invocation [-1]\n";
        text = text + "                       -1 takes all entries available in the callback RAM queue\n";
        text = text + "                       possibly limited by maxBytes\n";
        text = text + "   -dispatch/" + this.instanceName + "/burstMode/maxBytes\n";
        text = text + "                       The maximum bulk size of a callback invocation [-1]\n";
        text = text + "                       -1L takes all entries available in the callback RAM queue\n";
        text = text + "                       possibly limited by maxEntries\n";
        text = text + "   -dispatch/" + this.instanceName + "/oneway\n";
        text = text + "                       Shall the update() messages be send oneway (no\n";
        text = text + "                       application level ACK) [false]\n";
        text = text + "   -dispatch/" + this.instanceName + "/ptpAllowed\n";
        text = text + "                       PtP messages wanted? false prevents spamming [true]\n";
        return text;
    }

    public static void main(String[] argsDefault) {
        try {
            Global glob = new Global(argsDefault);
            CallbackAddress a = new CallbackAddress(glob);
            a.setType("SOCKET");
            a.setRawAddress("127.0.0.1:7600");
            a.setCollectTime(12345L);
            a.setPingInterval(54321L);
            a.setRetries(17);
            a.setDelay(7890L);
            a.setOneway(true);
            a.setSecretSessionId("0x4546hwi89");
            System.out.println(a.toXml());
            String nodeId = "heron";
            Vector<String> vec = new Vector<String>();
            vec.addElement("-/node/" + nodeId + "/dispatch/callback/sessionId");
            vec.addElement("OK");
            vec.addElement("-dispatch/callback/sessionId");
            vec.addElement("ERROR");
            vec.addElement("-dispatch/callback/pingInterval");
            vec.addElement("8888");
            vec.addElement("-/node/" + nodeId + " /dispatch/callback/delay");
            vec.addElement("8888");
            String[] args = vec.toArray(new String[0]);
            Global glob2 = new Global(args);
            CallbackAddress a2 = new CallbackAddress(glob2, "RMI", nodeId);
            System.out.println(a2.toXml());
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("TestFailed" + e.toString());
        }
    }
}

