/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos.address;

import java.io.Serializable;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;

public class Destination
implements Serializable {
    private String ME = "Destination";
    private SessionName destination = null;
    private String queryStr;
    private String queryType = "EXACT";
    private boolean DEFAULT_forceQueuing;
    private boolean forceQueuing = this.DEFAULT_forceQueuing = false;

    public Destination() {
    }

    public Destination(SessionName address) {
        this(null, address);
    }

    public Destination(Global glob, SessionName address) {
        this.setDestination(address);
    }

    public Destination(String address, String queryType) {
        this.setQueryType(queryType);
        if (this.isXPathQuery()) {
            this.queryStr = address;
            Global.instance().getLog("core").error(this.ME, "Query type " + queryType + " is not implemented");
        } else {
            this.setDestination(new SessionName(Global.instance(), address));
        }
    }

    public boolean isXPathQuery() {
        return this.queryType.equals("XPATH");
    }

    public boolean isExactAddress() {
        return this.queryType.equals("EXACT");
    }

    public boolean forceQueuing() {
        return this.forceQueuing;
    }

    public void forceQueuing(boolean forceQueuing) {
        this.forceQueuing = forceQueuing;
    }

    public final void setDestination(SessionName destination) {
        this.destination = destination;
    }

    public final SessionName getDestination() {
        return this.destination;
    }

    public final void setQueryType(String queryType) {
        if (queryType.equalsIgnoreCase("EXACT")) {
            this.queryType = queryType;
        } else if (queryType.equalsIgnoreCase("XPATH")) {
            Global.instance().getLog("core").error(this.ME, "Query type " + queryType + " is not implemented");
        } else {
            throw new IllegalArgumentException(this.ME + ": Query type " + queryType + " is not implemented");
        }
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<destination");
        if (!"EXACT".equals(this.queryType)) {
            sb.append(" queryType='").append(this.queryType).append("'");
        }
        if (this.forceQueuing != this.DEFAULT_forceQueuing) {
            sb.append(" forceQueuing='").append(this.forceQueuing).append("'");
        }
        sb.append(">").append(this.destination).append("</destination>");
        return sb.toString();
    }

    public static void main(String[] args) {
        Destination dest = new Destination();
        dest.setDestination(new SessionName(Global.instance(), "Johann"));
        dest.forceQueuing(true);
        System.out.println(dest.toXml());
    }
}

