/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos.storage;

import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;

public class CbQueueProperty
extends QueuePropertyBase {
    private static final String ME = "CbQueueProperty";
    private final LogChannel log;

    public CbQueueProperty(Global glob, String relating, String nodeId) {
        super(glob, nodeId);
        this.log = glob.getLog("dispatch");
        String rel = relating == null ? "callback" : relating;
        this.setRelating(rel);
        super.initialize(rel);
        if (this.log.TRACE) {
            this.log.trace(ME, "Created CbQueueProperty " + rel + " " + this.nodeId);
        }
    }

    public final String getSettings() {
        StringBuffer buf = new StringBuffer(256);
        buf.append("type=").append(this.getType()).append(" onOverflow=").append(this.getOnOverflow()).append(" onFailure=").append(this.getOnFailure()).append(" maxEntries=").append(this.getMaxEntries());
        if (this.getCurrentCallbackAddress() != null) {
            buf.append(" ").append(this.getCurrentCallbackAddress().getSettings());
        }
        return buf.toString();
    }

    public final void setRelating(String relating) {
        if (relating == null) {
            this.relating = "callback";
            return;
        }
        if ("callback".equals(relating = relating.toLowerCase())) {
            this.relating = "callback";
        } else if ("subject".equals(relating)) {
            this.relating = "subject";
        } else {
            this.log.warn(ME, "setRelating: The queue relating attribute is invalid '" + relating + "', setting to session scope");
            this.relating = "callback";
        }
    }

    public final boolean isSubjectRelated() {
        return "subject".equals(this.getRelating());
    }

    public final boolean isSessionRelated() {
        return "callback".equals(this.getRelating());
    }

    public final boolean onOverflowDeadMessage() {
        return "deadMessage".equalsIgnoreCase(this.getOnOverflow());
    }

    public void setCallbackAddress(CallbackAddress address) {
        this.addressArr = new CallbackAddress[1];
        this.addressArr[0] = address;
    }

    public void setCallbackAddresses(CallbackAddress[] addresses) {
        this.addressArr = addresses;
    }

    public CallbackAddress[] getCallbackAddresses() {
        CallbackAddress[] cba = new CallbackAddress[this.addressArr.length];
        int ii = 0;
        while (ii < this.addressArr.length) {
            cba[ii] = (CallbackAddress)this.addressArr[ii];
            ++ii;
        }
        return cba;
    }

    public CallbackAddress getCurrentCallbackAddress() {
        if (this.addressArr.length > 1) {
            this.log.error(ME, "We have " + this.addressArr.length + " callback addresses, using the first only");
        }
        if (this.addressArr.length > 0) {
            return (CallbackAddress)this.addressArr[0];
        }
        return null;
    }

    public static void main(String[] args) {
        CbQueueProperty prop = new CbQueueProperty(new Global(args), null, null);
        System.out.println(prop.toXml());
        CallbackAddress adr = new CallbackAddress(new Global(args), "EMAIL");
        adr.setRawAddress("et@mars.sun");
        prop.setCallbackAddress(adr);
        System.out.println(prop.toXml());
    }
}

