/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos.storage;

import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;

public class ClientQueueProperty
extends QueuePropertyBase {
    private static final String ME = "ClientQueueProperty";

    public ClientQueueProperty(Global glob, String nodeId) {
        super(glob, nodeId);
        this.setRelating("connection");
        super.initialize("connection");
        this.maxEntries.setDefaultValue(Integer.MAX_VALUE);
        this.maxBytes.setDefaultValue(Integer.MAX_VALUE);
    }

    public final String getSettings() {
        StringBuffer buf = new StringBuffer(256);
        buf.append("type=").append(this.getType()).append(" onOverflow=").append(this.getOnOverflow()).append(" onFailure=").append(this.getOnFailure()).append(" maxEntries=").append(this.getMaxEntries());
        if (this.getCurrentAddress() != null) {
            buf.append(" ").append(this.getCurrentAddress().getSettings());
        }
        return buf.toString();
    }

    public void setAddress(Address address) {
        this.addressArr = new Address[1];
        this.addressArr[0] = address;
    }

    public void setAddresses(Address[] addresses) {
        this.addressArr = addresses;
    }

    public Address getCurrentAddress() {
        if (this.addressArr.length > 0) {
            return (Address)this.addressArr[0];
        }
        return null;
    }

    public static void main(String[] args) {
        ClientQueueProperty prop = new ClientQueueProperty(new Global(args), null);
        System.out.println(prop.toXml());
        Address adr = new Address(new Global(args), "EMAIL");
        adr.setRawAddress("et@mars.sun");
        prop.setAddress(adr);
        System.out.println(prop.toXml());
    }
}

