/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos.storage;

import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;

public class HistoryQueueProperty
extends QueuePropertyBase {
    private static final String ME = "HistoryQueueProperty";
    private final LogChannel log;

    public HistoryQueueProperty(Global glob, String nodeId) {
        super(glob, nodeId);
        this.log = glob.getLog("core");
        this.maxEntries.setDefaultValue(10L);
        this.maxEntriesCache.setDefaultValue(10L);
        this.setRelating("history");
        super.initialize("history");
    }

    public final String getSettings() {
        StringBuffer buf = new StringBuffer(256);
        buf.append("type=").append(this.getType()).append(" onOverflow=").append(this.getOnOverflow()).append(" onFailure=").append(this.getOnFailure()).append(" maxEntries=").append(this.getMaxEntries());
        return buf.toString();
    }

    public final boolean onOverflowDeadMessage() {
        return "deadMessage".equalsIgnoreCase(this.getOnOverflow());
    }

    public String usage(String headerline) {
        String prefix = this.getPrefix();
        String text = "";
        text = text + "\n" + headerline + "\n";
        text = text + "   -" + prefix + "debug    Sets a debug flag on the queue [false].\n";
        text = text + "                       Currently used for consistency asserts on jdbc queue.\n";
        text = text + "   -" + prefix + "maxEntries\n";
        text = text + "                       The maximum allowed number of messages [" + this.maxEntries.getDefaultValue() + "].\n";
        text = text + "   -" + prefix + "maxEntriesCache\n";
        text = text + "                       The maximum allowed number of messages in the cache [" + this.maxEntriesCache.getDefaultValue() + "].\n";
        text = text + "   -" + prefix + "maxBytes\n";
        text = text + "                       The maximum size in bytes of the storage [" + this.maxBytes.getDefaultValue() + "].\n";
        text = text + "   -" + prefix + "maxBytesCache.\n";
        text = text + "                       The maximum size in bytes in the cache [" + this.maxBytesCache.getDefaultValue() + "].\n";
        text = text + "   -" + prefix + "type\n";
        text = text + "                       The plugin type [" + this.type.getDefaultValue() + "]\n";
        text = text + "   -" + prefix + "version\n";
        text = text + "                       The plugin version [" + this.version.getDefaultValue() + "]\n";
        text = text + "   -" + prefix + "defaultPlugin\n";
        text = text + "                       The plugin type,version (short form) [" + this.type.getDefaultValue() + "," + this.version.getDefaultValue() + "]\n";
        return text;
    }

    public static void main(String[] args) {
        HistoryQueueProperty prop = new HistoryQueueProperty(new Global(args), null);
        System.out.println(prop.toXml());
    }
}

