/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.qos.storage;

import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.property.PropBoolean;
import org.xmlBlaster.util.property.PropLong;
import org.xmlBlaster.util.property.PropString;
import org.xmlBlaster.util.qos.address.AddressBase;

public abstract class QueuePropertyBase
implements Cloneable {
    private static final String ME = "QueuePropertyBase";
    protected final Global glob;
    protected LogChannel log;
    private String propertyPrefix = "";
    public static final String DEFAULT_type = "CACHE";
    protected PropString type = new PropString("CACHE");
    public static final String DEFAULT_version = "1.0";
    protected PropString version = new PropString("1.0");
    public static final long DEFAULT_maxEntriesCacheDefault = 1000L;
    protected long maxEntriesCacheDefault = 1000L;
    public static final long DEFAULT_bytesDefault = 0xA00000L;
    protected long maxBytesDefault = 0xA00000L;
    public static final long DEFAULT_bytesCacheDefault = 0x200000L;
    protected long c = 0x200000L;
    public static final double DEFAULT_storeSwapLevelRatio = 0.7;
    public static final double DEFAULT_storeSwapBytesRatio = 0.25;
    public static final double DEFAULT_reloadSwapLevelRatio = 0.3;
    public static final double DEFAULT_reloadSwapBytesRatio = 0.25;
    protected String relating = "callback";
    public long DEFAULT_maxEntries = 1000L;
    protected PropLong maxEntries = new PropLong(this.DEFAULT_maxEntries);
    protected PropLong maxBytes = new PropLong(this.maxBytesDefault);
    protected PropLong maxEntriesCache = new PropLong(this.maxEntriesCacheDefault);
    protected PropLong maxBytesCache = new PropLong(this.c);
    protected long storeSwapLevel = (long)(0.7 * (double)this.maxBytesCache.getValue());
    protected long storeSwapBytes = (long)(0.25 * (double)this.maxBytesCache.getValue());
    protected long reloadSwapLevel = (long)(0.3 * (double)this.maxBytesCache.getValue());
    protected long reloadSwapBytes = (long)(0.25 * (double)this.maxBytesCache.getValue());
    public static final String DEFAULT_onOverflow = "deadMessage";
    protected PropString onOverflow = new PropString("deadMessage");
    public static final String DEFAULT_onFailure = "deadMessage";
    protected PropString onFailure = new PropString("deadMessage");
    protected AddressBase[] addressArr = new AddressBase[0];
    protected String nodeId = null;
    protected PropBoolean debug = new PropBoolean(false);

    public QueuePropertyBase(Global glob, String nodeId) {
        if (glob == null) {
            Thread.dumpStack();
            this.glob = new Global();
        } else {
            this.glob = glob;
        }
        this.log = glob.getLog("core");
        this.nodeId = nodeId == null ? glob.getStrippedId() : nodeId;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public String getPrefix() {
        return this.getRootTagName() + "/" + (this.relating != null && this.relating.length() > 0 ? this.relating + "/" : "");
    }

    public String getPropName(String token) {
        return "-" + this.getPrefix() + token;
    }

    protected void initialize(String relating) {
        this.relating = relating == null ? "" : relating;
        String prefix = this.getPrefix();
        this.log = this.glob.getLog(this.getRootTagName());
        String context = null;
        String propName = null;
        try {
            PropString defaultPlugin = new PropString(this.type.getDefaultValue() + "," + this.version.getDefaultValue());
            propName = defaultPlugin.setFromEnv(this.glob, this.nodeId, context, this.getRootTagName(), relating, "defaultPlugin");
            if (this.log.TRACE) {
                this.log.trace(ME, "Lookup of nodeId=" + this.nodeId + " context=" + context + " getRootTagName=" + this.getRootTagName() + " relating=" + relating + " propName=" + propName + " defaultValue=" + defaultPlugin.getValue());
            }
            PluginInfo pluginInfo = new PluginInfo(this.glob, null, defaultPlugin.getValue());
            if (defaultPlugin.isModified()) {
                this.setType(pluginInfo.getType());
                this.setVersion(pluginInfo.getVersion());
            } else {
                this.type.setDefaultValue(pluginInfo.getType());
                this.version.setDefaultValue(pluginInfo.getVersion());
            }
        }
        catch (XmlBlasterException ex) {
            this.log.error(ME, "initialize: could not set the default plugin to what indicated by " + propName);
        }
        this.maxEntries.setFromEnv(this.glob, this.nodeId, context, this.getRootTagName(), relating, "maxEntries");
        this.maxEntriesCache.setFromEnv(this.glob, this.nodeId, context, this.getRootTagName(), relating, "maxEntriesCache");
        this.maxBytes.setFromEnv(this.glob, this.nodeId, context, this.getRootTagName(), relating, "maxBytes");
        this.maxBytesCache.setFromEnv(this.glob, this.nodeId, context, this.getRootTagName(), relating, "maxBytesCache");
        this.type.setFromEnv(this.glob, this.nodeId, context, this.getRootTagName(), relating, "type", false);
        this.version.setFromEnv(this.glob, this.nodeId, context, this.getRootTagName(), relating, "version", false);
        this.onOverflow.setFromEnv(this.glob, this.nodeId, context, this.getRootTagName(), relating, "onOverflow");
        this.onFailure.setFromEnv(this.glob, this.nodeId, context, this.getRootTagName(), relating, "onFailure");
        this.debug.setFromEnv(this.glob, this.nodeId, context, this.getRootTagName(), relating, "debug");
        this.setStoreSwapLevel(this.glob.getProperty().get(prefix + "storeSwapLevel", (long)(0.7 * (double)this.maxBytesCache.getValue())));
        this.setStoreSwapBytes(this.glob.getProperty().get(prefix + "storeSwapBytes", (long)(0.25 * (double)this.maxBytesCache.getValue())));
        this.setReloadSwapLevel(this.glob.getProperty().get(prefix + "reloadSwapLevel", (long)(0.3 * (double)this.maxBytesCache.getValue())));
        this.setReloadSwapBytes(this.glob.getProperty().get(prefix + "reloadSwapBytes", (long)(0.25 * (double)this.maxBytesCache.getValue())));
        if (this.nodeId != null) {
            this.setStoreSwapLevel(this.glob.getProperty().get(prefix + "storeSwapLevel[" + this.nodeId + "]", this.getStoreSwapLevel()));
            this.setStoreSwapBytes(this.glob.getProperty().get(prefix + "storeSwapBytes[" + this.nodeId + "]", this.getStoreSwapBytes()));
            this.setReloadSwapLevel(this.glob.getProperty().get(prefix + "reloadSwapLevel[" + this.nodeId + "]", this.getReloadSwapLevel()));
            this.setReloadSwapBytes(this.glob.getProperty().get(prefix + "reloadSwapBytes[" + this.nodeId + "]", this.getReloadSwapBytes()));
        }
        this.checkConsistency();
        if (this.log.TRACE) {
            this.log.trace(ME, "Initialized: " + this.toXml());
        }
    }

    public void setRelating(String relating) {
        if ("callback".equalsIgnoreCase(relating)) {
            this.relating = "callback";
        } else if ("subject".equalsIgnoreCase(relating)) {
            this.relating = "subject";
        } else if ("connection".equalsIgnoreCase(relating)) {
            this.relating = "connection";
        } else if ("history".equalsIgnoreCase(relating)) {
            this.relating = "history";
        } else if ("msgUnitStore".equalsIgnoreCase(relating)) {
            this.relating = "msgUnitStore";
        } else if ("topicStore".equalsIgnoreCase(relating)) {
            this.relating = "topicStore";
        } else if ("subscribe".equalsIgnoreCase(relating)) {
            this.relating = "subscribe";
        } else if ("session".equalsIgnoreCase(relating)) {
            this.relating = "session";
        } else {
            this.log.warn(ME, "Ignoring relating='" + relating + "'");
            Thread.dumpStack();
        }
    }

    public final String getRelating() {
        return this.relating;
    }

    public final long getMaxEntries() {
        return this.maxEntries.getValue();
    }

    public final void setMaxEntries(long maxEntries) {
        this.setMaxEntriesUnchecked(maxEntries);
    }

    private final void setMaxEntriesUnchecked(long maxEntries) {
        this.maxEntries.setValue(maxEntries);
    }

    public final String getType() {
        return this.type.getValue();
    }

    public final void setType(String type) {
        this.type.setValue(type);
    }

    public final String getVersion() {
        return this.version.getValue();
    }

    public final void setVersion(String version) {
        this.version.setValue(version);
    }

    public final String getTypeVersion() {
        return this.getType() + "," + this.getVersion();
    }

    public final long getMaxEntriesCache() {
        return this.maxEntriesCache.getValue();
    }

    public final void setMaxEntriesCache(long maxEntriesCache) {
        this.maxEntriesCache.setValue(maxEntriesCache);
    }

    private final void setMaxEntriesCacheUnchecked(long maxEntriesCache) {
        this.maxEntriesCache.setValue(maxEntriesCache);
    }

    public final long getMaxBytes() {
        return this.maxBytes.getValue();
    }

    public final void setMaxBytes(long maxBytes) {
        this.maxBytes.setValue(maxBytes);
    }

    private final void setMaxBytesUnchecked(long maxBytes) {
        this.maxBytes.setValue(maxBytes);
    }

    public final long getMaxBytesCache() {
        return this.maxBytesCache.getValue();
    }

    public final long getStoreSwapLevel() {
        return this.storeSwapLevel;
    }

    public final void setStoreSwapLevel(long storeSwapLevel) {
        this.storeSwapLevel = storeSwapLevel;
    }

    public final long getStoreSwapBytes() {
        return this.storeSwapBytes;
    }

    public final void setStoreSwapBytes(long storeSwapBytes) {
        this.storeSwapBytes = storeSwapBytes;
    }

    public final long getReloadSwapLevel() {
        return this.reloadSwapLevel;
    }

    public final void setReloadSwapLevel(long reloadSwapLevel) {
        this.reloadSwapLevel = reloadSwapLevel;
    }

    public final long getReloadSwapBytes() {
        return this.reloadSwapBytes;
    }

    public final void setReloadSwapBytes(long reloadSwapBytes) {
        this.reloadSwapBytes = reloadSwapBytes;
    }

    public final void setMaxBytesCache(long maxBytesCache) {
        this.maxBytesCache.setValue(maxBytesCache);
    }

    private final void setMaxBytesCacheUnchecked(long maxBytesCache) {
        this.maxBytesCache.setValue(maxBytesCache);
    }

    public final void setOnOverflow(String onOverflow) {
        if ("deadMessage".equalsIgnoreCase(onOverflow)) {
            this.onOverflow.setValue("deadMessage");
        } else if ("discardOldest".equalsIgnoreCase(onOverflow)) {
            this.onOverflow.setValue("discardOldest");
            this.onOverflow.setValue("deadMessage");
            this.log.error(ME, this.getRootTagName() + " onOverflow='" + "discardOldest" + "' is not implemented, switching to " + this.onOverflow + " mode");
        } else {
            this.onOverflow.setValue("deadMessage");
            this.log.warn(ME, "The " + this.getRootTagName() + " onOverflow attribute is invalid '" + onOverflow + "', setting to '" + this.onOverflow + "'");
        }
    }

    public final String getOnOverflow() {
        return this.onOverflow.getValue();
    }

    public final void setOnFailure(String onFailure) {
        if ("deadMessage".equalsIgnoreCase(onFailure)) {
            this.onFailure.setValue("deadMessage");
        } else {
            this.log.warn(ME, "The " + this.getRootTagName() + " onFailure attribute is invalid '" + onFailure + "', setting to 'deadMessage'");
            this.onFailure.setValue("deadMessage");
        }
    }

    public final String getOnFailure() {
        return this.onFailure.getValue();
    }

    public final boolean onFailureDeadMessage() {
        return "deadMessage".equalsIgnoreCase(this.getOnFailure());
    }

    public AddressBase[] getAddresses() {
        return this.addressArr;
    }

    public final void startElement(String uri, String localName, String name, Attributes attrs) {
        if (attrs != null) {
            int len = attrs.getLength();
            int ii = 0;
            ii = 0;
            while (ii < len) {
                String tmp;
                if (attrs.getQName(ii).equalsIgnoreCase("relating")) {
                    this.setRelating(attrs.getValue(ii).trim());
                } else if (attrs.getQName(ii).equalsIgnoreCase("maxEntries")) {
                    tmp = attrs.getValue(ii).trim();
                    try {
                        this.setMaxEntriesUnchecked(new Long(tmp));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(ME, "Wrong format of <" + this.getRootTagName() + " maxEntries='" + tmp + "'>, expected a long, using default.");
                    }
                } else if (attrs.getQName(ii).equalsIgnoreCase("type")) {
                    this.setType(attrs.getValue(ii).trim());
                } else if (attrs.getQName(ii).equalsIgnoreCase("debug")) {
                    tmp = attrs.getValue(ii).trim();
                    try {
                        this.setDebug(new Boolean(tmp));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(ME, "Wrong format of <" + this.getRootTagName() + " debug='" + tmp + "'>, expected a boolean, using default.");
                    }
                } else if (attrs.getQName(ii).equalsIgnoreCase("version")) {
                    this.setVersion(attrs.getValue(ii).trim());
                } else if (attrs.getQName(ii).equalsIgnoreCase("maxEntriesCache")) {
                    tmp = attrs.getValue(ii).trim();
                    try {
                        this.setMaxEntriesCacheUnchecked(new Long(tmp));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(ME, "Wrong format of <" + this.getRootTagName() + " maxEntriesCache='" + tmp + "'>, expected an long, using default.");
                    }
                } else if (attrs.getQName(ii).equalsIgnoreCase("maxBytes")) {
                    tmp = attrs.getValue(ii).trim();
                    try {
                        this.setMaxBytesUnchecked(new Long(tmp));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(ME, "Wrong format of <" + this.getRootTagName() + " maxBytes='" + tmp + "'>, expected a long in bytes, using default.");
                    }
                } else if (attrs.getQName(ii).equalsIgnoreCase("maxBytesCache")) {
                    tmp = attrs.getValue(ii).trim();
                    try {
                        this.setMaxBytesCacheUnchecked(new Long(tmp));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(ME, "Wrong format of <" + this.getRootTagName() + " maxBytesCache='" + tmp + "'>, expected a long in bytes, using default.");
                    }
                } else if (attrs.getQName(ii).equalsIgnoreCase("storeSwapLevel")) {
                    tmp = attrs.getValue(ii).trim();
                    try {
                        this.setStoreSwapLevel(new Long(tmp));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(ME, "Wrong format of <" + this.getRootTagName() + " storeSwapLevel='" + tmp + "'>, expected a long in bytes, using default.");
                    }
                } else if (attrs.getQName(ii).equalsIgnoreCase("storeSwapBytes")) {
                    tmp = attrs.getValue(ii).trim();
                    try {
                        this.setStoreSwapBytes(new Long(tmp));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(ME, "Wrong format of <" + this.getRootTagName() + " storeSwapBytes='" + tmp + "'>, expected a long in bytes, using default.");
                    }
                } else if (attrs.getQName(ii).equalsIgnoreCase("reloadSwapLevel")) {
                    tmp = attrs.getValue(ii).trim();
                    try {
                        this.setReloadSwapLevel(new Long(tmp));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(ME, "Wrong format of <" + this.getRootTagName() + " reloadSwapLevel='" + tmp + "'>, expected a long in bytes, using default.");
                    }
                } else if (attrs.getQName(ii).equalsIgnoreCase("reloadSwapBytes")) {
                    tmp = attrs.getValue(ii).trim();
                    try {
                        this.setReloadSwapBytes(new Long(tmp));
                    }
                    catch (NumberFormatException e) {
                        this.log.error(ME, "Wrong format of <" + this.getRootTagName() + " reloadSwapBytes='" + tmp + "'>, expected a long in bytes, using default.");
                    }
                } else if (attrs.getQName(ii).equalsIgnoreCase("onOverflow")) {
                    this.setOnOverflow(attrs.getValue(ii).trim());
                } else if (attrs.getQName(ii).equalsIgnoreCase("onFailure")) {
                    this.setOnFailure(attrs.getValue(ii).trim());
                } else {
                    this.log.warn(ME, "Ignoring unknown attribute '" + attrs.getQName(ii) + "' in connect QoS <" + this.getRootTagName() + ">");
                }
                ++ii;
            }
        } else {
            this.log.warn(ME, "Missing 'relating' attribute in connect QoS <" + this.getRootTagName() + ">");
        }
        this.checkConsistency();
    }

    public String usage() {
        return this.usage("Control the " + this.getRootTagName() + "/" + this.relating + " storage properties:");
    }

    public String getRootTagName() {
        return "queue";
    }

    public String usage(String headerline) {
        String prefix = this.getPrefix();
        String text = "";
        text = text + "\n" + headerline + "\n";
        text = text + "   -" + prefix + "debug    Sets a debug flag on the queue [false].\n";
        text = text + "                       Currently used for consistency asserts on jdbc queue.\n";
        text = text + "   -" + prefix + "maxEntries\n";
        text = text + "                       The maximum allowed number of messages [" + this.maxEntries.getDefaultValue() + "].\n";
        text = text + "   -" + prefix + "maxEntriesCache\n";
        text = text + "                       The maximum allowed number of messages in the cache [" + this.maxEntriesCache.getDefaultValue() + "].\n";
        text = text + "   -" + prefix + "maxBytes\n";
        text = text + "                       The maximum size in bytes of the storage [" + this.maxBytes.getDefaultValue() + "].\n";
        text = text + "   -" + prefix + "maxBytesCache.\n";
        text = text + "                       The maximum size in bytes in the cache [" + this.maxBytesCache.getDefaultValue() + "].\n";
        text = text + "   -" + prefix + "onOverflow\n";
        text = text + "                       What happens if storage is full [" + this.onOverflow.getDefaultValue() + "]\n";
        text = text + "   -" + prefix + "onFailure\n";
        text = text + "                       Error handling when storage failed [" + this.onFailure.getDefaultValue() + "]\n";
        text = text + "   -" + prefix + "type\n";
        text = text + "                       The plugin type [" + this.type.getDefaultValue() + "]\n";
        text = text + "   -" + prefix + "version\n";
        text = text + "                       The plugin version [" + this.version.getDefaultValue() + "]\n";
        text = text + "   -" + prefix + "defaultPlugin\n";
        text = text + "                       The plugin type,version (short form) [" + this.type.getDefaultValue() + "," + this.version.getDefaultValue() + "]\n";
        return text;
    }

    public final void checkConsistency() {
        if (this.getMaxEntriesCache() > this.getMaxEntries()) {
            this.log.warn(ME, this.relating + " maxEntriesCache=" + this.getMaxEntriesCache() + " is bigger than maxEntries=" + this.getMaxEntries() + ", we reduce maxEntriesCache to maxEntries and continue.");
            this.maxEntriesCache.setValue(this.getMaxEntries());
        }
        if (this.getMaxBytesCache() > this.getMaxBytes()) {
            this.log.warn(ME, this.relating + " maxBytesCache=" + this.getMaxBytesCache() + " is bigger than maxBytes=" + this.getMaxBytes() + ", we reduce maxBytesCache to maxBytes and continue.");
            this.maxBytesCache.setValue(this.getMaxBytes());
        }
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        this.checkConsistency();
        sb.append(offset).append("<").append(this.getRootTagName());
        if (this.debug.isModified()) {
            sb.append(" debug='").append(this.getDebug()).append("'");
        }
        sb.append(" relating='").append(this.getRelating()).append("'");
        if (this.type.isModified()) {
            sb.append(" type='").append(this.getType()).append("'");
        }
        if (this.version.isModified()) {
            sb.append(" version='").append(this.getVersion()).append("'");
        }
        if (this.maxEntries.isModified()) {
            sb.append(" maxEntries='").append(this.getMaxEntries()).append("'");
        }
        if (this.maxEntriesCache.isModified()) {
            sb.append(" maxEntriesCache='").append(this.getMaxEntriesCache()).append("'");
        }
        if (this.maxBytes.isModified()) {
            sb.append(" maxBytes='").append(this.getMaxBytes()).append("'");
        }
        if (this.maxBytesCache.isModified()) {
            sb.append(" maxBytesCache='").append(this.getMaxBytesCache()).append("'");
        }
        if (this.onOverflow.isModified()) {
            sb.append(" onOverflow='").append(this.getOnOverflow()).append("'");
        }
        if (this.onFailure.isModified()) {
            sb.append(" onFailure='").append(this.getOnFailure()).append("'");
        }
        if (this.addressArr.length > 0 && this.addressArr[0] != null) {
            sb.append(">");
            int ii = 0;
            while (ii < this.addressArr.length) {
                AddressBase ad = this.addressArr[ii];
                sb.append(ad.toXml(extraOffset + " "));
                ++ii;
            }
            sb.append(offset).append("</").append(this.getRootTagName()).append(">");
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }

    public Global getGlobal() {
        return this.glob;
    }

    public Object clone() {
        QueuePropertyBase newOne = null;
        try {
            newOne = (QueuePropertyBase)super.clone();
            QueuePropertyBase queuePropertyBase = this;
            synchronized (queuePropertyBase) {
                newOne.maxEntries = (PropLong)this.maxEntries.clone();
                newOne.maxEntriesCache = (PropLong)this.maxEntriesCache.clone();
                newOne.maxBytes = (PropLong)this.maxBytes.clone();
                newOne.maxBytesCache = (PropLong)this.maxBytesCache.clone();
                newOne.type = (PropString)this.type.clone();
                newOne.version = (PropString)this.version.clone();
                newOne.onOverflow = (PropString)this.onOverflow.clone();
                newOne.onFailure = (PropString)this.onFailure.clone();
            }
            return newOne;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public final boolean getDebug() {
        return this.debug.getValue();
    }

    public final void setDebug(boolean debug) {
        this.debug.setValue(debug);
    }
}

