/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.queue;

import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.context.ContextNode;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.plugin.PluginManagerBase;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.StorageId;

public class QueuePluginManager
extends PluginManagerBase {
    private final String ME;
    private final Global glob;
    private final LogChannel log;
    private final String pluginEnvClass = "queue";
    public static final String pluginPropertyName = "QueuePlugin";
    private static final String[][] defaultPluginNames = new String[][]{{"RAM", "org.xmlBlaster.util.queue.ram.RamQueuePlugin"}, {"JDBC", "org.xmlBlaster.util.queue.jdbc.JdbcQueuePlugin"}, {"CACHE", "org.xmlBlaster.util.queue.cache.CacheQueueInterceptorPlugin"}};

    public QueuePluginManager(Global glob) {
        super(glob);
        this.glob = glob;
        this.log = glob.getLog("core");
        this.ME = "QueuePluginManager" + this.glob.getLogPrefixDashed();
        if (this.log.CALL) {
            this.log.call(this.ME, "Constructor QueuePluginManager");
        }
    }

    public I_Queue getPlugin(String typeVersion, StorageId storageId, QueuePropertyBase props) throws XmlBlasterException {
        return this.getPlugin(new PluginInfo(this.glob, (I_PluginManager)this, typeVersion, new ContextNode(this.glob, "queue", storageId.getPrefix(), this.glob.getContextNode())), storageId, props);
    }

    public I_Queue getPlugin(String type, String version, StorageId storageId, QueuePropertyBase props) throws XmlBlasterException {
        return this.getPlugin(new PluginInfo(this.glob, this, type, version, new ContextNode(this.glob, "queue", storageId.getPrefix(), this.glob.getContextNode())), storageId, props);
    }

    public I_Queue getPlugin(PluginInfo pluginInfo, StorageId storageId, QueuePropertyBase props) throws XmlBlasterException {
        if (pluginInfo.ignorePlugin()) {
            return null;
        }
        I_Queue plugin = (I_Queue)((Object)super.instantiatePlugin(pluginInfo, false));
        plugin.initialize(storageId, props);
        return plugin;
    }

    protected String getPluginPropertyName() {
        return pluginPropertyName;
    }

    protected void postInstantiate(I_Plugin plugin, PluginInfo pluginInfo) {
    }

    public String getDefaultPluginName(String type, String version) {
        int i = 0;
        while (i < defaultPluginNames.length) {
            if (defaultPluginNames[i][0].equalsIgnoreCase(type)) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Choosing for type=" + type + " plugin " + defaultPluginNames[i][1]);
                }
                return defaultPluginNames[i][1];
            }
            ++i;
        }
        this.log.warn(this.ME, "Choosing for type=" + type + " default plugin " + defaultPluginNames[0][1]);
        return defaultPluginNames[0][1];
    }
}

